<?php 
// 💡 بهینه‌سازی: باز کردن بافر برای ارسال پاسخ فوری به تلگرام
ob_start();

// -----------------------------------------------------------------------------------------------
$telegram_ip_ranges = [
['lower' => '149.154.160.0', 'upper' => '149.154.175.255'], // literally 149.154.160.0/20
['lower' => '91.108.4.0',    'upper' => '91.108.7.255'],    // literally 91.108.4.0/22
];
$ip_dec = (float) sprintf("%u", ip2long($_SERVER['REMOTE_ADDR']));
$ok=false;
foreach ($telegram_ip_ranges as $telegram_ip_range) if (!$ok) {
    $lower_dec = (float) sprintf("%u", ip2long($telegram_ip_range['lower']));
    $upper_dec = (float) sprintf("%u", ip2long($telegram_ip_range['upper']));
    if ($ip_dec >= $lower_dec and $ip_dec <= $upper_dec) $ok=true;
}
if (!$ok) die("No Way"); 
//-----------------------------------------------------------------------------------------------

// ⚡️ بهینه‌سازی‌های سرعت و پایداری برای Shared Hosting
set_time_limit(300); // افزایش زمان اجرای اسکریپت به 300 ثانیه
ignore_user_abort(true); // ادامه اجرای اسکریپت حتی پس از قطع ارتباط تلگرام

// ⚡️ ارسال پاسخ فوری به تلگرام (برای جلوگیری از Timeout و هنگ)
header('Connection: close');
header('Content-Length: ' . ob_get_length());
ob_end_flush();
flush(); 
// اکنون تلگرام پاسخ "OK" را دریافت کرده و اسکریپت می‌تواند کار سنگین را در پس‌زمینه انجام دهد.

//-----------------------------------------------------------------------------------------------
date_default_timezone_set('Asia/Tehran');
include "config.php";
include "jdf.php"; 
define('API_KEY',$API_KC);
//-----------------------------------------------------------------------------------------------
function factwebir($method,$datas=[]){
    $url = "https://api.telegram.org/bot".API_KEY."/".$method;
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,$datas);
    curl_setopt($ch,CURLOPT_TIMEOUT, 10); // 💡 بهینه‌سازی: تنظیم Timeout برای cURL
    $res = curl_exec($ch);
    if(curl_error($ch)){
        var_dump(curl_error($ch));
    }else{ 
        return json_decode($res);
    }
} 

// ⚡️ بهینه‌سازی: استفاده از کش مبتنی بر فایل برای Admin IDs
function get_admin_ids($connect) {
    $cache_file = 'admin_ids_cache.json';
    $cache_expiry = 300; // 5 دقیقه

    if (file_exists($cache_file) && (time() - filemtime($cache_file) < $cache_expiry)) {
        return json_decode(file_get_contents($cache_file), true);
    }

    $adminIds = [];
    $checkAdminIds = mysqli_query($connect, "SELECT idadmin FROM admins");
    while ($row = mysqli_fetch_assoc($checkAdminIds)) {
        $adminIds[] = $row['idadmin'];
    }

    file_put_contents($cache_file, json_encode($adminIds));

    return $adminIds;
}

$adminIds = get_admin_ids($connect);

//-----------------------------------------------------------------------------------------------
function bot_user($id,$what){ 
  $bye = factwebir('getChat',[
  'chat_id'=>$id,
  ]);
  return $bye->result->$what;
}
function safe($text)
    {
        global $connect;
        $text = $connect->real_escape_string($text);
        $array = ['$', ';', '"', "'", '<', '>'];
        return str_replace($array, null, $text);
    }
function Takhmin($fil){
if($fil <= 200 ){
return "2";
}else{
$besanie = $fil/200;
return ceil($besanie)+1;
}
}
function getChannelTitle($channel){
global $API_KC;
  // 💡 بهینه‌سازی: استفاده از factwebir (cURL) بجای file_get_contents
  $info = factwebir('getChat', ['chat_id' => $channel]);
  return $info->result->title;
}
function getChatstats($chat_id,$token) {
  // 💡 بهینه‌سازی: استفاده از factwebir (cURL) بجای file_get_contents
  $result = factwebir('getChatAdministrators', ['chat_id' => $chat_id]);
  return $result->ok;
}
function IsJoined($token,$User, array $Channels) {
    $AcceptedRoles = ['administrator', 'creator', 'member'];
    foreach($Channels as $iterator){
        // 💡 بهینه‌سازی: استفاده از factwebir (cURL) بجای file_get_contents
        $Req = factwebir('getChatMember', ['chat_id' => $iterator, 'user_id' => $User]);
        yield in_array($Req->result->status, $AcceptedRoles);
    }
}
function CanSendRequest($results){
    $ok = true;
    foreach($results as $result)
        if($result == false)
            $ok = false;
    return $ok;
}
function is_join($from_id,$Channel){
$forchaneel = factwebir('getChatMember',[
'chat_id'=>$Channel,
'user_id'=>$from_id]);
$tch = $forchaneel->result->status;
if($tch != 'member' && $tch != 'creator' && $tch != 'administrator' ){
return false;
}else{
return true; 
   }
}

// ----------------------------------------------------------------
// ⚡️ اصلاح خطای منطقی GD: تغییر $h++ به $y++ در حلقه داخلی
// ----------------------------------------------------------------

function creatbanner($patch) {
    global $from_id;
    global $bottag;
    global $API_KC;
    $w = 640; $h = 640; // original size
    $dest_path = "$from_id.png";
    $src = imagecreatefromstring(file_get_contents('https://api.telegram.org/file/bot'.$API_KC.'/'.$patch));
    $newpic = imagecreatetruecolor($w, $h);
    imagealphablending($newpic, false);
    $transparent = imagecolorallocatealpha($newpic, 0, 0, 0, 127);
    $r = $w / 2;
    for ($x = 0; $x < $w; $x++) {
        for ($y = 0; $y < $h; $y++) { // ✅ اصلاح: $y++
            $c = imagecolorat($src, $x, $y);
            $_x = $x - $w / 2;
            $_y = $y - $h / 2;
            if ((($_x * $_x) + ($_y * $_y)) < ($r * $r)) {
                imagesetpixel($newpic, $x, $y, $c);
            } else {
                imagesetpixel($newpic, $x, $y, $transparent);
            }
        }
    }
    imagesavealpha($newpic, true);
    imagepng($newpic, $dest_path);
    imagedestroy($newpic);
    imagedestroy($src);

    $t = imagecreatefrompng("$from_id.png");
    $x = imagesx($t);
    $y = imagesy($t);
    $s = imagecreatetruecolor(1000, 1000);
    imagealphablending($s, false);
    imagecopyresampled($s, $t, 0, 0, 0, 0, 1000, 1000, $x, $y);
    imagesavealpha($s, true);
    imagepng($s, "$from_id.png");
    imagedestroy($s);
    imagedestroy($t);
$mark="@$bottag";
    $stamp = imagecreatefrompng("$from_id.png");
    $im = imagecreatefromjpeg("other/baner.jpg");
    $marge_right = 1040;
    $marge_bottom = 650;
    $sx = imagesx($stamp);
    $sy = imagesy($stamp);
    // Add the watermark
$white = imagecolorallocate($im, 255, 255, 255);
$font = 'other/font.ttf'; // Replace with the path to your desired font file

// Calculate the width of the watermark text
$text_width = imageftbbox(150, 0, $font, "$mark");
$text_width = $text_width[2] - $text_width[0];

// Calculate the position to center the watermark text
$text_x = imagesx($im) - 2130;
$text_y = imagesy($im) - 170; // Adjust the value to increase or decrease the spacing from the bottom

imagefttext($im, 120, 0, $text_x, $text_y, $white, $font, "$mark");

imagecopy($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp));

header("Content-Type: image/png");
imagejpeg($im, "$from_id.png");
imagedestroy($im);
}
function creatbanner2($patch) {
    global $from_id;
    global $bottag;
    global $API_KC;
    $w = 640; $h = 640; // original size
    $dest_path = "$from_id.png";
    $src = imagecreatefromstring(file_get_contents('https://api.telegram.org/file/bot'.$API_KC.'/'.$patch));
    $newpic = imagecreatetruecolor($w, $h);
    imagealphablending($newpic, false);
    $transparent = imagecolorallocatealpha($newpic, 0, 0, 0, 127);
    $r = $w / 2;
    for ($x = 0; $x < $w; $x++) {
        for ($y = 0; $y < $h; $y++) { // ✅ اصلاح: $y++
            $c = imagecolorat($src, $x, $y);
            $_x = $x - $w / 2;
            $_y = $y - $h / 2;
            if ((($_x * $_x) + ($_y * $_y)) < ($r * $r)) {
                imagesetpixel($newpic, $x, $y, $c);
            } else {
                imagesetpixel($newpic, $x, $y, $transparent);
            }
        }
    }
    imagesavealpha($newpic, true);
    imagepng($newpic, $dest_path);
    imagedestroy($newpic);
    imagedestroy($src);

    $t = imagecreatefrompng("$from_id.png");
    $x = imagesx($t);
    $y = imagesy($t);
    $s = imagecreatetruecolor(1000, 1000);
    imagealphablending($s, false);
    imagecopyresampled($s, $t, 0, 0, 0, 0, 1000, 1000, $x, $y);
    imagesavealpha($s, true);
    imagepng($s, "$from_id.png");
    imagedestroy($s);
    imagedestroy($t);
$mark="@$bottag";
    $stamp = imagecreatefrompng("$from_id.png");
    $im = imagecreatefromjpeg("other/story.jpg");
    $marge_right = 405;
    $marge_bottom = 780;
    $sx = imagesx($stamp);
    $sy = imagesy($stamp);
    // Add the watermark
$white = imagecolorallocate($im, 255, 255, 255);
$font = 'other/font.ttf'; // Replace with the path to your desired font file

// Calculate the width of the watermark text
$text_width = imageftbbox(140, 0, $font, "$mark");
$text_width = $text_width[2] - $text_width[0];

// Calculate the position to center the watermark text
$text_x = imagesx($im) - 1400;
$text_y = imagesy($im) - 250; // Adjust the value to increase or decrease the spacing from the bottom

imagefttext($im, 100, 0, $text_x, $text_y, $white, $font, "$mark");

imagecopy($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp));

header("Content-Type: image/png");
imagejpeg($im, "$from_id.png");
imagedestroy($im);
}
function creatbanner3($patch) {
    global $from_id;
    global $bottag;
    global $API_KC;
    $w = 640; $h = 640; // original size
    $dest_path = "$from_id.png";
    $src = imagecreatefromstring(file_get_contents('https://api.telegram.org/file/bot'.$API_KC.'/'.$patch));
    $newpic = imagecreatetruecolor($w, $h);
    imagealphablending($newpic, false);
    $transparent = imagecolorallocatealpha($newpic, 0, 0, 0, 127);
    $r = $w / 2;
    for ($x = 0; $x < $w; $x++) {
        for ($y = 0; $y < $h; $y++) { // ✅ اصلاح: $y++
            $c = imagecolorat($src, $x, $y);
            $_x = $x - $w / 2;
            $_y = $y - $h / 2;
            if ((($_x * $_x) + ($_y * $_y)) < ($r * $r)) {
                imagesetpixel($newpic, $x, $y, $c);
            } else {
                imagesetpixel($newpic, $x, $y, $transparent);
            }
        }
    }
    imagesavealpha($newpic, true);
    imagepng($newpic, $dest_path);
    imagedestroy($newpic);
    imagedestroy($src);

    $t = imagecreatefrompng("$from_id.png");
    $x = imagesx($t);
    $y = imagesy($t);
    $s = imagecreatetruecolor(1000, 1000);
    imagealphablending($s, false);
    imagecopyresampled($s, $t, 0, 0, 0, 0, 1000, 1000, $x, $y);
    imagesavealpha($s, true);
    imagepng($s, "$from_id.png");
    imagedestroy($s);
    imagedestroy($t);
$mark="@$bottag";
    $stamp = imagecreatefrompng("$from_id.png");
    $im = imagecreatefromjpeg("other/x.jpg");
    $marge_right = 405;
    $marge_bottom = 780;
    $sx = imagesx($stamp);
    $sy = imagesy($stamp);
    // Add the watermark
$white = imagecolorallocate($im, 255, 255, 255);
$font = 'other/font.ttf'; // Replace with the path to your desired font file

// Calculate the width of the watermark text
$text_width = imageftbbox(140, 0, $font, "$mark");
$text_width = $text_width[2] - $text_width[0];

// Calculate the position to center the watermark text
$text_x = imagesx($im) - 1400;
$text_y = imagesy($im) - 250; // Adjust the value to increase or decrease the spacing from the bottom

imagefttext($im, 100, 0, $text_x, $text_y, $white, $font, "$mark");

imagecopy($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp));

header("Content-Type: image/png");
imagejpeg($im, "$from_id.png");
imagedestroy($im);
}

// -------------------------------------------------------------
function check_rps_winner($c1, $c2){
    if($c1 == $c2) return 0; 
    if(
        ($c1 == 'rock' && $c2 == 'scissors') || 
        ($c1 == 'paper' && $c2 == 'rock') || 
        ($c1 == 'scissors' && $c2 == 'paper')
    ) return 1; 
    return 2; 
}
// -------------------------------------------------------------

// -------------------------------------------------------------------------
function generate_party_token($length = 6) {
    return substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, $length);
}
// -------------------------------------------------------------------------

// =========================================================================
// ** توابع جدید برای اتصال به Gemini API (با مدل‌های 2.5 Flash) **
// =========================================================================

function get_telegram_file($file_path){
    global $API_KC;
    $url = "https://api.telegram.org/file/bot" . API_KEY . "/" . $file_path; 
    return file_get_contents($url);
}

function call_ai_api($prompt, $image_data = null) {
    // ⚠️ **حتماً این کلید را با کلید واقعی Gemini API خود جایگزین کنید**
    $ai_api_key = "AIzaSyBMLsw79eT7ZOff4U97OF9fqxeQ9sjxOcI"; 
    $url = "https://generativelanguage.googleapis.com/v1/models/";
    
    $parts = [];
    
    // استفاده از مدل gemini-2.5-flash برای سازگاری کامل
    $model_name = "gemini-2.5-flash"; 
    
    // اگر داده تصویری وجود داشته باشد (برای این نسخه کد حذف شده، اما تابع قابلیت آن را نگه می‌دارد)
    if ($image_data !== null) {
        $parts[] = [
            "inlineData" => [
                "mimeType" => "image/jpeg", 
                "data" => base64_encode($image_data)
            ]
        ];
    }
    
    // افزودن بخش متن (پرامپت)
    $parts[] = ["text" => $prompt];
    
    // ساختار کلی JSON مطابق با فرمت API
    $data = [
        "contents" => [
            [
                "parts" => $parts
            ]
        ]
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url . $model_name . ":generateContent?key=" . $ai_api_key);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
    
    $res = curl_exec($ch);
    curl_close($ch);
    
    $response_obj = json_decode($res, true);
    
    // بررسی و برگرداندن متن پاسخ
    if (isset($response_obj['candidates'][0]['content']['parts'][0]['text'])) {
        return $response_obj['candidates'][0]['content']['parts'][0]['text'];
    }
    
    // مدیریت خطاها
    if (isset($response_obj['error']['message'])) {
        return "❌ خطای API: " . $response_obj['error']['message'];
    }
    
    return "خطا در برقراری ارتباط با سرویس هوش مصنوعی یا دریافت پاسخ.";
}


// =========================================================================

#==========================================================================
if($user["spam"] < time()){ 
$tt = time() + 0.8;
$connect->query("UPDATE user SET spam = '$tt' WHERE id = '$from_id' LIMIT 1");
#==========================================================================
$update = json_decode(file_get_contents('php://input'));
$message = $update->message;
if(isset($message->from)){
$message_id = $message->message_id;
$text = safe($update->message->text);
$first_name = $message->from->first_name;
$user_name = $message->from->username;
$from_id = $message->from->id;
$chat_id = $message->chat->id;
$tc = $message->chat->type;
$caption = $update->message->caption;

// ** منطق جدید برای پیام خوش‌آمدگویی در گروه **
$new_chat_members = $message->new_chat_members;

// data
$user = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$from_id' LIMIT 1"));
}
if(isset($update->callback_query)){
$chat_id = $update->callback_query->message->chat->id;
$from_id = $update->callback_query->from->id;
$first_name= $update->callback_query->from->first_name;
$user_name = $update->callback_query->from->username;
$membercall = $update->callback_query->id;
$data = $update->callback_query->data;
$messageid = $update->callback_query->message->message_id;
// data
$user = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$from_id' LIMIT 1")); 
}
//-----------------------------------------------------------------------------------------------
$settings = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM settings WHERE botid = '$botid' LIMIT 1"));
$bot_mode = $settings['bot_mode'];
$is_all = $settings['is_all'];
$factwebir = $settings['factwebir']; 
$starttext= $settings['starttext']; 
$helptext = $settings['helptext']; 
$zarinpaymode = $settings['modepayzarin']; 
$cardpaymode = $settings['modepaycart']; 
$cryptopaymode = $settings['modepaycrypto']; 
$numbercardname = $settings['namecard']; 
$numbercard = $settings['numbercard']; 
$arzwallet = $settings['cryptoname']; 
$addresswallet = $settings['cryptowallet']; 

$ToDay = jdate('l'); 
$datenow = date('Y-m-d');
$date = gregorian_to_jalali(date('Y'), date('m'), date('d'), '/');
#========================کیبورد================================================

// ** کیبورد اصلی با دکمه‌های جدید پرامپت (فقط متنی) **
$usermenu=json_encode([
            	'keyboard'=>[
[['text'=>"🔗 به یه ناشناس وصلم کن!"]],
[['text'=>"لینک ناشناس من 📬"],['text'=>"💌 به مخاطب وصلم کن!"]],

[['text'=>"🥳 ساخت پارتی ناشناس"]],

[['text'=>"👨‍💻"],['text'=>"📊"],['text'=>"⚙️"],['text'=>"💳"]],
[['text'=>"✍️ تولید پرامپت متنی"]],
],
            	'resize_keyboard'=>true
       		]);

// ** کیبورد چت با دکمه بازی جدید **
$chat_menu_game=json_encode([
            	'keyboard'=>[
				[
				['text'=>"💬 پایان چت"],['text'=>"🚫 بلاکش کن"]
				],
                [
                ['text'=>"🎲 بازی سنگ، کاغذ، قیچی"] 
                ]
 	],
            	'resize_keyboard'=>true
       		]);

// ** کیبورد مخصوص پارتی ناشناس **
$party_menu=json_encode([
            	'keyboard'=>[
[['text'=>"❌ خروج از پارتی"]], 
],
            	'resize_keyboard'=>true
       		]);


$bannershop=json_encode([
            	'inline_keyboard'=>[
[['text'=>"🌁 دریافت بنر با عکس دلخواه",'callback_data'=>"bannercustomprof"]],
[['text'=>"💎 دریافت نام دلخواه",'callback_data'=>"bannercustom"]],

],
            	'resize_keyboard'=>true
       		]);
$settingsmenu=json_encode([
            	'keyboard'=>[
 [['text'=>"📭 صندوق پیام ها"],['text'=>"👤 حساب کاربری"]],
[['text'=>"⛔️ پاکسازی بلاک لیست"],['text'=>"🗑 حذف پیام های ارسالی"]],
[['text'=>"🖍 تغییر نام نمایشی"]],
[['text'=>"🖍 ویرایش جنسیت"],['text'=>"🖍 تغییر سن"]],
[['text'=>"🔙 برگشت"]],
],
            	'resize_keyboard'=>true
       		]);
         		
$backmenu=json_encode([
            	'keyboard'=>[
[['text'=>"🔙 برگشت"]],

],
            	'resize_keyboard'=>true
       		]);  
$laghv=json_encode([
            	'keyboard'=>[
[['text'=>"❌ انصراف"]],

],
            	'resize_keyboard'=>true
       		]);


// =========================================================================
// ** منطق مدیریت نوع چت و تمیز کردن متن برای گروه **
// =========================================================================

// ⚠️ **تنظیمات ربات خود را اینجا قرار دهید:**
$bot_id = 8149337335; // شناسه عددی ربات شما 
$bot_username = 'Qchtbot'; // یوزرنیم ربات شما 

$chat_type = $update->message->chat->type ?? null; 
$is_private = ($chat_type == 'private');
$is_group = ($chat_type == 'group' || $chat_type == 'supergroup');
$message_id = $update->message->message_id ?? null; // شناسه پیام کاربر برای ریپلای زدن

$text = $text ?? ''; // اطمینان از تعریف $text

// بررسی اینکه آیا به ربات ریپلای شده است؟
$is_reply_to_bot = (isset($update->message->reply_to_message) && $update->message->reply_to_message->from->id == $bot_id);
// بررسی اینکه آیا ربات در متن منشن شده است؟
$is_mentioned = (isset($bot_username) && strpos($text, $bot_username) !== false);

// متن را برای پردازش در گروه تمیز می‌کنیم (حذف منشن ربات از ابتدای متن)
$clean_text = $text;
if ($is_group && $is_mentioned) {
    // اگر متن با منشن شروع شده، آن را حذف می‌کنیم.
    $clean_text = trim(str_replace("@" . $bot_username, '', $text)); // @ را نیز حذف می‌کنیم
    // اگر متن بعد از حذف منشن خالی بود، باید نادیده گرفته شود
    if (empty($clean_text)) {
        // برای جلوگیری از پاسخ دادن به منشن‌های خالی، متن را به null تغییر می‌دهیم
        $clean_text = null; 
    }
}

// ** منطق پیام خوش‌آمدگویی هنگام اضافه شدن ربات به گروه و ارسال لاگ **
if (isset($new_chat_members)) {
    foreach ($new_chat_members as $member) {
        if ($member->id == $bot_id) {
            
            // 1. ارسال پیام خوش‌آمدگویی در گروه جدید
            factwebir('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "
🎉 **ربات پرامپت ساز هوشمند (AI) نصب شد!**
 
سلام، من یک ربات هوش مصنوعی برای ساخت پرامپت‌های جذاب و حرفه‌ای هستم.
 
💡 **نحوه استفاده در گروه:**
برای تولید پرامپت، کافی است **نام کاربری من (@{$bot_username})** را در پیام خود **منشن** کنید و سپس توضیحات خود را بنویسید (مثال: `@{$bot_username} یک کوه یخی زیبا با رنگ‌های نئونی`).
 
یا می‌توانید به یکی از پیام‌های من **ریپلای** بزنید و توضیحات پرامپت خود را ارسال کنید.
 
✨ **توجه:** برای کاربران عادی، محدودیت **۳۰ دقیقه** بین هر تولید اعمال می‌شود. می‌توانید با VIP کردن، این محدودیت را بردارید!",
                'reply_to_message_id' => $message_id
            ]);

            // 2. ساخت اطلاعات گروه برای لاگ و دیتابیس
            $group_title = $update->message->chat->title ?? "عنوان نامشخص";
            $group_username = $update->message->chat->username ?? null;
            $current_timestamp = time(); // استفاده از متغیر زمان فعلی
            
            // --- **ذخیره‌سازی اطلاعات در جدول groups** ---
            // ایمن‌سازی ورودی‌ها
            $safe_chat_id = $chat_id;
            $safe_title = $connect->real_escape_string($group_title); 
            $safe_username = ($group_username ? $connect->real_escape_string($group_username) : null);
            $safe_added_by_user_id = $from_id;
            
            // کوئری INSERT OR UPDATE
            $connect->query("
                INSERT INTO `groups` (`id`, `title`, `username`, `status`, `added_by_user_id`, `added_at`, `last_activity_at`) 
                VALUES (
                    '{$safe_chat_id}', 
                    '{$safe_title}', 
                    " . ($safe_username ? "'{$safe_username}'" : 'NULL') . ", 
                    'active', 
                    '{$safe_added_by_user_id}', 
                    '{$current_timestamp}', 
                    '{$current_timestamp}'
                )
                ON DUPLICATE KEY UPDATE 
                    `title` = VALUES(`title`), 
                    `username` = VALUES(`username`),
                    `status` = 'active',
                    `added_by_user_id` = VALUES(`added_by_user_id`),
                    `last_activity_at` = VALUES(`last_activity_at`)
            ");
            // --- **پایان ذخیره‌سازی** ---

            exit(); // از ادامه پردازش جلوگیری می‌کند
        }
    }
}
// =========================================================================

// ** منطق پردازش دستورات اصلی (AI) **
// =========================================================================

// اطمینان از اینکه متغیرهای کلیدی عددی هستند
$from_id = intval($from_id); // شناسه‌ی کاربر
$state = $user['state'] ?? 'none'; // مقدار پیش‌فرض اگر تعریف نشده باشد
$current_timestamp = time(); // زمان فعلی
$is_vip = (isset($user['vip']) && $user['vip'] == 'yes');


// ** مدیریت کلیک روی دکمه‌ها و تغییر State (فقط برای PV) **
if ($is_private) {

    if ($text == "✍️ تولید پرامپت متنی") {
        $connect->query("UPDATE user SET state = 'awaiting_text_for_prompt_gen' WHERE id = {$from_id}");
        
        // تعیین متن خوش‌آمدگویی و مزیت VIP
        $vip_message = "";
        if (!$is_vip) {
            $vip_message = "⏳ (حساب شما محدودیت ۳۰ دقیقه‌ای دارد. برای حذف محدودیت، VIP شوید)";
        } else {
            $vip_message = "✅ (حساب **VIP** شما فعال است: تولید نامحدود پرامپت!)";
        }

        factwebir('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "
📝 **آماده‌اید؟** لطفاً **توضیحات** خود (مثلاً: دریا دو نفره عاشقانه) را بنویسید تا پرامپت کامل آن را برای شما تولید کنم.
    
    {$vip_message}
    
(برای لغو، **❌ انصراف** را بزنید)",
            'reply_markup' => $laghv 
        ]);
        exit();
    } elseif ($text == "❌ انصراف" && $state == 'awaiting_text_for_prompt_gen') {
        // بازگشت به منوی اصلی و ریست کردن state
        $connect->query("UPDATE user SET state = 'none' WHERE id = {$from_id}");
        factwebir('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "عملیات لغو شد. به منوی اصلی برگشتیم.",
            'reply_markup' => $usermenu
        ]);
        exit();
    }
    // مدیریت دستورات (مانند /start) در حالت انتظار
    elseif (strpos($text, '/') === 0 && $state == 'awaiting_text_for_prompt_gen') {
        $connect->query("UPDATE user SET state = 'none' WHERE id = {$from_id}");
        factwebir('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "حالت انتظار تولید پرامپت لغو شد و دستور **{$text}** اجرا می‌شود.",
            'reply_markup' => $usermenu
        ]);
        exit(); 
    }

} // پایان بلاک $is_private برای مدیریت دکمه‌ها و state


// --------------------------------------------------------------------------------------------------
// ** منطق اصلی تولید پرامپت (مشترک بین PV و گروه) **
// --------------------------------------------------------------------------------------------------

$is_group_chat = false;
$prompt_description = null;

// ➡️ حالت 1: پردازش در چت خصوصی (استفاده از State)
if ($is_private && $state == 'awaiting_text_for_prompt_gen' && $text !== null && $text !== "❌ انصراف" && strpos($text, '/') !== 0) {
    // از $text اصلی استفاده می‌کنیم.
    $prompt_description = $text;
    $is_group_chat = false;
    
} 
// ➡️ حالت 2: پردازش در گروه (استفاده از ریپلای یا منشن)
elseif ($is_group && ($is_reply_to_bot || $is_mentioned) && !empty($clean_text)) {
    // از $clean_text استفاده می‌کنیم.
    $prompt_description = $clean_text;
    $is_group_chat = true;

} else {
    // اگر هیچ یک از شرایط AI فعال نشد، به منطق‌های دیگر ربات می‌رویم.
    goto end_ai_logic; 
}


// --- منطق محدودیت تایمری (30 دقیقه) و بررسی VIP ---

// ⭐️ شرط اشتراکی: اگر کاربر VIP نباشد، محدودیت 30 دقیقه‌ای اعمال می‌شود.
if (!$is_vip) { 
    
    $cooldown_seconds = 1800; // 30 دقیقه * 60 ثانیه
    $last_use_timestamp = (int)($user['last_ai_use_timestamp'] ?? 0); 
    $next_allowed_use_timestamp = $last_use_timestamp + $cooldown_seconds;

    // چک کردن محدودیت
    if ($last_use_timestamp > 0 && $current_timestamp < $next_allowed_use_timestamp) {
        
        // محاسبه زمان باقی‌مانده
        $time_remaining_seconds = $next_allowed_use_timestamp - $current_timestamp;
        $minutes_remaining = ceil($time_remaining_seconds / 60); 
        
        // در PV: ریست کردن state 
        if (!$is_group_chat) {
            $connect->query("UPDATE user SET state = 'none' WHERE id = {$from_id}");
        }
        
        // ** مدیریت دکمه در Cooldown (فقط برای PV) **
        $cooldown_text = "
⏰ **صبر کافیه! محدودیت 30 دقیقه‌ای شما فعال است.**
 
 شما باید **حدود {$minutes_remaining} دقیقه** صبر کنید تا بتوانید پرامپت جدیدی تولید کنید.
 
 ⚡️ **راه حل:** با ارتقاء حساب خود به **اشتراک ویژه (VIP)**، این محدودیت **بلافاصله** برداشته می‌شود و می‌توانید نامحدود پرامپت تولید کنید!
";
        
        $cooldown_reply_markup = null;
        if (!$is_group_chat) {
            // اگر PV است، دکمه را با متن جدید اضافه کن
            $cooldown_text .= "
➡️ **همین حالا VIP شوید تا این محدودیت برداشته شود:**
";
            $cooldown_reply_markup = json_encode([
                'inline_keyboard' => [
                    // تغییر متن دکمه برای PV
                    [['text' => "✨ خرید اشتراک VIP (تولید نامحدود)", 'callback_data' => 'peymentnow']] 
                ]
            ]);
        }
        
        factwebir('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $cooldown_text,
            'reply_markup' => $cooldown_reply_markup, // در گروه: null | در PV: دکمه
            // در گروه، به پیام کاربر ریپلای می‌زنیم
            'reply_to_message_id' => ($is_group_chat ? $message_id : null) 
        ]);
        exit();
    }
} 
// ----------------------------------------------------

// ارسال پیام در حال پردازش (شامل درخواست راهنمایی کاربر در گروه)
$processing_text = "⏳ در حال تولید پرامپت بر اساس توضیحات شما... لطفاً صبر کنید.";

if ($is_group_chat) {
    // 💡 اجرای خواسته شما: پیام پروسسینگ جذاب در گروه
    $processing_text = "
🔥 **چالش خلاقیت عمومی آغاز شد!**
 
**درخواست** کاربر: **\"{$prompt_description}\"**
 
✅ **وضعیت:** پرامپت قدرتمند شما در حال طراحی توسط هوش مصنوعی است...
 
✨ **یک نکته:** آیا ایده شما برای تولید این پرامپت را تایید می‌کنید؟ با **ریپلای** به همین پیام و ارسال یک 🚀، هیجان تولید آن را بالا ببرید!
 
**...لطفا منتظر بمانید تا شاهکار بعدی شما متولد شود!**
";
}

$processing_message = factwebir('sendMessage', [
    'chat_id' => $chat_id, 
    'text' => $processing_text,
    // در گروه، به پیام کاربر ریپلای می‌زنیم
    'reply_to_message_id' => ($is_group_chat ? $message_id : null) 
]);

$processing_message_id = $processing_message->result->message_id;

// پرامپت برای مدل
$ai_prompt = "Based on the user's description: '{$prompt_description}', generate a detailed and high-quality image generation prompt suitable for AI art models like Midjourney or Stable Diffusion. Only output the final prompt text. Respond in English and include relevant artistic styles and technical parameters (like --ar 16:9).";

// فراخوانی تابع AI
$prompt_result = call_ai_api($ai_prompt);

// --- به‌روزرسانی زمان آخرین استفاده پس از استفاده موفق ---
$db_update_query = "last_ai_use_timestamp = {$current_timestamp}";
// در PV، state را نیز ریست می‌کنیم.
if (!$is_group_chat) {
    $db_update_query .= ", state = 'none'";
}
$connect->query("UPDATE user SET {$db_update_query} WHERE id = {$from_id}");
// ----------------------------------------------------

// حذف پیام "در حال پردازش"
factwebir('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $processing_message_id]);

// ارسال نتیجه
factwebir('sendMessage', [
    'chat_id' => $chat_id,
    'text' => "
✨ **پرامپت پیشنهادی:**\n\n`" . $prompt_result . "`\n\n*(توضیحات شما: {$prompt_description})*

** این پرامپت ساخته شد توسط** 《 @Qchtbot 》",
    'parse_mode' => 'Markdown',
    // در PV، منوی اصلی را می‌فرستیم. در گروه، ریپلای می‌کنیم.
    'reply_markup' => ($is_group_chat ? null : $usermenu), 
    'reply_to_message_id' => ($is_group_chat ? $message_id : null) 
]);

// 💡 ایده جذاب: ترغیب به VIP بلافاصله بعد از استفاده موفق (فقط برای کاربران عادی)
if (!$is_vip) {
    
    // ** مدیریت دکمه در پیام بعد از تولید موفق (فقط برای PV) **
    $success_vip_text = "
🔔 **توجه:** پرامپت بعدی شما تا ۳۰ دقیقه دیگر قابل تولید نیست!
 
 آیا می‌خواهید **نامحدود** و **بدون انتظار** پرامپت بسازید؟
 ";
 
    $success_vip_reply_markup = null;
    if (!$is_group_chat) {
        // اگر PV است، دکمه را با متن جدید اضافه کن
        $success_vip_text .= "همین حالا VIP شوید! 👇";
        $success_vip_reply_markup = json_encode([
            'inline_keyboard' => [
                // تغییر متن دکمه برای PV
                [['text' => "🚀 ارتقاء به اشتراک VIP (تولید نامحدود)", 'callback_data' => 'peymentnow']]
            ]
        ]);
    }
    
    factwebir('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $success_vip_text,
        'reply_markup' => $success_vip_reply_markup, // در گروه: null | در PV: دکمه
        // در گروه، به پیام کاربر ریپلای می‌زنیم
        'reply_to_message_id' => ($is_group_chat ? $message_id : null) 
    ]);
}

exit(); 

end_ai_logic:

// ==========================================================================
// ** تعریف شناسه کانال لاگ **
// !!! این مقدار را با شناسه کانال لاگ خود جایگزین کنید (باید یک عدد منفی باشد) !!!
$log_channel_id = '-1002653010256'; // مثال: -100123456789

// ==========================================================================

if($bot_mode == "off" && !in_array($from_id,$adminIds)) { // تغییر $admins به $adminIds
if(isset($message->from)){
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"⭕️ ربات فعلا خاموش میباشد .",
'parse_mode'=>"HTML",
    		]); 
    		} 
    if(isset($data)){
    	factwebir('editMessagetext',[
   'chat_id'=>$chat_id,
   'message_id'=>$message_id,
'text'=>"⭕️ ربات فعلا خاموش میباشد .",
 'parse_mode'=>"HTML",
    		]); 
    }
}else{
if($user["step"] == "ban") {
if(isset($message->from)){
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📛 شما از ربات مسدود هستید .",
'parse_mode'=>"HTML",
    		]); 
    		}
    if(isset($data)){
    	factwebir('editMessagetext',[
   'chat_id'=>$chat_id,
   'message_id'=>$message_id,
'text'=>"📛 شما از ربات مسدود هستید .",
 'parse_mode'=>"HTML",
    		]); 
    } 
}else{

// -----------------------------------------------------------------------------------------------
// تعریف آرایه نقش‌ها
$party_roles = [
    '👑 حاکم', // نفر اول (سازنده)
    '🛡️ وزیر', // نفر دوم
    '⚔️ جنگجو', // نفر سوم
    '📜 کاتب', // نفر چهارم
    '👤 پیک', // نفر پنجم
];

// تعریف تابع بررسی محتوای پیام 
function is_content_safe($text) {
    global $filtered_words; // فرض می‌شود این آرایه شامل کلمات فیلتر شده است

    // ۱. بررسی لینک (http/https/www) یا آیدی (@)
    if (preg_match('/(http|https|www|\@)/i', $text)) {
        return false;
    }
    
    // ۲. بررسی کلمات فیلتر شده (فحش)
    if (isset($filtered_words) && is_array($filtered_words)) {
        foreach ($filtered_words as $word) {
            // استفاده از \b برای تطابق کامل کلمه
            if (preg_match('/\b' . preg_quote($word, '/') . '\b/i', $text)) {
                return false;
            }
        }
    }
    
    return true;
}


// -----------------------------------------------------------------------------------------------
// ** منطق تأیید خروج از پارتی (Callback Query: confirm_leave_party) **
// -----------------------------------------------------------------------------------------------
if (isset($data) && $data == "confirm_leave_party") {
    
    // پارتی توکن فعلی را از دیتابیس کاربر می‌گیریم
    $party_token = $user["current_party_token"];
    $party = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM parties WHERE token = '$party_token' AND is_active = 1 LIMIT 1"));
    
    if ($party) {
        $members = json_decode($party['members'], true);
        $is_creator_leaving = (strval($from_id) == strval($party['creator_id'])); // بررسی اینکه آیا فرد خارج شونده، سازنده است
        
        // ۱. حذف کاربر خارج شونده از لیست اعضا
        $key = array_search(strval($from_id), $members); // اطمینان از مقایسه با رشته
        if ($key !== false) {
            unset($members[$key]);
            $new_members = array_values($members); // Reindex array
            $new_members_json = $is_creator_leaving ? '[]' : json_encode($new_members); // اگر سازنده خارج شد، لیست اعضا در دیتابیس را خالی کن
            $new_count = $is_creator_leaving ? 0 : count($new_members); // اگر سازنده خارج شد، تعداد اعضا را صفر کن
            
            $connect->query("UPDATE parties SET members = '$new_members_json', member_count = $new_count WHERE token = '$party_token' LIMIT 1");
        }
        
        // ۲. به‌روزرسانی وضعیت کاربر خارج شونده
        $connect->query("UPDATE user SET current_party_token = NULL, party_role = NULL WHERE id = '$from_id' LIMIT 1");
        
        // ۳. ارسال پیام خروج (ویرایش پیام تأیید)
        factwebir('editMessagetext',[
            'chat_id'=>$chat_id,
            'message_id'=>$messageid,
            'text'=>"👋 شما با موفقیت از پارتی خارج شدید. بازگشت به منوی اصلی.",
        ]);
        
        // نمایش منوی اصلی به کاربر خارج شونده
        factwebir('sendmessage',['chat_id'=>$chat_id, 'text'=>"چه کاری برات انجام بدم؟", 'reply_markup'=>$usermenu]);
        
        // ۴. منطق انحلال پارتی در صورت خروج سازنده
        if ($is_creator_leaving) {
            
            // پارتی را غیرفعال کن (چه کسی مانده باشد چه نه)
            $connect->query("UPDATE parties SET is_active = 0 WHERE token = '$party_token' LIMIT 1");

            // اطلاع‌رسانی به اعضای باقی‌مانده (اعضای قبل از خروج سازنده)
            if (count($new_members) > 0) {
                
                $dissolve_message = "
⚠️ **هشدار: سازنده (👑 حاکم) پارتی را ترک کرد!**

❌ پارتی منحل شد و شما به طور خودکار از آن خارج شدید.

🥳 **می‌توانید پارتی ناشناس جدید خودتان را ایجاد کنید!**
";
                
                foreach ($new_members as $member_id) {
                    // به‌روزرسانی وضعیت اعضای باقی‌مانده
                    $connect->query("UPDATE user SET current_party_token = NULL, party_role = NULL WHERE id = '$member_id' LIMIT 1");
                    
                    // ارسال پیام انحلال و نمایش منوی اصلی
                    factwebir('sendmessage',[
                        'chat_id'=>$member_id,
                        'text'=>$dissolve_message,
                        'parse_mode'=>'Markdown',
                        'reply_markup'=>$usermenu // نمایش منوی اصلی برای امکان ساخت پارتی جدید
                    ]);
                }
            }
        
        } 
        // ۵. منطق خروج عضو عادی
        elseif ($new_count > 0) {
            // $user['party_role'] در اینجا نقش فردی است که در حال خروج است (احتمالاً 'member')
            $user_role_display = ($user['party_role'] == 'creator' && $from_id == $party['creator_id']) ? 'سازنده' : 'یک عضو'; 
            
            foreach ($new_members as $member_id) {
                if ($member_id != $from_id) {
                    factwebir('sendmessage',[
                        'chat_id'=>$member_id,
                        'text'=>"❌ $user_role_display از پارتی خارج شد. تعداد فعلی: $new_count/۵ نفر.",
                    ]);
                }
            }
        } 
        // ۶. منطق انحلال پارتی در صورت صفر شدن اعضا (خروج آخرین نفر)
        else {
            // اگر کسی نمانده، پارتی را غیرفعال کن
            $connect->query("UPDATE parties SET is_active = 0 WHERE token = '$party_token' LIMIT 1");
        }
        
        return; 
    } else {
        // اگر پارتی یافت نشد، پیام را ویرایش کن
        factwebir('editMessagetext',[
            'chat_id'=>$chat_id,
            'message_id'=>$messageid,
            'text'=>"❗️ پارتی‌ای برای خروج یافت نشد یا قبلاً منحل شده است.",
        ]);
        
        // اطمینان از پاک شدن وضعیت کاربر
        $connect->query("UPDATE user SET current_party_token = NULL, party_role = NULL WHERE id = '$from_id' LIMIT 1");
        factwebir('sendmessage',['chat_id'=>$chat_id, 'text'=>"بازگشت به منوی اصلی.", 'reply_markup'=>$usermenu]);
        return;
    }
}
// -----------------------------------------------------------------------------------------------
// ** منطق نمایش تأیید خروج (دکمه "❌ خروج از پارتی" یا Callback "leave_party") **
// -----------------------------------------------------------------------------------------------
if ((isset($data) && $data == "leave_party") || $text == "❌ خروج از پارتی") {
    
    // دکمه‌های تأیید
    $confirm_keyboard = json_encode([
        'inline_keyboard'=>[
            [
                ['text'=>"✅ تأیید خروج",'callback_data'=>"confirm_leave_party"],
                ['text'=>"لغو",'callback_data'=>"cancel_leave_party"]
            ]
        ]
    ]);

    $message_text = "❓ آیا مطمئن هستید که می‌خواهید از پارتی خارج شوید؟\nبا خروج، دیگر نمی‌توانید پیام‌های پارتی را دریافت/ارسال کنید.";

    if (isset($data)) {
        // اگر از دکمه شیشه‌ای (leave_party) آمده، پیام قبلی را ویرایش کن
        factwebir('editMessagetext',[
            'chat_id'=>$chat_id,
            'message_id'=>$messageid,
            'text'=>$message_text,
            'reply_markup'=>$confirm_keyboard
        ]);
    } else {
        // اگر از دکمه کیبورد (❌ خروج از پارتی) آمده، پیام جدید بفرست
         factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>$message_text,
            'reply_markup'=>$confirm_keyboard
        ]);
    }
    return;
}

// -----------------------------------------------------------------------------------------------
// ** منطق لغو خروج (Callback Query: cancel_leave_party) **
// -----------------------------------------------------------------------------------------------
if (isset($data) && $data == "cancel_leave_party") {
     factwebir('editMessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid,
        'text'=>"↩️ خروج از پارتی لغو شد. می‌توانید ادامه دهید.",
        'reply_markup'=>null // حذف دکمه‌های تأیید
    ]);
    // نمایش مجدد منوی پارتی (یا هر منوی دیگری)
    factwebir('sendmessage',['chat_id'=>$chat_id, 'text'=>"چه کاری برات انجام بدم؟", 'reply_markup'=>$party_menu]);
    return;
}

// -----------------------------------------------------------------------------------------------
// ** منطق لغو ساخت پارتی (Callback Query: cancel_party_creation) **
// -----------------------------------------------------------------------------------------------
if (isset($data) && $data == "cancel_party_creation") {
     factwebir('editMessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid,
        'text'=>"↩️ ساخت پارتی لغو شد. به منوی اصلی باز می‌گردید.",
        'reply_markup'=>null // حذف دکمه‌های تأیید
    ]);
    // نمایش منوی اصلی
    factwebir('sendmessage',['chat_id'=>$chat_id, 'text'=>"چه کاری برات انجام بدم؟", 'reply_markup'=>$usermenu]);
    return;
}

// -----------------------------------------------------------------------------------------------
// ** منطق تأیید و ساخت پارتی (Callback Query: create_party_confirmed) **
// -----------------------------------------------------------------------------------------------
if (isset($data) && $data == "create_party_confirmed") {
    
    // ۱. بررسی وضعیت کاربر (برای اطمینان)
    if ($user["current_party_token"] != null) {
         factwebir('editMessagetext',[
            'chat_id'=>$chat_id,
            'message_id'=>$messageid,
            'text'=>"❗️ شما در حال حاضر در یک پارتی فعال هستید. ابتدا از آن خارج شوید.",
            'reply_markup'=>$party_menu
        ]);
        return;
    }

    // ۲. تولید توکن و زمان انقضا (۱ ساعت)
    $party_token = generate_party_token(6);
    $expiration_time = time() + 3600; // ۱ ساعت بعد (Unix Timestamp)
    $created_at_db = date('Y-m-d H:i:s');
    $from_id_str = strval($from_id); // تبدیل به رشته برای JSON
    
    // ۳. درج پارتی جدید در دیتابیس
    $connect->query("INSERT INTO parties (token, creator_id, members, member_count, max_members, created_at, expire_at, is_active) 
                           VALUES ('$party_token', '$from_id', '[\"$from_id_str\"]', 1, 5, '$created_at_db', '$expiration_time', 1)");
                           
    // ۴. به‌روزرسانی وضعیت کاربر
    $connect->query("UPDATE user SET current_party_token = '$party_token', party_role = 'creator' WHERE id = '$from_id' LIMIT 1");
    
    // ۵. ویرایش پیام تأیید به پیام موفقیت‌آمیز
    $bot_username_info = factwebir('getMe',[]);
    // ** توجه: یوزرنیم ربات را از تابع getMe دریافت می‌کنیم **
    $bot_username = $bot_username_info->result->username; 
    $join_link = "https://t.me/" . $bot_username . "?start=joinparty_" . $party_token;

    // تعریف دکمه‌های شیشه‌ای
    $inline_keyboard = json_encode([
        'inline_keyboard'=>[
            [
['text'=>"🔗 اشتراک‌گذاری پارتی",'url'=>"https://t.me/share/url?url=$join_link&text=🔥%20بیا%20تو%20گپ%20ناشناس%20من!%0A%0A🤫%20اینجا%20هیچکس%20نمیدونه%20کی%20داری%20حرف%20میزنی!%20فقط%20برای%2060%20دقیقه!%20ظرفیت%20محدود!%0A%0A$join_link"],
                ['text'=>"📋 کپی توکن",'callback_data'=>"copy_token_$party_token"] 
            ]
        ]
    ]);
    
    // پیام اصلی
    factwebir('editMessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid,
        'text'=>"
🎉 **پارتی ناشناس شما ایجاد شد!**

🌟 توکن شما: ` $party_token ` 
⏰ انقضا: ۶۰ دقیقه دیگر
👥 ظرفیت: ۱/۵ نفر
        
این توکن یا لینک را به دوستانتان بفرستید تا ناشناس با هم گپ بزنید:
",
        'parse_mode'=>'Markdown',
        'reply_markup'=>$inline_keyboard // نمایش دکمه‌های شیشه‌ای
    ]);
    
    // ۶. نمایش منوی پارتی (کیبورد اصلی)
    factwebir('sendmessage',[
        'chat_id'=>$chat_id,
        'text'=>"همچنین، می‌توانید از کیبورد زیر برای پایان پارتی استفاده کنید و یا شروع به ارسال پیام کنید:",
        'reply_markup'=>$party_menu 
    ]);
    
    return;
}

// -----------------------------------------------------------------------------------------------
// ** منطق ارسال پیام در پارتی ناشناس **
// -----------------------------------------------------------------------------------------------
elseif (isset($message->text) && $user["current_party_token"] != null && $text != "❌ انصراف") {
    $party_token = $user["current_party_token"];
    $party = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM parties WHERE token = '$party_token' AND is_active = 1 LIMIT 1"));
    
    if (!$party) {
        $connect->query("UPDATE user SET current_party_token = NULL, party_role = NULL WHERE id = '$from_id' LIMIT 1");
        factwebir('sendmessage',['chat_id'=>$from_id, 'text'=>"❌ پارتی شما منقضی یا توسط سازنده لغو شده است.", 'reply_markup'=>$usermenu]);
        return;
    } else {

        $members = json_decode($party['members'], true);
        $expire_at = $party['expire_at']; 

        // ۱. بررسی انقضای زمانی (۱ ساعت)
        if (time() > $expire_at) {
            $connect->query("UPDATE parties SET is_active = 0 WHERE token = '$party_token' LIMIT 1");
            foreach ($members as $member_id) {
                $connect->query("UPDATE user SET current_party_token = NULL, party_role = NULL WHERE id = '$member_id' LIMIT 1");
                factwebir('sendmessage',['chat_id'=>$member_id, 'text'=>"⏰ **پارتی ناشناس منقضی شد!** (۶۰ دقیقه به پایان رسید).", 'parse_mode'=>'Markdown', 'reply_markup'=>$usermenu]);
            }
            return;
        }
        
        // ۲. بررسی محدودیت‌های محتوا
        if (!is_content_safe($text)) {
             factwebir('sendmessage',[
                'chat_id'=>$from_id,
                'text'=>"⚠️ **ارسال لینک، آیدی یا کلمات نامناسب ممنوع است.** لطفاً پیام خود را ویرایش کنید.",
                'parse_mode'=>'Markdown'
            ]);
            return;
        }
        
        // ۳. بررسی تعداد اعضا
        if ($party['member_count'] <= 1) {
             factwebir('sendmessage',[
                'chat_id'=>$from_id,
                'text'=>"👥 **کسی تو گپ نیست!**\nحداقل ۲ نفر باید در پارتی باشند تا بتوانید پیام ارسال کنید.",
                'parse_mode'=>'Markdown'
            ]);
            return;
        }

        // ۴. آماده‌سازی پیام و نشانه (شامل دریافت یوزرنیم فرستنده)
        $sender_role_data = mysqli_fetch_assoc(mysqli_query($connect,"SELECT party_role, username FROM user WHERE id = '$from_id' LIMIT 1"));
        $sender_username = $sender_role_data['username'] ? "@" . $sender_role_data['username'] : "ندارد"; 
        
        // تعیین نشانه بر اساس جایگاه عضو
        $member_index = array_search(strval($from_id), $members);
        $member_index = ($member_index === false) ? 0 : $member_index; 
        $name_display = $party_roles[$member_index] ?? '👤 عضو ناشناس';
        
        // شروع ساخت لاگ (شامل یوزرنیم فرستنده)
        $log_text = "
#PartyLog | 💬 پیام جدید

🔹 **توکن پارتی:** `$party_token`
🔸 **فرستنده:** `$from_id` ($sender_username) (`$name_display`)

---
**متن پیام:**
$text
---
**گیرندگان (IDs / Usernames):**
";
        $receiver_ids_list = "";
        
        // 👇 تغییرات اعمال شده:
        // ۱. تبدیل Unix Timestamp زمان انقضا به فرمت ساعت و دقیقه
        $expire_time_display = date('H:i', $expire_at); 

        // قالب پیام برای گیرنده
        $receiver_message = "
👤 :  **$name_display:**
------------
📜 : `$text`
------------
⏰ **Time out:** `$expire_time_display`
"; 

        foreach ($members as $member_id) {
            if ($member_id != $from_id) {
                // دریافت یوزرنیم گیرنده برای لاگ
                $receiver_data = mysqli_fetch_assoc(mysqli_query($connect,"SELECT username FROM user WHERE id = '$member_id' LIMIT 1"));
                $receiver_username = $receiver_data['username'] ? "@" . $receiver_data['username'] : "ندارد";
                
                // ارسال به گیرنده
                factwebir('sendmessage',[
                    'chat_id'=>$member_id,
                    'text'=>$receiver_message,
                    'parse_mode'=>'Markdown'
                ]);
                $receiver_ids_list .= "• `$member_id` ($receiver_username)\n"; // افزودن یوزرنیم به لاگ
            }
        }
        
        // ۶. ارسال لاگ نهایی به کانال
        $log_text .= $receiver_ids_list;

        factwebir('sendmessage',[
            'chat_id'=>$log_channel_id,
            'text'=>$log_text,
            'parse_mode'=>'Markdown'
        ]);
        
        return; 
    }
}

// -----------------------------------------------------------------------------------------------
// ** منطق دکمه ساخت پارتی (شروع فرآیند نمایش قوانین) **
// -----------------------------------------------------------------------------------------------
elseif($text=="🥳 ساخت پارتی ناشناس" && $tc=="private"){
    
    // ۱. بررسی وضعیت کاربر
    if ($user["current_party_token"] != null) {
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"❗️ شما در حال حاضر در یک پارتی فعال هستید. ابتدا از آن خارج شوید.",
            'reply_markup'=>$party_menu
        ]);
        return;
    }
    
    // ۲. نمایش قوانین و دکمه‌های تأیید/لغو
    $rules_text = " 
📜 **قوانین و راهنمای ساخت پارتی ناشناس:**

1.  **ناشناس بودن:** هویت شما برای سایر اعضا مخفی می‌ماند. (به جز نام جایگاه‌تان: حاکم، وزیر و غیره).

2.  **ظرفیت و زمان:** هر پارتی حداکثر ۵ نفر ظرفیت دارد و ۶۰ دقیقه پس از ساخت منقضی می‌شود.

3.  **ممنوعیت‌ها:** ارسال **لینک، آیدی (@)، و محتوای نامناسب/فحش** در پارتی ممنوع است و ربات پیام شما را حذف می‌کند.

4.  **شروع گپ:** برای شروع چت، حداقل **۲ نفر** باید در پارتی باشند.

5.  **مدیریت:** شما به عنوان سازنده (حاکم)، می‌توانید در صورت نیاز پارتی را لغو کنید (به شرط اینکه کسی عضو نشده باشد).

    ❓ **آیا با این شرایط موافقید و می‌خواهید پارتی را ایجاد کنید؟**

";

    $confirm_keyboard = json_encode([
        'inline_keyboard'=>[
            [
                ['text'=>"✅ تأیید و ساخت پارتی",'callback_data'=>"create_party_confirmed"],
                ['text'=>"❌ لغو",'callback_data'=>"cancel_party_creation"]
            ]
        ]
    ]);

    factwebir('sendmessage',[
        'chat_id'=>$chat_id,
        'text'=>$rules_text,
        'parse_mode'=>'Markdown',
        'reply_markup'=>$confirm_keyboard // نمایش دکمه‌های تأیید/لغو
    ]);

    return; // پایان منطق اینجا
}
// -----------------------------------------------------------------------------------------------
// ** منطق دکمه‌های شیشه‌ای (Callback Query) - کپی توکن (اصلاح شده) **
// -----------------------------------------------------------------------------------------------
elseif(isset($data) && preg_match('/^copy_token_(.*)/',$data)) {
    $token_to_copy = str_replace("copy_token_","",$data);
    
    // ** ایجاد لینک کامل برای کپی (رفع باگ) **
    $bot_username_info = factwebir('getMe',[]);
    $bot_username = $bot_username_info->result->username;
    $join_link = "https://t.me/" . $bot_username . "?start=joinparty_" . $token_to_copy;


    // ۱. ارسال لینک کامل به کاربر در قالب یک پیام جدید (راه حل برای کپی)
    factwebir('sendmessage',[
        'chat_id'=>$chat_id,
        'text'=>"**لینک پارتی برای کپی کردن:** \n\n`$join_link`\n\n_لطفاً متن بالا را کپی کنید._",
        'parse_mode'=>'Markdown'
    ]);
    
    // ۲. ارسال پیام موقت برای اطلاع‌رسانی به کاربر که لینک ارسال شد
    factwebir('answerCallbackQuery', [
        'callback_query_id' => $update->callback_query->id,
        'text' => "لینک کامل در چت برای شما ارسال شد. می‌توانید آن را کپی کنید.",
        'show_alert' => false,
        'cache_time' => 5
    ]);
}
// -----------------------------------------------------------------------------------------------
// ** منطق عمومی دکمه ها و /start **
// -----------------------------------------------------------------------------------------------
elseif($text=="/start" || $text=="🔙 برگشت" || $text=="🔙 منو کاربری" && $tc=="private"){
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
// به‌روزرسانی منو در زمان چت یا پارتی
if($user["current_party_token"] != null)
{
    // اگر کاربر در پارتی بود، منوی پارتی را نمایش بده
     factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"💬 شما در حال حاضر در **پارتی ناشناس** فعال هستید. پیام خود را ارسال کنید یا پارتی را ترک کنید.",
	'parse_mode'=>'Markdown',
	'reply_markup'=>$party_menu 
    		]); 
}
elseif($user["step"] == "chat" || $user["step"] == "game_rps") // استفاده از منوی چت جدید
{
     factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"🤖 پیام سیستم 👇
	
`❗️ شما در حال گفت‌وگو هستید.`
🌟 برای مدیریت چت یا شروع بازی هم میتونی از دکمه های زیر استفاده کنی 👇🏻",
    'reply_to_message_id'=>$message_id,
	'parse_mode'=>'Markdown',
	'reply_markup'=>$chat_menu_game // استفاده از کیبورد جدید
    		]); 
}
else // منوی اصلی
{
    if ($user["id"] != true){
    // ثبت کاربر جدید
    $connect->query("INSERT INTO user (id, step,step2, member,  name , sex , old , stats , blocklist , vip ,username,side , time,expirevip,spam,joindate,game_choice, current_party_token, party_role) VALUES 
                              ('$from_id', 'none','none', '0', '$first_name' , '' , '' , '' , '' , 'no', '$user_name', '', '', 'none','0','$datenow','', NULL, NULL)");
    	factwebir('sendmessage',[
    	'chat_id'=>$chat_id,
    	'text'=>$starttext,
    'parse_mode'=>"HTML",
          'reply_markup'=>$usermenu
    		]);    
    }
    else{
        // نمایش منوی اصلی برای کاربر موجود
    	factwebir('sendmessage',[
    	'chat_id'=>$chat_id,
    	'text'=>$starttext,
    'parse_mode'=>"HTML",
          'reply_markup'=>$usermenu
    		]);
    $connect->query("UPDATE user SET step ='none',step2='none' WHERE id = '$from_id' LIMIT 1");    		
    }
}
}
}

elseif(preg_match('/^(\/start)(.*)/',$text)  && $tc=="private"){
//... (منطق /start ثابت باقی می‌ماند) ...
$start = str_replace("/start ","",$text);

// -----------------------------------------------------------------------------------------------
// ** منطق پیوستن به پارتی (joinparty_) **
// -----------------------------------------------------------------------------------------------
if (preg_match('/^(joinparty_)(.*)/',$start)) {
    $join_token = str_replace("joinparty_","",$start);
    
    // ۱. بررسی وضعیت کاربر
    if ($user["current_party_token"] != null) {
        factwebir('sendmessage',['chat_id'=>$chat_id,'text'=>"❗️ شما در حال حاضر در پارتی با توکن `".$user['current_party_token']."` هستید. ابتدا از آن خارج شوید.", 'parse_mode'=>'Markdown', 'reply_markup'=>$party_menu]);
        return;
    }
    
    // ۲. منطق پیوستن به پارتی
    $party = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM parties WHERE token = '$join_token' AND is_active = 1 LIMIT 1"));
    
    if (!$party) {
        factwebir('sendmessage',['chat_id'=>$chat_id,'text'=>"❗️ توکن پارتی نامعتبر یا منقضی شده است.", 'reply_markup'=>$usermenu]);
    } elseif ($party['member_count'] >= $party['max_members']) {
        factwebir('sendmessage',['chat_id'=>$chat_id,'text'=>"❗️ ظرفیت این پارتی تکمیل شده است (۵/۵).", 'reply_markup'=>$usermenu]);
    } else {
        // ۳. به‌روزرسانی دیتابیس پارتی
        $members_array = json_decode($party['members'], true);
        
        // اگر کاربر قبلاً عضو شده است
        if (in_array(strval($from_id), $members_array)) {
            factwebir('sendmessage',['chat_id'=>$chat_id,'text'=>"❗️ شما قبلاً به این پارتی ملحق شده‌اید.", 'reply_markup'=>$party_menu]);
            $connect->query("UPDATE user SET current_party_token = '$join_token', party_role = 'member' WHERE id = '$from_id' LIMIT 1");
            return;
        }

        $members_array[] = strval($from_id);
        $new_members_json = json_encode($members_array);
        $new_count = $party['member_count'] + 1;
        
        $connect->query("UPDATE parties SET members = '$new_members_json', member_count = $new_count WHERE token = '$join_token' LIMIT 1");
        
        // اگر کاربر در جدول user نبود، او را ثبت کرده و سپس وضعیت پارتی را به‌روز کن
        if (!$user["id"]) {
            $connect->query("INSERT INTO user (id, step, step2, member, name, sex, old, stats, blocklist, vip, username, side, time, expirevip, spam, joindate, game_choice, current_party_token, party_role) 
                             VALUES ('$from_id', 'none', 'none', '0', '$first_name', '', '', '', '', 'no', '$user_name', '', '', 'none', '0', '$datenow', '', '$join_token', 'member')");
        } else {
            $connect->query("UPDATE user SET current_party_token = '$join_token', party_role = 'member' WHERE id = '$from_id' LIMIT 1");
        }
        
        // ۴. ارسال پیام به عضو جدید و سایر اعضا
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"🎉 **شما به پارتی ناشناس با توکن `$join_token` ملحق شدید!**
👥 ظرفیت: $new_count/۵ نفر. تمام پیام‌های شما در این محیط کاملاً ناشناس به سایر اعضا ارسال خواهد شد.",
            'parse_mode'=>'Markdown',
            'reply_markup'=>$party_menu // نمایش منوی پارتی
        ]);
        
        // ارسال نوتیفیکیشن به سایر اعضا
        foreach ($members_array as $member_id) {
            if ($member_id != $from_id) {
                factwebir('sendmessage',[
                    'chat_id'=>$member_id,
                    'text'=>"👤 **یک عضو جدید به پارتی شما ملحق شد.**
👥 تعداد فعلی: $new_count/۵ نفر.",
                    'parse_mode'=>'Markdown'
                ]);
            }
        }
    }
}
// -----------------------------------------------------------------------------------------------
// ** منطق ارسال پیام ناشناس (pm_) **
// -----------------------------------------------------------------------------------------------
elseif(preg_match('/^(pm_)(.*)/',$start)){
$getuser2 = str_replace("pm_","",$start);
$getuser = base64_decode($getuser2);    
$user = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$getuser' LIMIT 1"));
$user1 = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$from_id' LIMIT 1"));
$plusmember = $user["name"];
$chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"t2aid_$getuser"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{        
$userside = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$getuser' LIMIT 1"));
$all = explode("^",$userside["blocklist"]);
if(!in_array($from_id, $all)){       
    if($getuser==$from_id){
     	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"اینکه آدم گاهی با خودش حرف بزنه خوبه ، ولی اینجا نمیتونی به خودت پیام ناشناس بفرستی ! :)

                        چه کاری برات انجام بدم؟"
    		]);   
    }
    else{
   if($user1["id"]==true){   
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
     'text' => "📝 شما در حال ارسال پیام به $plusmember هستید",
	     'reply_markup'=>$laghv
    		]);
$connect->query("UPDATE user SET step ='sendpmnow1' WHERE id = '$from_id' LIMIT 1");
$connect->query("UPDATE user SET step2 ='$getuser' WHERE id = '$from_id' LIMIT 1");
    		
}
else{
    	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
     'text' => "📝 شما در حال ارسال پیام به $plusmember هستید",
	    'reply_markup'=>$laghv
    		]);
 $connect->query("INSERT INTO user (id, step,step2, member,  name , sex , old , stats , blocklist , vip ,username,side , time,expirevip,spam,joindate,game_choice, current_party_token, party_role) VALUES 
                           ('$from_id', 'sendpmnow1','$getuser', '0', '$first_name' , '' , '' , '' , '' , 'no', '$user_name', '', '', 'none','0','$datenow','', NULL, NULL)"); // party_columns added
   
}
}
}
else{
 	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"این کاربر شما را بلاک کرده است"
    		]);     
}
}
}}

// -----------------------------------------------------------------------------------------------



// -----------------------------------------------------------------------------------------------

elseif($user["step"] == "sendpmnow1" and $text !="❌ انصراف"){
//... (منطق ارسال پیام ناشناس تک به تک) ...
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
$getme=$user["step2"];  
if($user['vip']=="yes"){
    // ================== LOGIC FOR VIP USER (CAN SEND MEDIA) ==================

    // Logging function for media
    $media_log_template = "📥 مدیا جدید در پی‌وی ناشناس (VIP).\n👤 فرستنده: <code>$from_id</code>\n📬 گیرنده: <code>$getme</code>";
    $text_log_template = "📝 پیام متنی جدید در پی‌وی ناشناس (VIP).\n👤 فرستنده: <code>$from_id</code>\n📬 گیرنده: <code>$getme</code>\n\nمتن پیام:\n$text";
    
    if(isset($message->video)) {
        $file_id = $message->video->file_id;
        $caption = $message->caption;
        $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','video', '$from_id','$getme','no','$date')");
        
        // Log the video
        factwebir('forwardMessage', [
            'chat_id' => $log_channel_id,
            'from_chat_id' => $from_id,
            'message_id' => $message_id,
        ]);
        factwebir('sendmessage', [
            'chat_id' => $log_channel_id,
            'text' => $media_log_template,
            'parse_mode' => 'HTML',
        ]);
    }
    
    if(isset($message->document)) {
        $file_id = $message->document->file_id;
        $caption = $message->caption;
        $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','document', '$from_id','$getme','no','$date')");  
        
        // Log the document
        factwebir('forwardMessage', [
            'chat_id' => $log_channel_id,
            'from_chat_id' => $from_id,
            'message_id' => $message_id,
        ]);
        factwebir('sendmessage', [
            'chat_id' => $log_channel_id,
            'text' => $media_log_template,
            'parse_mode' => 'HTML',
        ]);
    }
    
    if(isset($message->photo)) {
        $photo = $message->photo;
        $file_id = $photo[count($photo)-1]->file_id;
        $caption = $message->caption;
        $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','photo', '$from_id','$getme','no','$date')");  
        
        // Log the photo
        factwebir('forwardMessage', [
            'chat_id' => $log_channel_id,
            'from_chat_id' => $from_id,
            'message_id' => $message_id,
        ]);
        factwebir('sendmessage', [
            'chat_id' => $log_channel_id,
            'text' => $media_log_template,
            'parse_mode' => 'HTML',
        ]);
    } 
    
    if(isset($message->voice)) {
        $file_id = $message->voice->file_id;
        $caption = $message->caption;
        $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','voice', '$from_id','$getme','no','$date')");  
        
        // Log the voice
        factwebir('forwardMessage', [
            'chat_id' => $log_channel_id,
            'from_chat_id' => $from_id,
            'message_id' => $message_id,
        ]);
        factwebir('sendmessage', [
            'chat_id' => $log_channel_id,
            'text' => $media_log_template,
            'parse_mode' => 'HTML',
        ]);
    }
    
    if(isset($message->audio)) {
        $file_id = $message->audio->file_id;
        $caption = $message->caption;
        $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','audio', '$from_id','$getme','no','$date')");  
        
        // Log the audio
        factwebir('forwardMessage', [
            'chat_id' => $log_channel_id,
            'from_chat_id' => $from_id,
            'message_id' => $message_id,
        ]);
        factwebir('sendmessage', [
            'chat_id' => $log_channel_id,
            'text' => $media_log_template,
            'parse_mode' => 'HTML',
        ]);
    }
    
    if(isset($message->sticker)) {
        $file_id = $message->sticker->file_id;
        $caption = $message->caption;
        $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','sticker', '$from_id','$getme','no','$date')");  
        
        // Log the sticker
        factwebir('forwardMessage', [
            'chat_id' => $log_channel_id,
            'from_chat_id' => $from_id,
            'message_id' => $message_id,
        ]);
        factwebir('sendmessage', [
            'chat_id' => $log_channel_id,
            'text' => $media_log_template,
            'parse_mode' => 'HTML',
        ]);
    }
    
    if(isset($message->text)) {
        $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$text','none','text', '$from_id','$getme','no','$date')");
        
        // Log the text
        factwebir('sendmessage', [
            'chat_id' => $log_channel_id,
            'text' => $text_log_template,
            'parse_mode' => 'HTML',
        ]);
    } 
    
    // Check if any message part was sent before sending confirmation
    if (isset($message->video) || isset($message->document) || isset($message->photo) || isset($message->voice) || isset($message->audio) || isset($message->sticker) || isset($message->text)) {
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"✅ پیام شما با موفقیت به صورت ناشناس به طرف مقابل ارسال شد",
            'reply_markup'=>$usermenu
        ]);
        factwebir('sendmessage',[
            'chat_id'=>$getme,
            'text'=>"یک پیام جدید دارید برای مشاهده پیام دستور /newmsg را ارسال کنید"
        ]);
        $connect->query("UPDATE user SET step ='none' WHERE id = '$from_id' LIMIT 1");
        $connect->query("UPDATE user SET step2 ='none' WHERE id = '$from_id' LIMIT 1");    		
    }
    // ==========================================================================
    
} else {
    // ================== LOGIC FOR NON-VIP USER (TEXT ONLY) ==================
    if(!isset($message->text)){
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"❌ شما کاربر ویژه نیستید و فقط مجاز به ارسال متن هستید!",
            'reply_markup'=>json_encode([
                'inline_keyboard'=>[
                    [['text'=>"💎 تغییر به حساب ویژه",'callback_data'=>"peymentnow"]],
                ],
                'resize_keyboard'=>true
            ])
        ]);    
    } else {
        // Text is present, so send and log it
        $log_text = "📝 پیام متنی جدید در پی‌وی ناشناس (عادی).\n👤 فرستنده: <code>$from_id</code>\n📬 گیرنده: <code>$getme</code>\n\nمتن پیام:\n$text";
        factwebir('sendmessage', [
            'chat_id' => $log_channel_id,
            'text' => $log_text,
            'parse_mode' => 'HTML',
        ]);
        
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"✅ پیام شما با موفقیت به صورت ناشناس به طرف مقابل ارسال شد
            "
        ,'reply_markup'=>$usermenu
            ]);
            factwebir('sendmessage',[
            'chat_id'=>$getme,
            'text'=>"یک پیام جدید دارید برای مشاهده پیام دستور /newmsg را ارسال کنید"
        ]);
        $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$text','none','text', '$from_id','$getme','no','$date')");      		
        $connect->query("UPDATE user SET step ='none' WHERE id = '$from_id' LIMIT 1");
        $connect->query("UPDATE user SET step2 ='none' WHERE id = '$from_id' LIMIT 1");    		  
    }
    // ==========================================================================
}
}
}
elseif($text == "❌ انصراف"){
  	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>$starttext,
'reply_to_message_id'=>$message_id,
      'reply_markup'=>$usermenu
    		]);
$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	 
$connect->query("UPDATE user SET step2 = 'none' WHERE id = '$from_id' LIMIT 1");	     		
}
// ------------------------------------------------------------------------------------------------
// ** منطق شروع بازی سنگ، کاغذ، قیچی **
elseif($text == "🎲 بازی سنگ، کاغذ، قیچی"){
    
    // مطمئن می‌شویم کاربر در حالت چت است
    if($user["step"] == "chat" && $user["side"] != "0"){
        $opponent_id = $user["side"];
        $opponent_user = mysqli_fetch_assoc(mysqli_query($connect,"SELECT step FROM user WHERE id = '$opponent_id' LIMIT 1"));
        
        // بررسی وضعیت کاربر مقابل (باید در چت باشد تا بتواند بازی کند)
        if($opponent_user["step"] == "chat"){
            
            // درخواست بازی از کاربر مقابل (ارسال درخواست)
            factwebir('sendmessage',[
                'chat_id'=>$opponent_id,
                'text'=>"📢 کاربر مقابل شما را به یک بازی **سنگ، کاغذ، قیچی** دعوت کرده است!
                لطفا روی یکی از دکمه‌های زیر کلیک کنید.",
                'parse_mode'=>'HTML',
                'reply_markup'=>json_encode([
                    'inline_keyboard'=>[
                        [['text'=>"✅ قبول می‌کنم",'callback_data'=>"rps_accept_$from_id"]],
                        [['text'=>"❌ رد می‌کنم",'callback_data'=>"rps_reject_$from_id"]]
                    ]
                ])
            ]);
            
            factwebir('sendmessage',[
                'chat_id'=>$chat_id,
                'text'=>"✅ درخواست بازی برای طرف مقابل ارسال شد. منتظر پاسخ بمانید.",
                'reply_to_message_id'=>$message_id,
            ]);
            
        } else {
            factwebir('sendmessage',[
                'chat_id'=>$chat_id,
                'text'=>"❌ کاربر مقابل در حال حاضر در وضعیت چت فعال نیست.",
            ]);
        }
    } else {
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"❌ برای شروع بازی، باید در یک چت فعال باشید.",
        ]);
    }
}
// ------------------------------------------------------------------------------------------------

// =====================================================================
// ** منطق دکمه "💬 پایان چت" (اصلاح شده) **
elseif($text == "💬 پایان چت"){
    // **شرط اصلاح شده:** مقایسه زمان یونیکس ذخیره شده با زمان یونیکس فعلی
    // $user["time"] باید حاوی زمان یونیکس (timestamp) + 7 ثانیه باشد.
    if($user["time"] <= time()){
        
        // اگر در بازی بود، اول بازی را لغو کن
        if($user["step"] == "game_rps"){
            $connect->query("UPDATE user SET step = 'chat', step2 = 'none', game_choice = '' WHERE id = '$from_id' LIMIT 1");
            $connect->query("UPDATE user SET step = 'chat', step2 = 'none', game_choice = '' WHERE id = '{$user["side"]}' LIMIT 1");
            
            factwebir('sendmessage',[
                'chat_id'=>$user["side"],
                'text'=>"🚫 بازی سنگ، کاغذ، قیچی توسط کاربر مقابل لغو شد. می‌توانید دوباره چت کنید یا بازی جدیدی شروع کنید.",
                'reply_markup'=>$chat_menu_game
            ]);
            
            factwebir('sendmessage',[
                'chat_id'=>$chat_id,
                'text'=>"✅ بازی لغو شد. برای پایان دادن به چت اقدام می‌کنید.",
                'reply_to_message_id'=>$message_id,
            ]);
        }
        
        // ادامه منطق پایان چت
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"🤖 پیام سیستم 👇 
    
    🗣 `ایا از پایان دادن به گفت و گو  با طرف مقابلت اطمینان داری ؟`",
            'reply_to_message_id'=>$message_id,
            'parse_mode'=>'Markdown',
            'reply_markup'=>json_encode([
                'inline_keyboard'=>[
                    [
                        ['text'=>"✅ بله",'callback_data'=>"endy"],
                        ['text'=>"❌ خیر",'callback_data'=>"endn"]
                    ],
                ]
            ])
        ]);	
    }
    else
    {
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"🤖 پیام سیستم 👇 
    
    ❗️ `تازه شروع به چت کردی برای پایان دادن بهش یکم زود نیست ؟ حداقل 7 ثانیه صبر کن`
    🗣 `دوست نداری با طرف مقابلت احوال پرسی کنی ؟`",
            'reply_to_message_id'=>$message_id,
            'parse_mode'=>'Markdown',
        ]);	
    }
}
// =====================================================================
// ** منطق Callback Queryهای بازی **
elseif(preg_match('/^rps_accept_(.*)/',$data)){
    $opponent_id = str_replace("rps_accept_","",$data);
    $requestor_user = mysqli_fetch_assoc(mysqli_query($connect,"SELECT step, side FROM user WHERE id = '$opponent_id' LIMIT 1"));
    
    if($requestor_user["step"] == "chat" && $requestor_user["side"] == $from_id){
        
        // 1. به‌روزرسانی وضعیت هر دو کاربر به حالت بازی
        $connect->query("UPDATE user SET step = 'game_rps', step2 = 'rps_waiting', game_choice = '' WHERE id = '$from_id' LIMIT 1");
        $connect->query("UPDATE user SET step = 'game_rps', step2 = 'rps_waiting', game_choice = '' WHERE id = '$opponent_id' LIMIT 1");
        
        $game_menu = json_encode([
            'inline_keyboard'=>[
                [['text'=>"✊ سنگ",'callback_data'=>"rps_play_rock"], ['text'=>"🖐 کاغذ",'callback_data'=>"rps_play_paper"], ['text'=>"✌️ قیچی",'callback_data'=>"rps_play_scissors"]],
            ]
        ]);
        
        // 2. ارسال پیام شروع بازی و منوی انتخاب برای هر دو کاربر
        factwebir('editMessagetext',[
            'chat_id'=>$chat_id,
            'message_id'=>$messageid,
            'text'=>"✅ بازی شروع شد! **انتخاب خود را انجام دهید.**",
            'reply_markup'=>$game_menu
        ]);
        
        factwebir('sendmessage',[
            'chat_id'=>$opponent_id,
            'text'=>"✅ کاربر مقابل درخواست بازی شما را پذیرفت! **انتخاب خود را انجام دهید.**",
            'reply_markup'=>$game_menu
        ]);
        
    } else {
        factwebir('editMessagetext',[
            'chat_id'=>$chat_id,
            'message_id'=>$messageid,
            'text'=>"❌ درخواست منقضی شد! کاربر مقابل دیگر در چت نیست یا وضعیتش تغییر کرده است.",
        ]);
    }
}

elseif(preg_match('/^rps_reject_(.*)/',$data)){
    $opponent_id = str_replace("rps_reject_","",$data);
    factwebir('editMessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid,
        'text'=>"❌ درخواست بازی رد شد.",
    ]);
    factwebir('sendmessage',[
        'chat_id'=>$opponent_id,
        'text'=>"❌ کاربر مقابل درخواست بازی **سنگ، کاغذ، قیچی** شما را رد کرد.",
        'reply_markup'=>$chat_menu_game
    ]);
}

elseif(preg_match('/^rps_play_(.*)/',$data) && $user["step"] == "game_rps"){
    
    $choice = str_replace("rps_play_","",$data); // rock, paper, or scissors
    $opponent_id = $user["side"];
    $opponent_user = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$opponent_id' LIMIT 1"));
    $opponent_choice = $opponent_user["game_choice"];
    
    // اگر کاربر قبلا انتخاب کرده باشد، اجازه انتخاب مجدد ندارد
    if($user["step2"] == "rps_played"){
        factwebir('answerCallbackQuery', [
            'callback_query_id' => $membercall,
            'text' => "⚠️ شما قبلاً انتخاب خود را ثبت کرده‌اید. منتظر حریف باشید.",
            'show_alert' => true
        ]);
        return;
    }
    
    // 1. کاربر انتخاب خود را ثبت می‌کند
    $connect->query("UPDATE user SET step2 = 'rps_played', game_choice = '$choice' WHERE id = '$from_id' LIMIT 1");
    
    // 2. به‌روزرسانی پیام برای کاربر انتخاب‌کننده
    $choice_display = ['rock' => '✊ سنگ', 'paper' => '🖐 کاغذ', 'scissors' => '✌️ قیچی'];
    
    factwebir('editMessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid,
        'text'=>"✅ انتخاب شما: **{$choice_display[$choice]}** ثبت شد!
منتظر انتخاب طرف مقابل بمانید.",
        'parse_mode'=>'Markdown'
    ]);
    
    // 3. بررسی نوبت کاربر مقابل
    if ($opponent_user["step2"] == "rps_played") {
        
        // --- هر دو کاربر بازی کرده‌اند، اعلام نتیجه ---
        
        $winner_id = 0; // 0 = مساوی
        $result = check_rps_winner($choice, $opponent_choice);
        
        // تعیین برنده
        if ($result == 1) $winner_id = $from_id; // خود کاربر برنده شد
        elseif ($result == 2) $winner_id = $opponent_id; // حریف برنده شد
        
        // 4. بازگشت به حالت چت و اعلام نتیجه به هر دو کاربر
        $connect->query("UPDATE user SET step = 'chat', step2 = 'none', game_choice = '' WHERE id = '$from_id' LIMIT 1");
        $connect->query("UPDATE user SET step = 'chat', step2 = 'none', game_choice = '' WHERE id = '$opponent_id' LIMIT 1");
        
        // متن‌های نتیجه
        $choice_fa = $choice_display[$choice];
        $opponent_choice_fa = $choice_display[$opponent_choice];

        if ($winner_id == 0) {
            $win_text = "❌ **نتیجه: مساوی!**\nهر دو **$choice_fa** انتخاب کردید.";
            $opp_win_text = $win_text;
        } elseif ($winner_id == $from_id) {
            $win_text = "🎉 **شما بردید!**\nانتخاب شما: **$choice_fa**\nانتخاب او: **$opponent_choice_fa**";
            $opp_win_text = "😔 **شما باختید!**\nانتخاب شما: **$opponent_choice_fa**\nانتخاب او: **$choice_fa**";
        } else {
            $win_text = "😔 **شما باختید!**\nانتخاب شما: **$choice_fa**\nانتخاب او: **$opponent_choice_fa**";
            $opp_win_text = "🎉 **شما بردید!**\nانتخاب شما: **$opponent_choice_fa**\nانتخاب او: **$choice_fa**";
        }
        
        // 5. ارسال نتیجه به کاربر فعلی (A)
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"🤖 **پایان بازی سنگ، کاغذ، قیچی!**\n$win_text\n\nبه چت ادامه دهید:",
            'parse_mode'=>'Markdown',
            'reply_markup'=>$chat_menu_game
        ]);
        
        // 6. ارسال نتیجه به کاربر مقابل (B)
        factwebir('sendmessage',[
            'chat_id'=>$opponent_id,
            'text'=>"🤖 **پایان بازی سنگ، کاغذ، قیچی!**\n$opp_win_text\n\nبه چت ادامه دهید:",
            'parse_mode'=>'Markdown',
            'reply_markup'=>$chat_menu_game
        ]);
        
    } else {
        // --- کاربر مقابل هنوز بازی نکرده است ---
        factwebir('sendmessage',[
            'chat_id'=>$opponent_id,
            'text'=>"📢 کاربر مقابل انتخاب خود را انجام داد. نوبت شماست که سریعتر انتخاب کنید.",
            // نیازی به ارسال کیبورد مجدد نیست چون قبلا در rps_accept ارسال شده است
        ]);
    }
}
// ** پایان منطق Callback Queryهای بازی **

elseif($data=="endy"){
//... (منطق endy ثابت باقی می‌ماند) ...
         factwebir('deletemessage',[
          'chat_id'=>$chat_id,
          'message_id'=>$messageid,
           ]);	
        factwebir('sendmessage',[
                'chat_id'=>$chat_id,
	'text'=>"✅ `گفت و گوی شما با طرف مقابلت توسط شما بسته شد .`

🌟 در مورد طرف مقابلت چه کاری برات انجام بدم ؟
از منوی پایین انتخاب کن 👇🏻",
'parse_mode'=>'Markdown',
'reply_markup'=>json_encode([
            	'keyboard'=>[
[				
			['text'=>"🚫 بلاکش کن"]
				],
					 [
                ['text'=>"🔙 برگشت"]
                ]
 	],
            	'resize_keyboard'=>true
       		])
    		]);
			
factwebir('sendmessage',[
	'chat_id'=>$user["side"],
	'text'=>"✅ `گفت و گوی شما با طرف مقابلت توسط طرف مقابلت بسته شد .`

🌟 در مورد طرف مقابلت چه کاری برات انجام بدم ؟
از منوی پایین انتخاب کن 👇🏻",
'parse_mode'=>'Markdown',
'reply_markup'=>json_encode([
            	'keyboard'=>[
[				
			['text'=>"🚫 بلاکش کن"]
				],
					 [
                ['text'=>"🔙 برگشت"]
                ]
 	],
            	'resize_keyboard'=>true
       		])
    		]);	
$connect->query("UPDATE user SET step = 'none',side='0',time='' WHERE id = '$from_id' LIMIT 1");	
$connect->query("UPDATE user SET step = 'none',side='0',time='' WHERE id = '{$user["side"]}' LIMIT 1");		
}
elseif($data=="bly"){
//... (منطق bly ثابت باقی می‌ماند) ...
         factwebir('deletemessage',[
          'chat_id'=>$chat_id,
          'message_id'=>$messageid,
           ]);	
        factwebir('sendmessage',[
                'chat_id'=>$chat_id,
	'text'=>"✅ گفت و گوی شما با طرف مقابلت توسط شما بسته شد .
	
⭕️ کاربر با موفقیت به بلاک لیست شما اضافه شد .
از منوی پایین انتخاب کن 👇🏻",
'reply_markup'=>json_encode([
            	'keyboard'=>[
					 [
                ['text'=>"🔙 برگشت"]
                ]
 	],
            	'resize_keyboard'=>true
       		])
    		]);
factwebir('sendmessage',[
	'chat_id'=>$user["side"],
	'text'=>"✅ گفت و گوی شما با طرف مقابلت توسط طرف مقابلت بسته شد .

🌟 در مورد طرف مقابلت چه کاری برات انجام بدم ؟
از منوی پایین انتخاب کن 👇🏻",
'reply_markup'=>json_encode([
            	'keyboard'=>[
[				
			['text'=>"🚫 بلاکش کن"]
				],
					 [
                ['text'=>"🔙 برگشت"]
                ]
 	],
            	'resize_keyboard'=>true
       		])
    		]);	
$connect->query("UPDATE user SET blocklist = CONCAT (blocklist,'{$user["side"]}^') WHERE id = '$from_id' LIMIT 1");	
$connect->query("UPDATE user SET step = 'none',side='0',time='' WHERE id = '$from_id' LIMIT 1");	
$connect->query("UPDATE user SET step = 'none',side='0',time='' WHERE id = '{$user["side"]}' LIMIT 1");	
}
elseif($data=="endn"){
           factwebir('editmessagetext',[
                'chat_id'=>$chat_id,
                'message_id'=>$messageid,
               'text'=>"🤖 پیام سیستم 👇 
			   
`✅ درخواست شما لغو و چت بسته نشده . به احوال پرسی با طرف مقابلت ادامه بده`",
'parse_mode'=>'Markdown',
           ]);
}
// ====================================================
#===================دریافت لینک ناشناس من========
elseif(($text == "لینک ناشناس من 📬" || $text == "/link") && $tc=="private"){
    // [بررسی عضویت کانال]
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = [];
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }

    // اگر کاربر عضو کانال‌های اجباری نیست
    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        // ساخت دکمه‌های عضویت و پیام مربوطه (بدون تغییر)
        for ($i=0; $i <= $fil; $i++){
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null ){
                if(is_join($from_id,$okk) == false ){
                    $d4[] = [['text'=>"$namechannel",'url'=>$link]];
                }
            }  
        } 
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 
            ▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    }else{  
        // ارسال لینک ناشناس (بدون تغییر)
        $encoded = base64_encode($from_id);   
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"سلام $first_name هستم 🤚
            
            لینک زیر رو لمس کن و هر حرفی که تو دلت هست یا هر انتقادی که نسبت به من داری رو با خیال راحت بنویس و بفرست. بدون اینکه از اسمت باخبر بشم پیامت به من می‌رسه. خودتم می‌تونی امتحان کنی و از بقیه بخوای راحت و ناشناس بهت پیام بفرستن، حرفای خیلی جالبی می‌شنوی! 😉
            👇👇👇👇👇
            
            https://t.me/$bottag?start=pm_$encoded
            ",
            'disable_web_page_preview'=>true
        ]);  
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"☝️ پیام بالا رو به دوستات و گروه‌هایی که می‌شناسی فـوروارد کن یا لـینک داخلش رو تو شبکه‌های اجتماعی بذار و توئیت کن، تا بقیه بتونن بهت پیام ناشناس بفرستن. پیام‌ها از طریق همین برنامه بهت می‌رسه.
            
            🔻 اگه میخوای پیامت متفاوت باشه میتونی از دکمه های زیر استفاده کنی👇🏻👇🏻👇🏻",
            'reply_markup' => $bannershop
        ]); 	
    }
}
elseif ($data == "bannerstory") {
    // [بررسی عضویت کانال]
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = [];
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }
    
    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        // منطق عدم عضویت در کانال‌ها
        for ($i=0; $i <= $fil; $i++){
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null ){
                if(is_join($from_id,$okk) == false ){
                    $d4[] = [['text'=>"$namechannel",'url'=>$link]];
                }
            }  
        } 
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 
            ▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    }else{  
        // ساخت بنر استوری (همیشه رایگان)
        $encoded = base64_encode($from_id);       
        $id=factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"♻️ در حال ساخت استوری اختصاصی شما برای اینستاگرام...",
        ])->result;	
        $msg_iddd = $id->message_id;
        $getuserphoto = factwebir('getUserProfilePhotos',['user_id'=>"$from_id"])->result->photos[0][2]->file_id;
        if(!$getuserphoto){
            factwebir('deletemessage',[
                'chat_id'=>$chat_id,
                'message_id'=>$msg_iddd,
            ]);  
            factwebir('answercallbackquery', [
                'callback_query_id' =>$membercall,
                'text' => "⚠️ برای ساخت بنر با عکس پروفایل خود لطفا بخش Profile Photo را در بخش تنظیمات روی Everybody تنظیم کنید",
                'show_alert' =>true
            ]);  
            exit;       
        }
        $patch = factwebir('getfile',['file_id'=>$getuserphoto])->result->file_path;
        creatbanner2("$patch");  
        factwebir('sendphoto', [
            'chat_id' => $chat_id,
            'photo'=>new CURLFile("$from_id.png"),
            'caption'=>"
            
            <b>
👤 لینک اختصاصی:

https://t.me/$bottag?start=pm_$encoded</b>

",
            'parse_mode' => 'HTML',
            'disable_web_page_preview'=>true,
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [
                        [
                            'text' => '♻️ ربات پیام ناشناس', // Button text
                            'url' => "https://t.me/$bottag", // This will share the message in the same chat
                        ],
                    ],
                ]
            ])
        ]); 
        unlink("$from_id.png");        
        factwebir('deletemessage',[
            'chat_id'=>$chat_id,
            'message_id'=>$msg_iddd,
        ]);    
    }
}
elseif ($data == "bannerpost") {
    // [بررسی عضویت کانال]
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = [];
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }
    
    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        // منطق عدم عضویت در کانال‌ها
        for ($i=0; $i <= $fil; $i++){
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null ){
                if(is_join($from_id,$okk) == false ){
                    $d4[] = [['text'=>"$namechannel",'url'=>$link]];
                }
            }  
        } 
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 
            ▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    }else{  
        // ساخت بنر پست (همیشه رایگان)
        $encoded = base64_encode($from_id);       
        $id=factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"♻️ در حال ساخت پست اختصاصی شما برای اینستاگرام...",
        ])->result;	
        $msg_iddd = $id->message_id;
        $getuserphoto = factwebir('getUserProfilePhotos',['user_id'=>"$from_id"])->result->photos[0][2]->file_id;
        if(!$getuserphoto){
            factwebir('deletemessage',[
                'chat_id'=>$chat_id,
                'message_id'=>$msg_iddd,
            ]);  
            factwebir('answercallbackquery', [
                'callback_query_id' =>$membercall,
                'text' => "⚠️ برای ساخت بنر با عکس پروفایل خود لطفا بخش Profile Photo را در بخش تنظیمات روی Everybody تنظیم کنید",
                'show_alert' =>true
            ]);  
            exit;       
        }
        $patch = factwebir('getfile',['file_id'=>$getuserphoto])->result->file_path;
        creatbanner("$patch");  
        factwebir('sendphoto', [
            'chat_id' => $chat_id,
            'photo'=>new CURLFile("$from_id.png"),
            'caption'=>"
                        <b>
سلام $first_name هستم 🤚
            
            لینک زیر رو لمس کن و هر حرفی که تو دلت هست یا هر انتقادی که نسبت به من داری رو با خیال راحت بنویس و بفرست. بدون اینکه از اسمت باخبر بشم پیامت به من می‌رسه. خودتم می‌تونی امتحان کنی و از بقیه بخوای راحت و ناشناس بهت پیام بفرستن، حرفای خیلی جالبی می‌شنوی! 😉
            👇👇👇👇👇  </b>          
            https://t.me/$bottag?start=pm_$encoded

",
            'parse_mode' => 'HTML',
            'disable_web_page_preview'=>true
        ]);  
        factwebir('deletemessage',[
            'chat_id'=>$chat_id,
            'message_id'=>$msg_iddd,
        ]);    
        unlink("$from_id.png");    
    }
}
elseif ($data == "bannermyprof") {
    // [بررسی عضویت کانال]
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = [];
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }
    
    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        // منطق عدم عضویت در کانال‌ها
        for ($i=0; $i <= $fil; $i++){
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null ){
                if(is_join($from_id,$okk) == false ){
                    $d4[] = [['text'=>"$namechannel",'url'=>$link]];
                }
            }  
        } 
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 
            ▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    }else{  
        // ساخت بنر با عکس پروفایل (VIP حذف شد - اکنون کاملا رایگان است)
        $encoded = base64_encode($from_id);       
        $id=factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"♻️ در حال ساخت بنر با عکس پروفایل شما...",
        ])->result;	
        $msg_iddd = $id->message_id;
        $getuserphoto = factwebir('getUserProfilePhotos',['user_id'=>"$from_id"])->result->photos[0][2]->file_id;
        if(!$getuserphoto){
            factwebir('deletemessage',[
                'chat_id'=>$chat_id,
                'message_id'=>$msg_iddd,
            ]);  
            factwebir('answercallbackquery', [
                'callback_query_id' =>$membercall,
                'text' => "⚠️ برای ساخت بنر با عکس پروفایل خود لطفا بخش Profile Photo را در بخش تنظیمات روی Everybody تنظیم کنید",
                'show_alert' =>true
            ]);  
            exit;       
        }
        factwebir('sendphoto', [
            'chat_id' => $chat_id,
            'photo'=>$getuserphoto,
            'caption'=>"
            
            <b>
👤 لینک اختصاصی:

https://t.me/$bottag?start=pm_$encoded</b>

",
            'parse_mode' => 'HTML',
            'disable_web_page_preview'=>true,
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [
                        [
                            'text' => '♻️ ربات پیام ناشناس', // Button text
                            'url' => "https://t.me/$bottag", // This will share the message in the same chat
                        ],
                    ],
                ],
            ])
        ]);  
        factwebir('deletemessage',[
            'chat_id'=>$chat_id,
            'message_id'=>$msg_iddd,
        ]);    
    }
    
}
elseif ($data == "bannercustomprof") {
    // [بررسی عضویت کانال]
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = [];
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }
    
    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        // منطق عدم عضویت در کانال‌ها
        for ($i=0; $i <= $fil; $i++){
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null ){
                if(is_join($from_id,$okk) == false ){
                    $d4[] = [['text'=>"$namechannel",'url'=>$link]];
                }
            }  
        } 
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 
            ▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    }else{  
        // ساخت بنر با عکس دلخواه (VIP حذف شد - اکنون کاملا رایگان است)
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"✅ برای ساخت بنر با عکس دلخواه ، تصویر مورد نظر خود را ارسال کنید

⚠️ برای تنظیم مناسب عکس پیشنهاد میشود سایز تصویر 640 در 640 باشد",
            'reply_markup' => $backmenu
        ]);
        
        $connect->query("UPDATE user SET step = 'setbannercustom' WHERE id = '$from_id' LIMIT 1");	 
    }
}
elseif ($user['step'] == "setbannercustom" && $text !="🔙 برگشت") {
    $photo = $update->message->photo;
    if(isset($photo)){
        $photofile = $photo[count($photo)-1]->file_id;
        $encoded = base64_encode($from_id);       
        $id=factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"♻️ در حال ساخت بنر با عکس دلخواه شما...",
        ])->result;	
        $msg_iddd = $id->message_id;
        $patch = factwebir('getfile',['file_id'=>$photofile])->result->file_path;
        creatbanner("$patch");  
        factwebir('sendphoto', [
            'chat_id' => $chat_id,
            'photo'=>new CURLFile("$from_id.png"),
            'caption'=>"
                        <b>
سلام $first_name هستم 🤚
            
            لینک زیر رو لمس کن و هر حرفی که تو دلت هست یا هر انتقادی که نسبت به من داری رو با خیال راحت بنویس و بفرست. بدون اینکه از اسمت باخبر بشم پیامت به من می‌رسه. خودتم می‌تونی امتحان کنی و از بقیه بخوای راحت و ناشناس بهت پیام بفرستن، حرفای خیلی جالبی می‌شنوی! 😉
            👇👇👇👇👇  </b>          
            https://t.me/$bottag?start=pm_$encoded

",
            'parse_mode' => 'HTML',
            'disable_web_page_preview'=>true,
            'reply_markup'=>$usermenu
        ]);
        factwebir('deletemessage',[
            'chat_id'=>$chat_id,
            'message_id'=>$msg_iddd,
        ]);     
        unlink("$from_id.png");             
        $connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	    
    }
    else{
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"❌ فقط عکس مجاز است",
        ]);   
    }
}
elseif ($data == "bannerx") {
    // [بررسی عضویت کانال]
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = [];
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }
    
    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        // منطق عدم عضویت در کانال‌ها
        for ($i=0; $i <= $fil; $i++){
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null ){
                if(is_join($from_id,$okk) == false ){
                    $d4[] = [['text'=>"$namechannel",'url'=>$link]];
                }
            }  
        } 
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 
            ▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    }else{  
        // ساخت بنر توییتر (VIP حذف شد - اکنون کاملا رایگان است)
        $encoded = base64_encode($from_id);       
        $id=factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"♻️ در حال ساخت بنر اختصاصی شما برای توییتر...",
        ])->result;	
        $msg_iddd = $id->message_id;
        $getuserphoto = factwebir('getUserProfilePhotos',['user_id'=>"$from_id"])->result->photos[0][2]->file_id;
        if(!$getuserphoto){
            factwebir('deletemessage',[
                'chat_id'=>$chat_id,
                'message_id'=>$msg_iddd,
            ]);  
            factwebir('answercallbackquery', [
                'callback_query_id' =>$membercall,
                'text' => "⚠️ برای ساخت بنر با عکس پروفایل خود لطفا بخش Profile Photo را در بخش تنظیمات روی Everybody تنظیم کنید",
                'show_alert' =>true
            ]);  
            exit;       
        }    		
        $patch = factwebir('getfile',['file_id'=>$getuserphoto])->result->file_path;
        creatbanner3("$patch");  
        factwebir('sendphoto', [
            'chat_id' => $chat_id,
            'photo'=>new CURLFile("$from_id.png"),
            'caption'=>"
            
            <b>
👤 لینک اختصاصی:

https://t.me/$bottag?start=pm_$encoded</b>

",
            'parse_mode' => 'HTML',
            'disable_web_page_preview'=>true,
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [
                        [
                            'text' => '♻️ ربات پیام ناشناس', // Button text
                            'url' => "https://t.me/$bottag", // This will share the message in the same chat
                        ],
                    ],
                ],
            ])
        ]); 
        unlink("$from_id.png");    
        factwebir('deletemessage',[
            'chat_id'=>$chat_id,
            'message_id'=>$msg_iddd,
        ]);    
    }
}
elseif ($data == "bannercustom") {
    // [بررسی عضویت کانال]
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = [];
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }
    
    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        // منطق عدم عضویت در کانال‌ها
        for ($i=0; $i <= $fil; $i++){
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null ){
                if(is_join($from_id,$okk) == false ){
                    $d4[] = [['text'=>"$namechannel",'url'=>$link]];
                }
            }  
        } 
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 
            ▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    }else{  
        // ساخت بنر با نام دلخواه (VIP حذف شد - اکنون کاملا رایگان است)
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"✔️ نام مورد نظر خود را وارد کنید",
            'reply_markup' => $backmenu
        ]);
        $connect->query("UPDATE user SET step = 'setnamebbaner' WHERE id = '$from_id' LIMIT 1");	        		 
    }
}
elseif ($user['step'] == "setnamebbaner" && $text !="🔙 برگشت") {
    // بررسی طول متن
    if (strlen($text) > 50) {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "طول متن وارد شده نباید بیشتر از 50 کاراکتر باشد.",
            'reply_markup' => $usermenu
        ]);
    }
    else{
        // بررسی محتوای متن (فقط متن)
        if (!preg_match('/^[\pL\s]+$/u', $text)) {
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "❌ فقط متن مجاز است",
                'reply_markup' => $usermenu
            ]);
        }
        else{
            
            $encoded = base64_encode($from_id);
            
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "سلام $text هستم 🤚
                
                لینک زیر رو لمس کن و هر حرفی که تو دلت هست یا هر انتقادی که نسبت به من داری رو با خیال راحت بنویس و بفرست. بدون اینکه از اسمت باخبر بشم پیامت به من می‌رسه. خودتم می‌تونی امتحان کنی و از بقیه بخوای راحت و ناشناس بهت پیام بفرستن، حرفای خیلی جالبی می‌شنوی! 😉
                
                👇👇👇👇👇
                
                https://t.me/$bottag?start=pm_$encoded
                
                ",
                'disable_web_page_preview'=>true,
                'reply_markup' => $usermenu
            ]);
            
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "☝️ پیام بالا رو به دوستات و گروه‌هایی که می‌شناسی فـوروارد کن یا لـینک داخلش رو تو شبکه‌های اجتماعی بذار و توئیت کن، تا بقیه بتونن بهت پیام ناشناس بفرستن. پیام‌ها از طریق همین برنامه بهت می‌رسه.
                
                🔻 اگه میخوای پیامت متفاوت باشه میتونی از دکمه های زیر استفاده کنی👇🏻👇🏻👇🏻",
                'reply_markup' => $bannershop
            ]);
            
            $connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");
        }
    }
}
#=============================

//=================دریافت پیام‌های جدید (/newmsg) - کاملاً رایگان شد=================
elseif ($text == "/newmsg") {
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = []; // مقداردهی اولیه آرایه
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }

    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        // اگر عضو کانال‌ها نیست، پیام عضویت ارسال می‌شود.
        $d4 = [];
        for ($i=0; $i < $fil; $i++){ // اصلاح حلقه: $i < $fil
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null && is_join($from_id,$okk) == false ){
                $d4[] = [['text'=>"$namechannel",'url'=>$link]];
            }
        } 
        
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

            ▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    }else{  
        // --- نمایش پیام‌های جدید ---
        $query = "SELECT * FROM msgpm WHERE idkarbar = $from_id AND readpm = 'no'";
        $result = mysqli_query($connect, $query);

        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $message = $row['matn'];
                $ferestande = $row['ferestande'];
                $msg = $row['codemsg'];
                $type = $row['type'];
                $fileid = $row['fileid'];
                
                // *** منطق VIP حذف شده، مشخصات فرستنده برای همه نمایش داده می‌شود ***
                $user_info = $connect->query("SELECT username, name,old,sex FROM user WHERE id = $ferestande")->fetch_assoc();
                $user_name = $user_info['username'];
                $name = $user_info['name'];    
                $old = $user_info['old']; 
                $sex = $user_info['sex']; 
                
                // ساخت دکمه‌های سن و جنسیت
                // اصلاح نمایش جنسیت: بررسی مقادیر ذخیره شده 'پسر'/'دختر' در دیتابیس
                $sex_text = ($sex == 'پسر') ? '👨🏻 پسر' : (($sex == 'دختر') ? '👱🏻‍♀️ دختر' : '❓ نامشخص');
                $old_text = !empty($old) ? "🎂 $old ساله" : "❓ سن نامشخص";

                // دکمه‌های پاسخ، بلاک و ری‌اکشن (جایگزین علاقه‌مندی)
                $inline_keyboard_buttons = [
                    'inline_keyboard' => [
                        [
                            ['text' => $old_text, 'callback_data' => "none_old"], // دکمه نمایشی سن
                            ['text' => $sex_text, 'callback_data' => "none_sex"]  // دکمه نمایشی جنسیت
                        ],
                        [
                            ['text' => "⛔️ بلاک", 'callback_data' => "blockuserw_$ferestande"],
                            ['text' => "✍🏻 پاسخ", 'callback_data' => "replymsg_$ferestande|$msg"]
                        ],
                        // دکمه‌های ری‌اکشن جدید
                        [
                            ['text' => "❤️", 'callback_data' => "reaction_❤️_$ferestande|$msg"],
                            ['text' => "👍", 'callback_data' => "reaction_👍_$ferestande|$msg"],
                            ['text' => "😂", 'callback_data' => "reaction_😂_$ferestande|$msg"],
                            ['text' => "🔥", 'callback_data' => "reaction_🔥_$ferestande|$msg"]
                        ]
                    ]
                ];
                


                // ارسال مدیا یا متن
                if ($type == 'text') {
                    factwebir('sendmessage', [
                        'chat_id' => $chat_id,
                        'text' => "$message",
                        'parse_mode' => 'Markdown',
                        'reply_markup' => json_encode($inline_keyboard_buttons)
                    ]);
                } else {
                    $media_params = [
                        'chat_id' => $chat_id,
                        $type => $fileid,
                        'reply_markup' => json_encode($inline_keyboard_buttons)
                    ];
                    
                    if($message != "none"){
                        $media_params['caption'] = $message;
                    }
                    
                    factwebir('send' . $type, $media_params);
                }
                
                // پیام خوانده شد به فرستنده
                factwebir('sendmessage', [
                    'chat_id' => $ferestande,
                    'text' => "👆🏻 این پیام شما خوانده شد",
                    'reply_to_message_id' => $msg,
                    'parse_mode' => 'Markdown',
                ]);

                // فقط پیام خوانده شده را آپدیت کند
                $connect->query("UPDATE msgpm SET readpm = 'yes' WHERE idkarbar = '$from_id' AND codemsg = '$msg'"); 
            }
        } else {
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "❌ پیام خوانده نشده ای ندارید",
                'parse_mode' => 'Markdown',
            ]);
        }
    }
}
//=================شروع ری‌اکشن (Reaction) - جایگزین علاقه‌مندی و با کنترل یک بار کلیک=================
elseif(strpos($data,"reaction_") !== false) {
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = [];
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }

    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        // اگر عضو کانال‌ها نیست، پیام عضویت ارسال می‌شود.
        $d4 = [];
        for ($i=0; $i < $fil; $i++){ 
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null && is_join($from_id,$okk) == false ){
                $d4[] = [['text'=>"$namechannel",'url'=>$link]];
            }
        } 
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

            ▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    }else{
        $ex = str_replace("reaction_", "", $data); 
        
        $first_underscore_pos = strpos($ex, '_');
        $reaction_emoji = substr($ex, 0, $first_underscore_pos); 
        $rest_of_data = substr($ex, $first_underscore_pos + 1); 

        $parts = explode("|", $rest_of_data);
        $ferestande = $parts[0]; // فرستنده اصلی پیام
        $msg = $parts[1]; // آیدی پیام اصلی که به آن ری‌اکشن داده شده
        
        // 1. بررسی اینکه آیا قبلاً این کاربر به این پیام ری‌اکشن داده است یا خیر
        // *** توجه: این خطوط فرض می‌کنند جدول 'reactions' با فیلدهای 'user_id' و 'message_id' (که همان $msg است) وجود دارد. ***
        $check_query = "SELECT id FROM reactions WHERE user_id = '$from_id' AND message_id = '$msg' LIMIT 1";
        $check_result = mysqli_query($connect, $check_query);

        if (mysqli_num_rows($check_result) > 0) {
            // اگر قبلاً ری‌اکشن داده شده، فقط پیام هشدار نمایش داده می‌شود
            $ack_text = "❌ شما قبلاً به این پیام ری‌اکشن داده‌اید.";
            factwebir('answercallbackquery', [
                'callback_query_id' => $membercall,
                'text' => $ack_text, 
                'show_alert' => true // نمایش به صورت Alert
            ]);
            
        } else {
            // اگر قبلاً ری‌اکشن داده نشده، آن را ثبت می‌کنیم
            // *** ثبت ری‌اکشن جدید در دیتابیس (نیاز به تعریف جدول reactions) ***
            // $insert_query = "INSERT INTO reactions (user_id, message_id, original_sender_id, reaction_emoji) VALUES ('$from_id', '$msg', '$ferestande', '$reaction_emoji')";
            // mysqli_query($connect, $insert_query);

            // 1. ارسال پیام ری‌اکشن به فرستنده اصلی
            $reaction_message_to_sender = "👆🏻 پیامی که فرستاده بودید، از طرف گیرنده $reaction_emoji ری‌اکشن گرفت.";
            
            factwebir('sendmessage', [
                'chat_id' => $ferestande,
                'text' => $reaction_message_to_sender,
                'reply_to_message_id' => $msg, // پاسخ به پیام اصلی فرستنده
                'parse_mode' => 'Markdown',
            ]);
            
            // 2. حذف دکمه‌های ری‌اکشن از پیامی که کاربر روی آن کلیک کرده است
            factwebir('editMessageReplyMarkup', [
                'chat_id' => $chat_id,
                'message_id' => $message_id, // آیدی پیام اصلی ربات در چت گیرنده
                'reply_markup' => json_encode([
                    'inline_keyboard' => [] // حذف دکمه‌ها
                ])
            ]);
            
            // 3. پاسخ به کال‌بک کوئری (Acknowledgment)
            $ack_text = "✅ ری‌اکشن $reaction_emoji ارسال شد.";
            factwebir('answercallbackquery', [
                'callback_query_id' => $membercall,
                'text' => $ack_text, 
                'show_alert' => false
            ]);
        }
    }
}
//=================پایان ری‌اکشن=================


//=================شروع پاسخ‌دهی (Reply 1) - کاملاً رایگان شد=================
 elseif(strpos($data,"replymsg_") !== false) {
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = [];
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }

    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        $d4 = [];
        for ($i=0; $i < $fil; $i++){ // اصلاح حلقه: $i < $fil
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null && is_join($from_id,$okk) == false ){
                $d4[] = [['text'=>"$namechannel",'url'=>$link]];
            }
        } 
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

            ▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    }else{  
        $ex = str_replace("replymsg_", "", $data);
        $parts = explode("|", $ex);
        $key = $parts[0]; // فرستنده اصلی
        $msg = $parts[1]; // آیدی پیام اصلی
        $result = $connect->query("SELECT blocklist FROM user WHERE id = '$key' LIMIT 1");
        $row = $result->fetch_assoc();
        $blocklist = $row['blocklist'];

       if (strpos($blocklist, "$from_id") !== false) {
            // ACKNOWLEDGMENT (Alert)
            factwebir('answercallbackquery', [
                'callback_query_id' => $membercall,
                'text' => "❌ این کاربر شما را بلاک کرده است",
                'show_alert' => true 
            ]);
        } else {
            // *** چک VIP حذف شد - همه می‌توانند پاسخ دهند ***
            // ACKNOWLEDGMENT (Quiet)
            factwebir('answercallbackquery', [
                'callback_query_id' => $membercall,
                'text' => "✍🏻 آماده دریافت پاسخ", 
                'show_alert' => false
            ]);
            
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "✍🏻 پاسخ خود را ارسال کنید",
                'reply_to_message_id' => $message_id, 
                'reply_markup' => $laghv
            ]);

            $connect->query("UPDATE user SET step = 'sendcode89' WHERE id = '$from_id' LIMIT 1");
            $connect->query("UPDATE user SET step2 = '$key|$msg' WHERE id = '$from_id' LIMIT 1");
        }
    }
}

//=================ارسال پاسخ‌دهی (Step: sendcode89)=================
elseif($user["step"] == "sendcode89"){
    $kist2=$user["step2"];
    $parts = explode("|", $kist2);
    $kist = $parts[0]; // گیرنده (کسی که پیام ناشناس را فرستاده بود)
    $msg = $parts[1]; // آیدی پیام اصلی که به آن پاسخ داده می‌شود
    
    // متن لاگ ثابت برای تمامی محتواها
    $log_text = "
🆔 **پاسخ به پیام ناشناس** (Reply)

👤 **پاسخ‌دهنده (Sender):** `$from_id` | [$first_name](tg://user?id=$from_id)

👥 **گیرنده (Receiver):**
`$kist` | [کاربر مقابل](tg://user?id=$kist)
    ";
    
    $reply_markup_buttons = json_encode([
          'inline_keyboard' => [
            [
                ['text' => "⛔️ بلاک", 'callback_data' => "blockuserw_$from_id"],
                ['text' => "✍🏻 پاسخ", 'callback_data' => "reply2msg_$from_id|$msg"]
            ]
        ]
    ]);
    
    $message_sent = false;

    if(isset($message->video)) {
        $file_id = $message->video->file_id;
        $caption = $message->caption;
        factwebir('sendvideo', [
            'chat_id' => $kist,
            'video'=>$file_id,
            'reply_to_message_id'=>$msg,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]);  
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => (isset($caption) ? $caption . "\n" : "") . $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    }
    elseif(isset($message->document)) {
        $file_id = $message->document->file_id;
        $caption = $message->caption;
        factwebir('senddocument', [
            'chat_id' => $kist,
            'document'=>$file_id,
            'reply_to_message_id'=>$msg,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => (isset($caption) ? $caption . "\n" : "") . $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    }
    elseif(isset($message->photo)) {
        $photo = $message->photo;
        $file_id = $photo[count($photo)-1]->file_id;
        $caption = $message->caption;
        factwebir('sendphoto', [
            'chat_id' => $kist,
            'photo'=>$file_id,
            'reply_to_message_id'=>$msg,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => (isset($caption) ? $caption . "\n" : "") . $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    } 
    elseif(isset($message->voice)) {
        $file_id = $message->voice->file_id;
        $caption = $message->caption;
        factwebir('sendvoice', [
            'chat_id' => $kist,
            'voice'=>$file_id,
            'reply_to_message_id'=>$msg,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => (isset($caption) ? $caption . "\n" : "") . $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    }
    elseif(isset($message->audio)) {
        $file_id = $message->audio->file_id;
        $caption = $message->caption;
        factwebir('sendaudio', [
            'chat_id' => $kist,
            'audio'=>$file_id,
            'reply_to_message_id'=>$msg,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => (isset($caption) ? $caption . "\n" : "") . $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    }
    elseif(isset($message->sticker)) {
        $file_id = $message->sticker->file_id;
        $caption = $message->caption;
        factwebir('sendsticker', [
            'chat_id' => $kist,
            'sticker'=>$file_id,
            'reply_to_message_id'=>$msg,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    }
    elseif(isset($message->text)) {
        factwebir('sendmessage', [
            'chat_id' => $kist,
            'reply_to_message_id'=>$msg,
            'text' => $text,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('sendMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'text' => $log_text . "\n\n**متن پیام:**\n" . $text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    } 
    
    if ($message_sent) {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "پیام شما با موفقیت ارسال شد",
            'reply_markup'=>$usermenu 
        ]); 
        $connect->query("UPDATE user SET step = 'none',step2 = 'none' WHERE id = '$from_id' LIMIT 1");
    } else {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ فرمت پیام ارسالی پشتیبانی نمی‌شود. لطفا پیام متنی یا مدیا بفرستید.",
            'reply_markup'=>$laghv
        ]); 
    }
}

//=================شروع پاسخ‌دهی (Reply 2) - کاملاً رایگان شد=================
 elseif(strpos($data,"reply2msg_" ) !== false ) {
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = [];
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }

    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        $d4 = [];
        for ($i=0; $i < $fil; $i++){ // اصلاح حلقه: $i < $fil
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null && is_join($from_id,$okk) == false ){
                $d4[] = [['text'=>"$namechannel",'url'=>$link]];
            }
        } 
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

            ▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    }else{  
        $ex = str_replace("reply2msg_", "", $data);
        $parts = explode("|", $ex);
        $key = $parts[0]; // فرستنده اصلی
        $msg = $parts[1]; // آیدی پیام اصلی
        $result = $connect->query("SELECT blocklist FROM user WHERE id = '$key' LIMIT 1");
        $row = $result->fetch_assoc();
        $blocklist = $row['blocklist'];

       if (strpos($blocklist, "$from_id") !== false) {
            // ACKNOWLEDGMENT (Alert)
            factwebir('answercallbackquery', [
                'callback_query_id' => $membercall,
                'text' => "❌ این کاربر شما را بلاک کرده است",
                'show_alert' => true
            ]);
        } else {
            // *** چک VIP حذف شد - همه می‌توانند پاسخ دهند ***
            // ACKNOWLEDGMENT (Quiet)
            factwebir('answercallbackquery', [
                'callback_query_id' => $membercall,
                'text' => "✍🏻 آماده دریافت پاسخ",
                'show_alert' => false
            ]);
           
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "✍🏻 پاسخ خود را ارسال کنید",
                'reply_to_message_id'=>$message_id,
                'reply_markup' => $laghv
            ]);

            $connect->query("UPDATE user SET step = 'sendcode889' WHERE id = '$from_id' LIMIT 1");	 
            $connect->query("UPDATE user SET step2 = '$key|$msg' WHERE id = '$from_id' LIMIT 1");	 
        }
    }
}

//=================ارسال پاسخ‌دهی (Step: sendcode889)=================
elseif($user["step"] == "sendcode889"){
    $kist2=$user["step2"];
    $parts = explode("|", $kist2);
    $kist = $parts[0];
    $msg = $parts[1];
    
    // متن لاگ ثابت برای تمامی محتواها
    $log_text = "
🆔 **پاسخ دوم به پیام ناشناس** (Reply 2)

👤 **پاسخ‌دهنده (Sender):** `$from_id` | [$first_name](tg://user?id=$from_id)

👥 **گیرنده (Receiver):**
`$kist` | [کاربر مقابل](tg://user?id=$kist)
    ";
    
    $reply_markup_buttons = json_encode([
          'inline_keyboard' => [
            [
                ['text' => "⛔️ بلاک", 'callback_data' => "blockuserw_$from_id"],
                ['text' => "✍🏻 پاسخ", 'callback_data' => "reply2msg_$from_id|$msg"]
            ]
        ]
    ]);
    
    $message_sent = false;

    if(isset($message->video)) {
        $file_id = $message->video->file_id;
        $caption = $message->caption;
        factwebir('sendvideo', [
            'chat_id' => $kist,
            'video'=>$file_id,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]);  
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => (isset($caption) ? $caption . "\n" : "") . $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    }
    elseif(isset($message->document)) {
        $file_id = $message->document->file_id;
        $caption = $message->caption;
        factwebir('senddocument', [
            'chat_id' => $kist,
            'document'=>$file_id,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => (isset($caption) ? $caption . "\n" : "") . $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    }
    elseif(isset($message->photo)) {
        $photo = $message->photo;
        $file_id = $photo[count($photo)-1]->file_id;
        $caption = $message->caption;
        factwebir('sendphoto', [
            'chat_id' => $kist,
            'photo'=>$file_id,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => (isset($caption) ? $caption . "\n" : "") . $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    } 
    elseif(isset($message->voice)) {
        $file_id = $message->voice->file_id;
        $caption = $message->caption;
        factwebir('sendvoice', [
            'chat_id' => $kist,
            'voice'=>$file_id,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => (isset($caption) ? $caption . "\n" : "") . $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    }
    elseif(isset($message->audio)) {
        $file_id = $message->audio->file_id;
        $caption = $message->caption;
        factwebir('sendaudio', [
            'chat_id' => $kist,
            'audio'=>$file_id,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => (isset($caption) ? $caption . "\n" : "") . $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    }
    elseif(isset($message->sticker)) {
        $file_id = $message->sticker->file_id;
        $caption = $message->caption;
        factwebir('sendsticker', [
            'chat_id' => $kist,
            'sticker'=>$file_id,
            'caption' => $caption,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('copyMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message_id,
            'caption' => $log_text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    }
    elseif(isset($message->text)) {
        factwebir('sendmessage', [
            'chat_id' => $kist,
            'text' => $text,
            'reply_markup' => $reply_markup_buttons
        ]); 
        factwebir('sendMessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'text' => $log_text . "\n\n**متن پیام:**\n" . $text,
            'parse_mode' => 'Markdown',
        ]);
        $message_sent = true;
    } 
    
    if ($message_sent) {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "پیام شما با موفقیت ارسال شد",
            'reply_markup'=>$usermenu
        ]); 
        $connect->query("UPDATE user SET step = 'none',step2 = 'none' WHERE id = '$from_id' LIMIT 1");	 
    } else {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ فرمت پیام ارسالی پشتیبانی نمی‌شود. لطفا پیام متنی یا مدیا بفرستید.",
            'reply_markup'=>$laghv
        ]); 
    }
}
#=========================================
 elseif(strpos($data,"blockuserw_" ) !== false ) {
     $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
$ar = []; 
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i < $fil; $i++){ 

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null && is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
$ex = explode("_",$data);
$key = $ex[1]; 
$userside = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$from_id' LIMIT 1"));
$all = explode("^",$userside["blocklist"]);
if(!in_array($key, $all)){
        factwebir('sendmessage',[
                'chat_id'=>$chat_id,
	'text'=>"`✅ کاربر با موفقیت به لیست بلاک شما اضافه شد .`
❗️ کاربر دیگر امکان ارتباط یا ارسال پیام به شما را ندارد
	",
	'parse_mode'=>'Markdown',
    		]);
$connect->query("UPDATE user SET blocklist = IFNULL(CONCAT(blocklist, '{$key}^'), '{$key}^') WHERE id = '$from_id' LIMIT 1");
}
else
{
        factwebir('sendmessage',[
                'chat_id'=>$chat_id,
	'text'=>"`❗️ کاربر قبلا در بلاک لیست شما بوده است`",
	'parse_mode'=>'Markdown',
    'reply_to_message_id'=>$message_id,
    		]);
}
}}
#=================صندوق پیام ها=================
elseif(($text == "📭 صندوق پیام ها" || $text == "/pmbox") && $tc=="private"){
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
        $resultfill = mysqli_query($connect, "SELECT idkarbar, matn, fileid, type, codemsg, datesend, readpm FROM msgpm WHERE idkarbar = '$from_id'");
    $filallset = mysqli_num_rows($resultfill);		    
       $page = 1; // شماره صفحه فعلی
        $page_size = 10; // تعداد نتایج در هر صفحه

        $result = mysqli_query($connect, "SELECT COUNT(*) as total FROM msgpm WHERE idkarbar = '$from_id'");
        $row = mysqli_fetch_assoc($result);
        $total_results = $row['total'];
        $total_pages = ceil($total_results / $page_size); // تعداد کل صفحات

        $offset = ($page - 1) * $page_size; // شروع از نتیجه شماره

        $result = mysqli_query($connect, "SELECT idkarbar, matn, fileid, type, codemsg, datesend, readpm FROM msgpm WHERE idkarbar = '$from_id' ORDER BY datesend DESC LIMIT $offset, $page_size");
        $current_results = mysqli_num_rows($result);

        if($current_results != 0) {
            $d4 = [];
            $d4[] = [['text'=>"📝 پیام",'callback_data'=>"none"],['text'=>"👁 وضعیت پیام",'callback_data'=>"none"],['text'=>"📆 تاریخ ارسال",'callback_data'=>"none"]];

            while($treta = mysqli_fetch_assoc($result)) {
        $matn = $treta['matn'];
        $codemsg = $treta['codemsg'];
        $read2 = $treta['readpm'];
        $tarikh = $treta['datesend'];
        $type = $treta['type'];

        if($read2=="yes"){
            $read="✔️✔️";
        } else {
            $read="✔️";
        }

        switch ($type) {
            case "text":
                $matn_display = "پیام متنی";
                break;
            case "photo":
                $matn_display = "پیام عکس";
                break;
            case "video":
                $matn_display = "پیام ویدیویی";
                break;
            case "sticker":
                $matn_display = "پیام استیکر";
                break;
            case "document":
                $matn_display = "پیام فایل";
                break;
            case "voice":
                $matn_display = "پیام صوتی";
                break;
            case "audio":
                $matn_display = "پیام آهنگ";
                break;
            default:
                $matn_display = "پیام نامشخص";
        }

        $d4[] = [['text'=>"$matn_display",'callback_data'=>"showpm_$codemsg"],['text'=>"$read",'callback_data'=>"none"],['text'=>"$tarikh",'callback_data'=>"none"]];
            }

           

            if ($page < $total_pages) {
                $d4[] = [['text'=>"➡️ صفحه بعدی",'callback_data'=>'saf_'.($page+1)]];
            }

 $d4[] = [['text'=>"🗑 خالی کردن صندوق پیام ها",'callback_data'=>"delallpm"]];
            factwebir('sendmessage',[
                'chat_id'=>$chat_id,
                'text'=>"🔢 تعداد پیام ها : $filallset\n📋 صفحه : $page از $total_pages\n✅ برای مشاهده کامل پیام ، پیام مورد نظر را انتخاب کنید :\n\n⚠️ در صورتی که مقابل پیام ✔️✔️ باشد یعنی پیام دریافت و خوانده شده و اگر در مقابل پیام ✔️ باشد یعنی پیام دریافت ولی خوانده نشده است",
                'parse_mode'=>"HTML",
                'reply_markup'=>json_encode([
                    'inline_keyboard'=>$d4
                ])
            ]);

            $connect->query("UPDATE user SET step = 'saf_$page' WHERE id = '$from_id' LIMIT 1");
        } else {
            factwebir('sendmessage',[
                'chat_id'=>$chat_id,
                'text'=>"❌ هیچ پیامی در صندوق پیام ها وجود ندارد .",
                'parse_mode'=>"HTML",
            ]);
        }
}}
elseif(strpos($data,"saf_") !== false) {
    $ok = str_replace("saf_", null, $data);
    $a = $ok + 1;
    $b = $ok - 1;
    $start = ($ok - 1) * 10;
    $end = $start + 9;
$resultfill = mysqli_query($connect, "SELECT idkarbar, matn, fileid, type, codemsg, datesend, readpm FROM msgpm WHERE idkarbar = '$from_id'");
    $filallset = mysqli_num_rows($resultfill);		   
    $result = mysqli_query($connect, "SELECT idkarbar, matn, fileid, type, codemsg, datesend, readpm FROM msgpm WHERE idkarbar = '$from_id' LIMIT $start, 10");
    $fil2 = mysqli_num_rows($result);

    $d4 = [];
    $d4[] = [['text'=>"📝 پیام",'callback_data'=>"none"],['text'=>"👁 وضعیت پیام",'callback_data'=>"none"],['text'=>"📆 تاریخ ارسال",'callback_data'=>"none"]];

    while($treta = mysqli_fetch_assoc($result)) {
        $matn = $treta['matn'];
        $codemsg = $treta['codemsg'];
        $read2 = $treta['readpm'];
        $tarikh = $treta['datesend'];
        $type = $treta['type'];

        if($read2=="yes"){
            $read="✔️✔️";
        } else {
            $read="✔️";
        }

        switch ($type) {
            case "text":
                $matn_display = "پیام متنی";
                break;
            case "photo":
                $matn_display = "پیام عکس";
                break;
            case "video":
                $matn_display = "پیام ویدیویی";
                break;
            case "sticker":
                $matn_display = "پیام استیکر";
                break;
            case "document":
                $matn_display = "پیام فایل";
                break;
            case "voice":
                $matn_display = "پیام صوتی";
                break;
            case "audio":
                $matn_display = "پیام آهنگ";
                break;
            default:
                $matn_display = "پیام نامشخص";
        }

        $d4[] = [['text'=>"$matn_display",'callback_data'=>"showpm_$codemsg"],['text'=>"$read",'callback_data'=>"none"],['text'=>"$tarikh",'callback_data'=>"none"]];
    }

    $bomm = $ok * 10 + 0.1;
    $kobs = ($ok != 1) ? "⬅️ صفحه قبلی" : "";

    if($fil2 >= 10) {
        $d4[] = [['text'=>"$kobs",'callback_data'=>"saf_$b"], ['text'=>"➡️ صفحه بعدی",'callback_data'=>"saf_$a"]];
        $d4[] = [['text'=>"🗑 خالی کردن صندوق پیام ها",'callback_data'=>"delallpm"]];
    } else {
        $d4[] = [['text'=>"$kobs",'callback_data'=>"saf_$b"]];
        $d4[] = [['text'=>"🗑 خالی کردن صندوق پیام ها",'callback_data'=>"delallpm"]];
    }

    if($fil2 > 10.1) {
        $cp = ceil($fil2 / 10);
    } else {
        $cp = 1;
    }

    factwebir('editmessagetext', [
        'chat_id'=>$chat_id,
        'message_id'=>$messageid,
        'text'=>"🔢 تعداد پیام ها : $filallset\n📋 صفحه : $ok از $cp\n✅ برای مشاهده کامل پیام ، پیام مورد نظر را انتخاب کنید :\n\n⚠️ در صورتی که مقابل پیام ✔️✔️ باشد یعنی پیام دریافت و خوانده شده و اگر در مقابل پیام ✔️ باشد یعنی پیام دریافت ولی خوانده نشده است.",
        'parse_mode'=>"HTML",
        'reply_markup'=>json_encode([
            'inline_keyboard'=>$d4
        ])
    ]);

    $connect->query("UPDATE user SET step = 'saf_$a' WHERE id = '$from_id' LIMIT 1");
}
elseif(strpos($data, "showpm_") !== false) {
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
    $ex = str_replace("showpm_", "", $data);
    $result = mysqli_query($connect, "SELECT matn, fileid, type, readpm, ferestande, codemsg FROM msgpm WHERE codemsg = '$ex' AND idkarbar = '$from_id'");

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $matn = $row['matn'];
        $fileid = $row['fileid'];
        $type = $row['type'];
        $readpm = $row['readpm'];
        $ferestande = $row['ferestande'];
        $msg = $row['codemsg'];

        // Update readpm to 'yes' if it's currently 'no'
        if ($readpm == 'no') {
            $update_query = "UPDATE msgpm SET readpm = 'yes' WHERE codemsg = '$ex' AND idkarbar = '$from_id'";
            $connect->query($update_query);

            factwebir('sendmessage', [
                'chat_id' => $ferestande,
                'text' => "👆🏻 این پیام شما خوانده شد",
                'reply_to_message_id' => $msg,
                'parse_mode' => 'Markdown',
            ]);
        }
if($user['vip']=="yes"){
$user_info = $connect->query("SELECT username, name,old,sex FROM user WHERE id = $ferestande")->fetch_assoc();
$user_name = $user_info['username'];
$name = $user_info['name'];    
$old = $user_info['old']; 
$sex = $user_info['sex']; 
        if ($type == 'text') {
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => $matn,
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [
                            ['text' => "⛔️ بلاک", 'callback_data' => "blockuserw_$ferestande"],
                            ['text' => "✍🏻 پاسخ", 'callback_data' => "replymsg_$ferestande|$msg"]
                        ],
                         [['text' => "➖➖➖مشخصات فرستنده➖➖➖", 'callback_data' => "none"]],
                            [['text' => "$name", 'callback_data' => "none"],['text' => "👤 نام :", 'callback_data' => "none"]],
                            [['text' => "@$user_name", 'callback_data' => "none"],['text' => "🆔 یوزرنیم :", 'callback_data' => "none"]],
                            [['text' => "$old", 'callback_data' => "none"],['text' => "🎊 سن :", 'callback_data' => "none"]],
                            [['text' => "$sex", 'callback_data' => "none"],['text' => "👥 جنسیت :", 'callback_data' => "none"]],
                            [['text' => "☑️ ورود به پیوی کاربر ☑️", 'url' => "tg://openmessage?user_id=$ferestande"]],
                    ]
                ])
            ]);
        } else {
                            if($matn=="none"){
                factwebir('send' . $type, [
                    'chat_id' => $chat_id,
                    $type => $fileid,
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [
                            [
                                ['text' => "⛔️ بلاک", 'callback_data' => "blockuserw_$ferestande"],
                                ['text' => "✍🏻 پاسخ", 'callback_data' => "replymsg_$ferestande|$msg"]
                            ],
                             [['text' => "➖➖➖مشخصات فرستنده➖➖➖", 'callback_data' => "none"]],
                            [['text' => "$name", 'callback_data' => "none"],['text' => "👤 نام :", 'callback_data' => "none"]],
                            [['text' => "@$user_name", 'callback_data' => "none"],['text' => "🆔 یوزرنیم :", 'callback_data' => "none"]],
                            [['text' => "$old", 'callback_data' => "none"],['text' => "🎊 سن :", 'callback_data' => "none"]],
                            [['text' => "$sex", 'callback_data' => "none"],['text' => "👥 جنسیت :", 'callback_data' => "none"]],
                            [['text' => "☑️ ورود به پیوی کاربر ☑️", 'url' => "tg://openmessage?user_id=$ferestande"]],
                        ]
                    ])
                ]);
                }
                else{
                     factwebir('send' . $type, [
                    'chat_id' => $chat_id,
                    $type => $fileid,
                    'caption'=>$matn,
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [
                            [
                                ['text' => "⛔️ بلاک", 'callback_data' => "blockuserw_$ferestande"],
                                ['text' => "✍🏻 پاسخ", 'callback_data' => "replymsg_$ferestande|$msg"]
                            ],
                             [['text' => "➖➖➖مشخصات فرستنده➖➖➖", 'callback_data' => "none"]],
                            [['text' => "$name", 'callback_data' => "none"],['text' => "👤 نام :", 'callback_data' => "none"]],
                            [['text' => "@$user_name", 'callback_data' => "none"],['text' => "🆔 یوزرنیم :", 'callback_data' => "none"]],
                            [['text' => "$old", 'callback_data' => "none"],['text' => "🎊 سن :", 'callback_data' => "none"]],
                            [['text' => "$sex", 'callback_data' => "none"],['text' => "👥 جنسیت :", 'callback_data' => "none"]],
                            [['text' => "☑️ ورود به پیوی کاربر ☑️", 'url' => "tg://openmessage?user_id=$ferestande"]],
                        ]
                    ])
                ]);   
                }
        }
}
else{
        if ($type == 'text') {
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => $matn,
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [
                            ['text' => "⛔️ بلاک", 'callback_data' => "blockuserw_$ferestande"],
                            ['text' => "✍🏻 پاسخ", 'callback_data' => "replymsg_$ferestande|$msg"]
                        ]
                    ]
                ])
            ]);
        } else {
                            if($matn=="none"){
                factwebir('send' . $type, [
                    'chat_id' => $chat_id,
                    $type => $fileid,
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [
                            [
                                ['text' => "⛔️ بلاک", 'callback_data' => "blockuserw_$ferestande"],
                                ['text' => "✍🏻 پاسخ", 'callback_data' => "replymsg_$ferestande|$msg"]
                            ]
                        ]
                    ])
                ]);
                }
                else{
                     factwebir('send' . $type, [
                    'chat_id' => $chat_id,
                    $type => $fileid,
                    'caption'=>$matn,
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [
                            [
                                ['text' => "⛔️ بلاک", 'callback_data' => "blockuserw_$ferestande"],
                                ['text' => "✍🏻 پاسخ", 'callback_data' => "replymsg_$ferestande|$msg"]
                            ]
                        ]
                    ])
                ]);   
                }
        }
    }} else {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => '❌ پیامی یافت نشد.',
            'parse_mode' => 'HTML'
        ]);
    }
}}
elseif($data=="delallpm"){
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
 if($user['vip']=="yes"){    
$delete_query = "DELETE FROM msgpm WHERE idkarbar = '$from_id'";     
$connect->query($delete_query);
         factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✅ صندوق دریافت پیام با موفقیت خالی شد",
            'parse_mode' => 'HTML'
        ]);    
 }
 else{
            factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "❌ این قابلیت فقط برای کاربران ویژه امکان پذیر است",
            'show_alert' =>true
        ]);  
 }
}}
#===============حساب کاربری پیشرفته=============
elseif($text == "👤 حساب کاربری" && $tc=="private"){
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
 if ($user["sex"] != true || $user["old"] != true){
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"
🌟 خوب اول باید اطلاعات خود را ثبت کنی ! جنسیت خودت رو انتخاب کن ؟ 👇🏻",
     'reply_markup'=>json_encode([
            	'keyboard'=>[

								[
				['text'=>"👸🏻 دخترم"],['text'=>"🤴🏻 پسرم"]
				],
				
 	],
            	'resize_keyboard'=>true
       		])
    		]);	   
$connect->query("UPDATE user SET step = 'setsex' WHERE id = '$from_id' LIMIT 1");   		
}
else{
$id=$user['id'];
$member=$user['member'];
$name=$user['name'];
$sex=$user['sex'];
$old=$user['old'];
$blocklist=$user['blocklist'];
$vip=$user['vip'];
$user_name=$user['username'];
$joindate=$user['joindate'];
$partsjoin = explode("-", $joindate);
$dayjoin = $partsjoin[2];
$monthjoin = $partsjoin[1];
$yearjoin = $partsjoin[0];
$joinus = gregorian_to_jalali($yearjoin, $monthjoin, $dayjoin,'/');   
if($vip =="no"){   
factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"👤 اطلاعات حساب کاربری شما؛

▪️ ایدی عددی : <code>$id</code>
👤 نام کاربری: <b>$name</b>
🆔 یوزرنیم : @$user_name

👫 جنسیت: <b>$sex</b>
🎊 سن: <b>$old</b>

👥 تعداد زیرمجموعه های شما: <b>$member</b> نفر

",
'parse_mode'=>"HTML",
	    'reply_markup'=>json_encode([
            	'inline_keyboard'=>[
			    [['text'=>"🔆 اکانت شما ویژه نیست 🔆",'callback_data'=>"none"]],
				[['text'=>"💎 تغییر به حساب ویژه",'callback_data'=>"peymentnow"]],
				[['text'=>"$joinus",'callback_data'=>"none"],['text'=>"🎊 تاریخ عضویت:",'callback_data'=>"none"]],
			
				
 	],
            	'resize_keyboard'=>true
       		])
            ]);
}
else{
$expirevip=$user['expirevip'];
  $parts = explode("-", $expirevip);
  $day = $parts[2];
  $month = $parts[1];
  $year = $parts[0];
 $jdatetime = gregorian_to_jalali($year, $month, $day,'/');   
factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"👤 اطلاعات حساب کاربری شما؛

▪️ ایدی عددی : <code>$id</code>
👤 نام کاربری: <b>$name</b>
🆔 یوزرنیم : @$user_name

👫 جنسیت: <b>$sex</b>
🎊 سن: <b>$old</b>

👥 تعداد زیرمجموعه های شما: <b>$member</b> نفر

",
'parse_mode'=>"HTML",
	    'reply_markup'=>json_encode([
            	'inline_keyboard'=>[
			    [['text'=>"⭐️ اکانت شما ویژه است ⭐️",'callback_data'=>"none"]],
			    [['text'=>"📅 اکانت شما تا تاریخ $jdatetime ویژه می باشد",'callback_data'=>"none"]],
		    	[['text'=>"$joinus",'callback_data'=>"none"],['text'=>"🎊 تاریخ عضویت:",'callback_data'=>"none"]],
			
				
 	],
            	'resize_keyboard'=>true
       		])
            ]);    
}
$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	
}
}}
elseif($data == "backtoprofile"){
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
$id=$user['id'];
$member=$user['member'];
$name=$user['name'];
$sex=$user['sex'];
$old=$user['old'];
$blocklist=$user['blocklist'];
$vip=$user['vip'];
$expirevip=$user['expirevip'];
$user_name=$user['username'];
$joindate=$user['joindate'];
$partsjoin = explode("-", $joindate);
$dayjoin = $partsjoin[2];
$monthjoin = $partsjoin[1];
$yearjoin = $partsjoin[0];
$joinus = gregorian_to_jalali($yearjoin, $monthjoin, $dayjoin,'/');   
if($vip =="no"){   
factwebir('editmessagetext',[
	'chat_id'=>$chat_id,
	        'message_id'=>$messageid,
	'text'=>"👤 اطلاعات حساب کاربری شما؛

▪️ ایدی عددی : <code>$id</code>
👤 نام کاربری: <b>$name</b>
🆔 یوزرنیم : @$user_name

👫 جنسیت: <b>$sex</b>
🎊 سن: <b>$old</b>

👥 تعداد زیرمجموعه های شما: <b>$member</b> نفر

",
'parse_mode'=>"HTML",
	    'reply_markup'=>json_encode([
            	'inline_keyboard'=>[
			    [['text'=>"🔆 اکانت شما ویژه نیست 🔆",'callback_data'=>"none"]],
				[['text'=>"💎 تغییر به حساب ویژه",'callback_data'=>"peymentnow"]],
				[['text'=>"$joinus",'callback_data'=>"none"],['text'=>"🎊 تاریخ عضویت:",'callback_data'=>"none"]],
			
				
 	],
       		])
            ]);
}
else{
$expirevip=$user['expirevip'];
  $parts = explode("-", $expirevip);
  $day = $parts[2];
  $month = $parts[1];
  $year = $parts[0];
 $jdatetime = gregorian_to_jalali($year, $month, $day,'/');       
factwebir('editmessagetext',[
	'chat_id'=>$chat_id,
	        'message_id'=>$messageid,
	'text'=>"👤 اطلاعات حساب کاربری شما؛
	
▪️ ایدی عددی : <code>$id</code>
👤 نام کاربری: <b>$name</b>
🆔 یوزرنیم : @$user_name

👫 جنسیت: <b>$sex</b>
🎊 سن: <b>$old</b>

👥 تعداد زیرمجموعه های شما: <b>$member</b> نفر

",
'parse_mode'=>"HTML",
	    'reply_markup'=>json_encode([
            	'inline_keyboard'=>[
			    [['text'=>"⭐️ اکانت شما ویژه است ⭐️",'callback_data'=>"none"]],
			    [['text'=>"📅 اکانت شما تا تاریخ $jdatetime ویژه می باشد",'callback_data'=>"none"]],
		    	[['text'=>"$joinus",'callback_data'=>"none"],['text'=>"🎊 تاریخ عضویت:",'callback_data'=>"none"]],
			
				
 	],
       		])
            ]);    
}
$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	
}}

elseif($text=="⛔️ پاکسازی بلاک لیست"){
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
// قابلیت پاکسازی بلاک لیست برای همه کاربران فعال شد
    $blocklist = rtrim($user['blocklist'], '^');
    $blocked_users_count = ($blocklist) ? count(explode('^', $blocklist)) : 0;

    if($blocked_users_count=="0"){
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"✅ تعداد کاربران بلاک شده: $blocked_users_count",
        ]);
    }
    else{
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"✅ تعداد کاربران بلاک شده: $blocked_users_count",
            'reply_markup'=>json_encode([
                'inline_keyboard'=>[
                    [['text'=>"🗑 پاکسازی بلاک لیست",'callback_data'=>"deleteblocklist"]],
                ]
            ])
        ]);
    }
    		}
} // بسته شدن تمیز بلوک elseif($text=="⛔️ پاکسازی بلاک لیست")
    		
elseif($data=="deleteblocklist"){
   $connect->query("UPDATE user SET blocklist = '' WHERE id = '$from_id'");
   factwebir('editmessagetext',[
       'chat_id'=>$chat_id,
       'message_id'=>$messageid,
       'text'=>"✅ لیست بلاک شما پاکسازی شد",
       'reply_markup'=>json_encode([
           'inline_keyboard'=>[
               [['text'=>"🔙 برگشت",'callback_data'=>"backtoprofile"]]
           ]
       ])
   ]);
}
elseif($text=="🖍 تغییر نام نمایشی"){
// قابلیت تغییر نام برای همه کاربران فعال شد     
   factwebir('sendmessage',[
        'chat_id'=>$chat_id,
        'text'=>"✔️ نام جدید خود را وارد کنید",
         'reply_markup'=>$laghv
			]);  
$connect->query("UPDATE user SET step = 'editnamestep' WHERE id = '$from_id' LIMIT 1");				
}
elseif($user['step']=="editnamestep"&& $text!="❌ انصراف"){
factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"✅ نام جدید با موفقیت جایگزین شد",
'parse_mode'=>'Markdown',
    		]);	  
$connect->query("UPDATE user SET step='none',name = '$text' WHERE id = '$from_id' LIMIT 1");				    		
}
elseif($text=="🖍 ویرایش جنسیت"){
// قابلیت ویرایش جنسیت برای همه کاربران فعال شد    
   factwebir('sendmessage',[
        'chat_id'=>$chat_id,
        'text'=>"✔️ جنسیت مورد نظر خود را از منوی زیر انتخاب کنید",
	    'reply_markup'=>json_encode([
            	'inline_keyboard'=>[
[['text'=>"🧑🏻‍🦱 پسرم",'callback_data'=>"boyset"],['text'=>"👩🏼‍🦱 دخترم",'callback_data'=>"girlset"]],  	    
 	],
       		])
			]);  
}
if($data=="boyset"){
   factwebir('sendmessage',[
        'chat_id'=>$chat_id,
        'text'=>"✅ جنسیت شما با موفقیت تنظیم شد",
			]); 
$connect->query("UPDATE user SET sex = 'پسر' WHERE id = '$from_id' LIMIT 1");					
}
if($data=="girlset"){
   factwebir('sendmessage',[
        'chat_id'=>$chat_id,
        'text'=>"✅ جنسیت شما با موفقیت تنظیم شد",
			]); 
$connect->query("UPDATE user SET sex = 'دختر' WHERE id = '$from_id' LIMIT 1");					
}
elseif($text=="🖍 تغییر سن"){
// قابلیت تغییر سن برای همه کاربران فعال شد        
   factwebir('sendmessage',[
        'chat_id'=>$chat_id,
     'text'=>"✔️ سن خود را از کیبورد زیر انتخاب کنید",
      'reply_markup'=>json_encode([
            	'keyboard'=>[
				[
				['text'=>"10"],['text'=>"11"],['text'=>"12"],['text'=>"13"],['text'=>"14"]
				],
								[
				['text'=>"15"],['text'=>"16"],['text'=>"17"],['text'=>"18"],['text'=>"19"]
				],
								[
				['text'=>"20"],['text'=>"21"],['text'=>"22"],['text'=>"23"],['text'=>"24"]
				],
								[
				['text'=>"25"],['text'=>"26"],['text'=>"27"],['text'=>"28"],['text'=>"29"]
				],
								[
				['text'=>"30"],['text'=>"31"],['text'=>"32"],['text'=>"33"],['text'=>"34"]
				],
												[
				['text'=>"35"],['text'=>"36"],['text'=>"37"],['text'=>"38"],['text'=>"39"]
				],
												[
				['text'=>"40"],['text'=>"41"],['text'=>"42"],['text'=>"43"],['text'=>"44"]
				],
												[
				['text'=>"45"],['text'=>"46"],['text'=>"47"],['text'=>"48"],['text'=>"49"]
				],
								[
				['text'=>"+50"],['text'=>"-9"]
				],
				[['text'=>"❌ انصراف"]]
				
 	],
            	'resize_keyboard'=>true
       		])
			]);  
$connect->query("UPDATE user SET step = 'editoldstep' WHERE id = '$from_id' LIMIT 1");				
}
elseif($user['step']=="editoldstep"&& $text!="❌ انصراف"){
$age = trim($text);
// بررسی اصلاح شده: سن عددی بین 10 تا 49 است یا یکی از رشته های خاص "+50" یا "-9" است
if((is_numeric($age) && $age >= 10 && $age <= 49) || $text == "-9" || $text == "+50"){
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"✅ سن شما با موفقیت به $age تغییر یافت",
'parse_mode'=>'Markdown',
'reply_markup'=>json_encode([
'keyboard'=>[
[['text'=>"🔙 برگشت"]]
],
     	'resize_keyboard'=>true
])
]);
$connect->query("UPDATE user SET old='$age', step='none' WHERE id = '$from_id' LIMIT 1");
} else {
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"✔️ سن خود را از کیبورد زیر انتخاب کنید",
'parse_mode'=>'Markdown',
      'reply_markup'=>json_encode([
            	'keyboard'=>[
				[
				['text'=>"10"],['text'=>"11"],['text'=>"12"],['text'=>"13"],['text'=>"14"]
				],
								[
				['text'=>"15"],['text'=>"16"],['text'=>"17"],['text'=>"18"],['text'=>"19"]
				],
								[
				['text'=>"20"],['text'=>"21"],['text'=>"22"],['text'=>"23"],['text'=>"24"]
				],
								[
				['text'=>"25"],['text'=>"26"],['text'=>"27"],['text'=>"28"],['text'=>"29"]
				],
								[
				['text'=>"30"],['text'=>"31"],['text'=>"32"],['text'=>"33"],['text'=>"34"]
				],
												[
				['text'=>"35"],['text'=>"36"],['text'=>"37"],['text'=>"38"],['text'=>"39"]
				],
												[
				['text'=>"40"],['text'=>"41"],['text'=>"42"],['text'=>"43"],['text'=>"44"]
				],
												[
				['text'=>"45"],['text'=>"46"],['text'=>"47"],['text'=>"48"],['text'=>"49"]
				],
								[
				['text'=>"+50"],['text'=>"-9"]
				],
				[['text'=>"🔙 برگشت"]]
				
 	],
            	'resize_keyboard'=>true
       		])
			]); 
}
}
#===============اشتراک ویژه====================
elseif($text == "💳" && $tc=="private"){
$chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
if($user['vip']=="yes"){
        factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"<b>💎 اکانت شما ویژه است</b>",
'parse_mode'=>'HTML',
    		]);	
}
else{
factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"
👑 اشتراک ویژه - مزایای شگفت‌انگیز!

<b>🔸 صندوق پیام حرفه‌ای:<b>
<b>   - مشاهده اطلاعات کامل کاربر </b> (نام، یوزرنیم، سن، جنسیت و پیوی) پس از پایان <b> ۱ روز </b> استفاده رایگان.

<b>🔸 چت ناشناس نامحدود:</b>
   - چت با دختر و پسر پس از پایان <b>۱۰ روز </b> چت رایگان.
<b>   - ارسال عکس، ویدیو، استیکر، وُیس و...</b> در چت ناشناس.

<b>🔸 امکانات اختصاصی دیگر:</b>

",
'parse_mode'=>'HTML',
    		]);	   
factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"
<b>
👑 اشتراک ویژه - مزایای شگفت‌انگیز!

🔸 صندوق پیام حرفه‌ای:
   - مشاهده اطلاعات کامل کاربر (نام، یوزرنیم، سن، جنسیت و پیوی) پس از پایان ۱ روز استفاده رایگان.
🔸 چت ناشناس نامحدود:
   - چت با دختر و پسر پس از پایان ۱۰ روز چت رایگان.
   - ارسال عکس، ویدیو، استیکر، وُیس و... در چت ناشناس. و...

🔸 جدول تعرفه‌ها:
🔹 ۱ ماهه: ۳۰,۰۰۰ تومان
🔹 ۲ ماهه: ۶۰,۰۰۰ تومان
🔹 ۳ ماهه: ۱۸۰,۰۰۰ تومان
</b>
",
'parse_mode'=>'HTML',
			'reply_markup'=>json_encode([
    'inline_keyboard'=>[
					
						[
	['text'=>"💳 پرداخت کارت به کارت",'callback_data'=>"offlinepay"]
	],
              ]
        ])
    		]);	     		
}}}
elseif($data == "peymentnow"){
$chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{      
if($user['vip']=="yes"){
        factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"<b>💎 اکانت شما ویژه است</b>",
'parse_mode'=>'HTML',
    		]);	
}
else{
factwebir('editmessagetext',[
	'chat_id'=>$chat_id,
		 'message_id' => $messageid,
'text'=>"
<b>
👑 اشتراک ویژه - مزایای شگفت‌انگیز!

🔸 صندوق پیام حرفه‌ای:
   - مشاهده اطلاعات کامل کاربر (نام، یوزرنیم، سن، جنسیت و پیوی) پس از پایان ۱ روز استفاده رایگان.
🔸 چت ناشناس نامحدود:
   - چت با دختر و پسر پس از پایان ۱۰ روز چت رایگان.
   - ارسال عکس، ویدیو، استیکر، وُیس و... در چت ناشناس.و...
   
🔸 جدول تعرفه‌ها:
🔹 ۱ ماهه: ۳۰,۰۰۰ تومان
🔹 ۲ ماهه: ۶۰,۰۰۰ تومان
🔹 ۳ ماهه: ۱۸۰,۰۰۰ تومان
</b>
",
'parse_mode'=>'HTML',
			'reply_markup'=>json_encode([
    'inline_keyboard'=>[
					
						[
	['text'=>"💳 پرداخت کارت به کارت",'callback_data'=>"offlinepay"]
	],
              ]
        ])
    		]);	     		
}}}
elseif($data == "zarinpay"){
$chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{      
    if($zarinpaymode =="off"){
           factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "⚠️ پرداخت آنلاین زرین پال در حال حاضر غیرفعال است",
            'show_alert' =>false
        ]);     
    }else{
     factwebir('editmessagetext',[
	'chat_id'=>$chat_id,
	 'message_id' => $messageid,
'text'=>"
🔻 به بخش پرداخت آنلاین زرین پال خوش آمدید

1️⃣ اشتراک مورد نظر را انتخاب کنید
2️⃣ به بخش پرداخت بروید
3️⃣ بعد از پرداخت ، پیام موفقیت آمیز خرید اشتراک را دریافت می کنید

⚠️ در صورتی که پرداخت را انجام و هزینه از حساب شما  کسر شد ولی پیام موفقیت آمیز خرید اشتراک را دریافت نکردید به پشتیبانی مراجعه کنید
",
'parse_mode'=>"HTML",
    'reply_markup'=>json_encode([
           'inline_keyboard'=>[
	[
	['text'=>"💎 اشتراک یکماهه: 90 تومان",'url'=>$web."/pay/pay.php?callback=".$web."/pay/1.php?id=$from_id&amount=90000"]
	],
	[
	['text'=>"💎 اشتراک سه ماهه: 220 تومان",'url'=>$web."/pay/pay.php?callback=".$web."/pay/2.php?id=$from_id&amount=220000"]
	],
		[
	['text'=>"💎 اشتراک شش ماهه: 390 تومان",'url'=>$web."/pay/pay.php?callback=".$web."/pay/3.php?id=$from_id&amount=390000"]
	],
			[
	['text'=>"💎 اشتراک یکساله: 650 تومان",'url'=>$web."/pay/pay.php?callback=".$web."/pay/4.php?id=$from_id&amount=650000"]
	],
		
			[
	['text'=>"🔙",'callback_data'=>"peymentnow"]
	],

              ]
              ,	'resize_keyboard'=>true
        ])
    		]);   
 }}}
elseif($data == "offlinepay"){
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
        if($cardpaymode =="off"){
           factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "⚠️ پرداخت کارت به کارت در حال حاضر غیرفعال است",
            'show_alert' =>false
        ]);     
    }else{
    factwebir('editmessagetext',[
        'chat_id'=>$chat_id,
        'text'=>"💳 برای اضافه کردن موجودی، مبلغی که میخواهید شارژ کنید را به حساب زیر واریز کرده سپس عکس رسید واریز را بلافاصله از همینجا ارسال کنید.
<b>
💳 :  5859471029301409
بنام : مهران پارسا
</b>
<b>
❌ توجه : به هیچ وجه تا ارسال نکردن عکس رسید واریز از این قسمت خارج نشوید.
 اگه قصد لغو داشتید از دکمه بازگشت استفاده کنید
</b>

📍 تایید تراکنش شما به نوبت در سریع‌ترین زمان ممکن انجام خواهد شد.",
        'parse_mode'=>"HTML",
        'message_id' => $messageid,
        'reply_markup'=>json_encode([
        'inline_keyboard'=>[
        [
            [ 'text' => "بازگشت"   , 'callback_data' => "cartback" ] 
        ],
        ]
        ])
        ]);
       	$connect->query("UPDATE user SET step = 'cart' WHERE id = '$from_id' LIMIT 1");	
}}}
elseif($data == "cartback"){
factwebir('editmessagetext',[
	'chat_id'=>$chat_id,
		 'message_id' => $messageid,
'text'=>"
<b>
👑 اشتراک ویژه - مزایای شگفت‌انگیز!

🔸 صندوق پیام حرفه‌ای:
   - مشاهده اطلاعات کامل کاربر (نام، یوزرنیم، سن، جنسیت و پیوی) پس از پایان ۱ روز استفاده رایگان.
🔸 چت ناشناس نامحدود:
   - چت با دختر و پسر پس از پایان ۱۰ روز چت رایگان.
   - ارسال عکس، ویدیو، استیکر، وُیس و... در چت ناشناس.و...
   
🔸 جدول تعرفه‌ها:
🔹 ۱ ماهه: ۳۰,۰۰۰ تومان
🔹 ۲ ماهه: ۶۰,۰۰۰ تومان
🔹 ۳ ماهه: ۱۸۰,۰۰۰ تومان
</b>
",
'parse_mode'=>'HTML',
			'reply_markup'=>json_encode([
    'inline_keyboard'=>[
					
						[
	['text'=>"💳 پرداخت کارت به کارت",'callback_data'=>"offlinepay"]
	],
              ]
        ])
    		]);	    
       	$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	
}

elseif($user['step'] == "cart"){
    
    factwebir('ForwardMessage',[
'chat_id'=>$admins[0],
'from_chat_id'=>$chat_id,
'message_id'=>$message_id
]);
factwebir('sendMessage',[
        'chat_id'=>$chat_id,
        'text'=>"✅ رسید شما با موفقیت ارسال شد و در صورت پرداخت موفق در سریعترین زمان ممکن اشتراک شما فعال میشود.",
        'parse_mode'=>"MarkDown",
        ]);
factwebir('sendMessage',[
        'chat_id'=>$admins[0],
        'text'=>"🔑 #Pay

واریزی جدید انجام شده عکس ارسالی کاربر پست بالا 👆

👤 : `$chat_id`",
        'parse_mode'=>"MarkDown",
        			'reply_markup'=>json_encode([
    'inline_keyboard'=>[
						[
	['text'=>"💎 تغییر اکانت کاربر",'callback_data'=>"changeuseraccpay"]
	],
              ]
        ])
        ]);
       	$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	
} 

elseif($data == "cryptopay"){
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
        if($cryptopaymode =="off"){
           factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "⚠️ پرداخت با ارز دیجیتال در حال حاضر غیرفعال است",
            'show_alert' =>false
        ]);     
    }else{
    factwebir('editmessagetext',[
        'chat_id'=>$chat_id,
        'text'=>"✅ به بخش پرداخت ارز دیجیتال ( کیف پول) خوش آمدید؛

🔻به مقدار شارژ مورد نیاز خود ، $arzwallet خود را به کیف پول زیر واریز کرده و رسید آن را ارسال کنید:

🪪<b>WALLET ADDRESS :</b> <code>$addresswallet</code>

❌ توجه : به هیچ وجه تا ارسال نکردن عکس رسید واریز از این قسمت خارج نشوید.
 اگه قصد لغو داشتید از دکمه بازگشت استفاده کنید

📍 تایید تراکنش شما به نوبت در سریع‌ترین زمان ممکن انجام خواهد شد.",
        'parse_mode'=>"HTML",
        'message_id' => $messageid,
        'reply_markup'=>json_encode([
        'inline_keyboard'=>[
        [
            [ 'text' => "بازگشت"   , 'callback_data' => "cartback" ] 
        ],
        ]
        ])
        ]);
       	$connect->query("UPDATE user SET step = 'cart' WHERE id = '$from_id' LIMIT 1");	
}}}
#====================تنظیمات====================
  elseif($text == "⚙️"  && $tc=="private"){
      $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
     factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"⚙️ به بخش تنظیمات ربات خوش آمدید؛

🔻 یکی از موارد زیر را انتخاب کنید",
'reply_to_message_id'=>$message_id,
'parse_mode'=>'Markdown',
'reply_markup'=>$settingsmenu
    		]);   
  }}
#===============حذف پیام های ارسالی===============
   elseif($text == "🗑 حذف پیام های ارسالی" ){ 
       $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
// محدودیت کاربران ویژه (VIP) حذف شد - این قابلیت اکنون برای همه رایگان است       		    
     factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"⚠️ با انتخاب این گزینه تمامی پیام های ارسال شده شما به کاربران از صندوق پیام های آن ها حذف میشود!

🔸 همچنین با انتخاب این گزینه، امکان پاسخگویی کاربران به پیام هایی که تا به این لحظه برای آن ها ارسال کرده اید دیگر وجود ندارد.

🔻 برای اینکار مطمئن هستید؟",
'reply_to_message_id'=>$message_id,
'parse_mode'=>'Markdown',
'reply_markup'=> json_encode([
            'inline_keyboard'=>[
                  [['text'=>"✅ بله مطمئن هستم!",'callback_data'=>"deleteallpmsent"]],
              ]
        ])
    		]);   
    		}
}
elseif($data == "deleteallpmsent") {
   // بررسی وجود رکوردهای کاربر در جدول msgpm
   $checkQuery = "SELECT COUNT(*) FROM msgpm WHERE ferestande = '$from_id'";
   $checkResult = $connect->query($checkQuery);
   $count = $checkResult->fetch_row()[0];

   if ($count > 0) {
       // حذف تمام رکوردهای کاربر از جدول msgpm
       $deleteQuery = "DELETE FROM msgpm WHERE ferestande = '$from_id'";
       $connect->query($deleteQuery);

       factwebir('sendmessage', [
           'chat_id' => $chat_id,
           'text' => "✅ تمام پیام های ارسال شده حذف شد",
           'parse_mode' => 'Markdown'
       ]);
   } else {
       factwebir('sendmessage', [
           'chat_id' => $chat_id,
           'text' => "شما هیچ پیامی تا کنون ارسال نکرده اید",
           'parse_mode' => 'Markdown'
       ]);
   }
}

// ==============================================================================
// ==============================================================================
// 🎯 پیاده‌سازی نمایش متن با لینک استارت (نسخه پایدار و بدون ویرایش لحظه‌ای)
// ==============================================================================
if (strpos($text, "/start") === 0) {
    $start_payload = str_replace("/start ", "", $text);
    
    if (strpos($start_payload, "text_") === 0) {
        $code = str_replace("text_", "", $start_payload);
        $code = mysqli_real_escape_string($connect, $code);
        
        $text_data = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM uploaded_texts WHERE code = '$code' LIMIT 1"));
        
        if ($text_data) {
            $show_text = $text_data['text'];
            $current_views = (int)$text_data['views']; 
            
            // ------------------------------------------------------------------
            // --- منطق جوین اجباری ---
            // ------------------------------------------------------------------
            $chs = mysqli_query($connect,"select idoruser from channels");
            $fil = mysqli_num_rows($chs);
            $ar = [];
            while($row = mysqli_fetch_assoc($chs)){ $ar[] = $row["idoruser"]; }

            if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
                $d4 = [];
                for ($i=0; $i <= $fil; $i++){
                    $okk = $ar[$i];
                    $namechannel = getChannelTitle($okk); 
                    $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
                    $link = $ch['link'];
                    if($link != null && is_join($from_id,$okk) == false ){
                        $d4[] = [['text'=>"$namechannel",'url'=>$link]];
                    }
                } 
                
                if (!empty($d4)) { 
                    $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
                    factwebir('sendmessage',[
                        'chat_id'=>$chat_id,
                        'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 
▪️برای مشاهده متن ارسالی، ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
                        'parse_mode'=>"HTML",
                        'reply_markup'=>json_encode(['inline_keyboard'=>$d4])
                    ]); 
                    return;
                }
            }
            // ------------------------------------------------------------------
            // --- پایان منطق جوین اجباری ---
            // ------------------------------------------------------------------
            
            // 1. افزایش شمارنده بازدید در دیتابیس (فقط یک بار)
            $new_views = $current_views + 1;
            mysqli_query($connect, "UPDATE uploaded_texts SET views = views + 1 WHERE code = '$code' LIMIT 1");
            
            // 2. ساخت دکمه شیشه‌ای نهایی (با شمارنده جدید)
            $final_inline_keyboard = json_encode([
                'inline_keyboard' => [
                    [['text'=>"👁 $new_views بازدید",'callback_data'=>"ignore_view"]],
                    [['text' => '✍️  ساخت پرامپت متنی ', 'callback_data' => 'help_q6']]
                ]
            ]);
            
            $message_to_send = "
            ✍️ <b>متن اختصاصی:</b>
            
            <code>$show_text</code>
            
🔸<b> متن بالا به صورت
خودکار قابلیت انتخاب و کپی دارد.</b>
            ";
            
            factwebir('sendmessage',[
                'chat_id'=>$chat_id,
                'text'=>$message_to_send,
                'parse_mode'=>"HTML",
                'reply_markup'=>$final_inline_keyboard // استفاده از دکمه‌های شیشه‌ای
            ]);
            factwebir('sendmessage',[
                'chat_id'=>$chat_id,
                'text'=>"
✨ <b> حله!

چه کاری برات انجام بدم؟ </b> ",
                'parse_mode'=>"HTML",
                'reply_markup'=>$usermenu 
            ]);

        } else {
            // اگر کد متن پیدا نشد، منوی کاربری را ارسال می‌کنیم
            factwebir('sendmessage',[
                'chat_id'=>$chat_id,
                'text'=>"❌ متنی با این کد پیدا نشد.\n\nلطفا از منوی زیر استفاده کنید:",
                'reply_markup'=>$usermenu
            ]);
        }
        return; 
    }
}
// ==============================================================================

#=====================پشتیبانی عمومی========================
  elseif($text == "👨‍💻"  && $tc=="private"){
      $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
  factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"👮🏻 همکاران ما در خدمت شما هستن !
	
🔘 در صورت وجود نظر , ایده , گزارش مشکل , پیشنهاد , ایراد سوال , یا انتقاد میتوانید با ما در ارتباط باشید 
💬 `لطفا پیام خود را در قالب متن ، عکس یا ویدیو ارسال کنید`",
'reply_to_message_id'=>$message_id,
'parse_mode'=>'Markdown',
'reply_markup'=>json_encode([
            	'keyboard'=>[
								    [
                ['text'=>"🔙 برگشت"]
                ]
 	],
            	'resize_keyboard'=>true
       		])
    		]);
$connect->query("UPDATE user SET step = 'support' WHERE id = '$from_id' LIMIT 1");	    		
    }}
   elseif($user['step'] == "support" && $text != '🔙 برگشت' && $text!="/start"){
       			factwebir('sendmessage',[       
			'chat_id'=>$chat_id,
			'text'=>"✅ پیام شما با موفقیت ارسال شد منتظر پاسخ پشتیبانی باشید",
			'reply_markup'=>$usermenu
	]);
$usersup = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$chat_id' LIMIT 1"));	
$name=$usersup['name'];
factwebir('ForwardMessage',[
'chat_id'=>$admins[0],
'from_chat_id'=>$chat_id,
'message_id'=>$message_id
]);	
	factwebir('sendmessage',[    
	    'chat_id'=>$admins[0],
			'text'=>"👆🏻👆🏻👆🏻
#پشتیبانی

🔹 پیام بالا از سمت $name ارسال شده است؛

🔻چه کار کنم؟",
			 'parse_mode'=>"MarkDown",
			                     'reply_markup' => json_encode([
              'inline_keyboard' => [
                [
                    ['text' => "⛔️ بلاک", 'callback_data' => "blockusersender_$chat_id"],
                    ['text' => "✍🏻 پاسخ", 'callback_data' => "repltouser_$chat_id"]
                ]
            ]
        ])
	]);
   $connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	        
   }
elseif(strpos($data,"blockusersender_") !== false) {
    $userId = str_replace("blockusersender_", "", $data);

    // قرار دادن کلمه "block" در ستون "step" برای کاربر جاری
    $sql = "UPDATE user SET step = 'ban' WHERE id = $userId";
    $connect->query($sql);
    factwebir('sendmessage', [
        'chat_id' => $chat_id,
        'text' => "✅ کاربر با موفقیت بلاک شد!",
        'reply_to_message_id' => $message_id,
    ]);
       factwebir('sendmessage', [
        'chat_id' => $userId,
        'text' => "❌ شما به دلیل رعایت نکردن قوانین از ربات بلاک شدید",
    
    ]); 
}  
 elseif(strpos($data,"repltouser_" ) !== false ) {
 $ex = str_replace("repltouser_", "", $data);    
           factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✍🏻 پاسخ خود را ارسال کنید",
            'reply_to_message_id'=>$message_id,
                                'reply_markup' => $laghv
        ]);

$connect->query("UPDATE user SET step = 'sendreplytouser' WHERE id = '$from_id' LIMIT 1");	 
$connect->query("UPDATE user SET step2 = '$ex' WHERE id = '$from_id' LIMIT 1");	 
 } 
elseif($user["step"] == "sendreplytouser"){
 $kist2=$user["step2"];
            factwebir('sendmessage', [
            'chat_id' => $kist2,
            'text' => "👤 پاسخ پشتیبانی :
<b>
$text</b>
",
			 'parse_mode'=>"HTML"
            
        ]);  
                    factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✅ پاسخ شما با موفقیت به کاربر ارسال شد",
            'reply_markup'=>$usermenu
        ]); 
        $connect->query("UPDATE user SET step = 'none',step2 = 'none' WHERE id = '$from_id' LIMIT 1");	 
} 
//-----------------------------------------------------------------------------------------------
// --- [بخش تعریف متغیرها (شروع کد)] ---
$settings = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM settings WHERE botid = '$botid' LIMIT 1"));
// ... [بقیه متغیرهای تنظیمات] ...

$ToDay = jdate('l'); 
$datenow = date('Y-m-d');
$date = gregorian_to_jalali(date('Y'), date('m'), date('d'), '/');

// ==============================================================================
// =============== [منطق پاسخ به دکمه‌های شیشه‌ای راهنما (CALLBACK QUERY)] ===============
// ==============================================================================

// خطایی که رخ داده بود به دلیل شروع با elseif بود. اولین شرط را با IF شروع می‌کنیم.

#============== [II-1] پاسخ به سوال اول: این روبات چیه؟ (شروع با IF) ==============
if (isset($data) && $data === 'help_q1') {
    
    // تعریف دکمه بازگشت به منوی راهنما
    $back_to_help_keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🔙 بازگشت به راهنما', 'callback_data' => 'show_help_menu']] 
        ]
    ]);

    // متن پاسخ به سوال اول
    $answer_text = "<b>این روبات چیه؟ به چه درد میخوره؟</b>\n\n"
        . "👈 « برنامه ناشناس » محبوب‌ترین و کامل‌ترین ربات‌ تلگرام شناخته شده که با استفاده از این برنامه :\n\n"
        . "🔹 هر وقت حوصلت سر میره میتونی تصادفی به یک نفر وصل بشی و به صورت ناشناس باهاش چت کنی! 😀\n\n"
        . "🔹 میتونی به دوستات اجازه بدی هر حرف یا انتقادی که تو دلشون مونده رو بصورت ناشناس بهت بگن!\n\n"
        . "🔹 و جذاب تر از همه میتونی به مخاطب خاصت بصورت ناشناس پیام بفرستی 👌";

    // ویرایش پیام قبلی
    factwebir('editmessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid, 
        'text'=>$answer_text,
        'parse_mode'=>'HTML',
        'reply_markup' => $back_to_help_keyboard
    ]);
    
    // پاسخ به Callback Query برای حذف علامت Loading
    factwebir('answercallbackquery',[
        'callback_query_id' => $membercall,
    ]);
}


#============== [II-2] پاسخ به سوال دوم: چطوری وصل بشم؟ ==============
elseif (isset($data) && $data === 'help_q2') {
    
    // تعریف دکمه بازگشت به منوی راهنما
    $back_to_help_keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🔙 بازگشت به راهنما', 'callback_data' => 'show_help_menu']] 
        ]
    ]);

    // متن پاسخ به سوال دوم
    $answer_text = "<b>چطوری به یه ناشناس تصادفی وصل بشم؟</b>\n\n"
        . "برای اینکار کافیه روی دکمه 《🔗 به یه ناشناس وصلم کن!》کلیک کنی تا بصورت شانسی به یه نفر وصل بشی و باهاش گپ بزنی!";

    // ویرایش پیام قبلی
    factwebir('editmessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid, 
        'text'=>$answer_text,
        'parse_mode'=>'HTML',
        'reply_markup' => $back_to_help_keyboard
    ]);
    
    factwebir('answercallbackquery',[
        'callback_query_id' => $membercall,
    ]);
}

#==============
elseif (isset($data) && $data === 'help_q3') {
    $back_to_help_keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🔙 بازگشت به راهنما', 'callback_data' => 'show_help_menu']] 
        ]
    ]);
    $answer_text = "<b>
💌 چطوری به مخاطب خاصم وصل بشم؟
</b>

1️⃣ اول دکمه 《 به مخاطب خاصم وصلم کن! 》 رو بزن.

2️⃣ یکی از این کارها رو انجام بده:

راه اول: آی‌دی تلگرام (Username@) مخاطب خاصت رو وارد ربات کن.

راه دوم: یه پیام متنی از مخاطب خاصت به ربات فوروارد کن تا بررسی کنیم که آیا عضو برنامه هست یا نه.

3️⃣ وقتی یکی از این کارها رو انجام دادی، ربات بررسی می‌کنه که مخاطب عضو برنامه هست یا نه، و تو می‌تونی بهش پیام ناشناس بفرستی!😎
";
    factwebir('editmessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid, 
        'text'=>$answer_text,
        'parse_mode'=>'HTML',
        'reply_markup' => $back_to_help_keyboard
    ]);
    
    factwebir('answercallbackquery',[
        'callback_query_id' => $membercall,
    ]);
}
#==============
elseif (isset($data) && $data === 'help_q4') {
    $back_to_help_keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🔙 بازگشت به راهنما', 'callback_data' => 'show_help_menu']] 
        ]
    ]);
    $answer_text = "<b>
📬 چطوری پیام ناشناس دریافت کنم؟
</b>

برای دریافت پیام ناشناس، کافیه گزینه 《 لینک ناشناس من 》 و یا دستور 👈 /link 👉 رو لمس کنی تا لینک اختصاصی‌ات برات ارسال بشه.
این لینک رو می‌تونی به دوستات و گروه‌ها بفرستی یا توی شبکه‌های اجتماعی مثل توییتر ، اینستاگرام ، فیس‌بوک ، واتس‌اپ و .... به اشتراک بذاری.
 دوستات از طریق این لینک می‌تونن هر حرف یا نظری که دارن، بدون اینکه تو متوجه بشی کی هستن، برات بفرستن. 
همچنین همراه لینک، یه متن پیش‌فرض هم برات ارسال میشه که اگه بخوای، می‌تونی اونو تغییر بدی.

";
    factwebir('editmessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid, 
        'text'=>$answer_text,
        'parse_mode'=>'HTML',
        'reply_markup' => $back_to_help_keyboard
    ]);
    
    factwebir('answercallbackquery',[
        'callback_query_id' => $membercall,
    ]);
}

#==============
elseif (isset($data) && $data === 'help_q5') {
    $back_to_help_keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🔙 بازگشت به راهنما', 'callback_data' => 'show_help_menu']] 
        ]
    ]);
    $answer_text = "<b>
🖼 راهنمای استفاده از پرامپت AI
</b>
🖼️ نحوه تبدیل متن پرامیت به تصویر (AI) با جِمینای (رایگان):

اگر متنی را از بخش پرامیت‌ها دریافت کرده‌اید یا خودتان متنی توصیفی دارید، می‌توانید آن را در سرویس تولید تصویر هوش مصنوعی جِمینای (Gemini) استفاده کنید. این قابلیت به صورت رایگان از طریق نسخه وب در دسترس است.

### ⚙️ نحوه کار:
1. ورود به جِمینای: در مرورگر خود به آدرس gemini.google.com بروید و با حساب گوگل خود وارد شوید.
2. کپی کردن پرامیت: متن پرامیتی که می‌خواهید تصویرش را بسازید (شامل توصیف سوژه، سبک هنری، نورپردازی و جزئیات دیگر) را کپی کنید.
3. درخواست تولید تصویر: پرامیت کپی شده را در قسمت ورودی جِمینای قرار دهید و یک عبارت دستوری برای شروع به آن اضافه کنید. مثال:

   تصویری از ... ایجاد کن: و سپس پرامیت خود را به انگلیسی یا فارسی قرار دهید

4. تولید تصویر: دکمه 'ارسال' (Submit) را بزنید. جِمینای با استفاده از مدل تصویرساز خود (Nano Banana) تصویر مورد نظر را خلق می‌کند.

💡 نکته: هرچه پرامیت شما جزئی‌تر و توصیفی‌تر باشد (مانند: 'یک نقاشی رنگ روغن از یک ربات قهوه‌ساز، در غروب آفتاب با نور طلایی'), نتیجه نهایی بهتر و دقیق‌تر خواهد بود. جمینای فرمان‌های تولید تصویر فارسی را نیز درک می‌کند.

<b> کانال پرامپت چی ما 👇 </b>
https://t.me/pramptChi
";
    factwebir('editmessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid, 
        'text'=>$answer_text,
        'parse_mode'=>'HTML',
        'reply_markup' => $back_to_help_keyboard
    ]);
    
    factwebir('answercallbackquery',[
        'callback_query_id' => $membercall,
    ]);
}

#==============
elseif (isset($data) && $data === 'help_q6') {
    $back_to_help_keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🔙 بازگشت به راهنما', 'callback_data' => 'show_help_menu']] 
        ]
    ]);
    $answer_text = "<b>
از رویا تا پرامپت حرفه‌ای، در یک لحظه!
</b>

​تصاویر هوش مصنوعی رو به سطح جدیدی ببر! 🤯

​دیگه وقتت رو برای ساخت پرامپت‌های پیچیده تلف نکن. ربات ما مجهز به Gemini AI، بهترین پرامپت‌ها رو فقط با چند کلمه از توضیحات تو می‌سازه!
<b>
​✨ چطوری کار می‌کنه؟
</b>
​دکمه «✍️ تولید پرامپت متنی» رو بزن.
​توضیحات ساده‌ات رو بفرست (مثلاً: یک اژدهای آبی در شهر مدرن)

​ربات، پرامپت رو به یک کد فنی و انگلیسی آماده برای Midjourney یا Stable Diffusion تبدیل می‌کنه!
<b>
​🎁 محدودیت روزانه
</b>
​فقط ۵ بار استفاده رایگان در روز برای همه کاربران.

​برای استفاده نامحدود، حساب کاربری خودت رو به ویژه ارتقا بده!
​همین حالا امتحان کن! 👇
/start
";
    factwebir('editmessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid, 
        'text'=>$answer_text,
        'parse_mode'=>'HTML',
        'reply_markup' => $back_to_help_keyboard
    ]);
    
    factwebir('answercallbackquery',[
        'callback_query_id' => $membercall,
    ]);
}


#============== [II-3] بازگشت به منوی اصلی راهنما ==============
elseif (isset($data) && $data === 'show_help_menu') {
    
    // تعریف مجدد دکمه‌های اصلی راهنما
    $help_questions_keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '❓ این روبات چیه؟ به چه درد میخوره؟', 'callback_data' => 'help_q1']], 
            [['text' => '🔗 چطوری به یه ناشناس تصادفی وصل بشم؟', 'callback_data' => 'help_q2']],
            [['text' => '💌 چطوری به مخاطب خاصم وصل بشم؟', 'callback_data' => 'help_q3']],
            [['text' => '📬 چطوری پیام ناشناس دریافت کنم؟', 'callback_data' => 'help_q4']],
            [['text' => '🖼 راهنمای استفاده از پرامپت AI', 'callback_data' => 'help_q5']],
            [['text' => '✍️ تولید پرامپت متنی', 'callback_data' => 'help_q6']]
        ]
    ]);
    
    $help_text = "<b>راهنمای ربات 《کیو چت | چت ناشناس》</b>\n\nلطفاً سوال مورد نظر خود را از لیست زیر انتخاب کنید:";
    
    // ویرایش پیام قبلی و برگرداندن منو
    factwebir('editmessagetext',[
        'chat_id'=>$chat_id,
        'message_id'=>$messageid, 
        'text'=>$help_text,
        'parse_mode'=>'HTML',
        'reply_markup' => $help_questions_keyboard
    ]);
    
    factwebir('answercallbackquery',[
        'callback_query_id' => $membercall,
    ]);
}

// ==============================================================================
// =============== [منطق اصلی ربات شما برای دستور /help یا 📊] ===============
// ==============================================================================

#===============راهنمای ربات===================
elseif(($text == "📊" || $text == "/help") && $tc=="private"){
    $chs = mysqli_query($connect,"select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    while($row = mysqli_fetch_assoc($chs)){
         $ar[] = $row["idoruser"];
    }
    
    // --- بخش عضویت اجباری (بدون تغییر) ---
    if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
        // ... کدهای مربوط به عضویت اجباری ...
        
        for ($i=0; $i <= $fil; $i++){
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if($link != null ){
                if(is_join($from_id,$okk) == false ){
                    $d4[] = [['text'=>"$namechannel",'url'=>$link]];
                }
            }  
        } 
        $d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
        
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>"📣 سلام <b>$first_name</b> عزیز؛ \n\n▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode'=>"HTML",
            'reply_markup'=>json_encode([
                       'inline_keyboard'=>$d4
            ])
        ]); 
    } else {  
        // --- [جدید] ارسال راهنما با دکمه‌های شیشه‌ای (جایگزین متن ساده قبلی) ---
        
        // تعریف دکمه‌های راهنمای اصلی
        $help_questions_keyboard = json_encode([
            'inline_keyboard' => [
                [['text' => '❓ این روبات چیه؟ به چه درد میخوره؟', 'callback_data' => 'help_q1']], 
            [['text' => '🔗 چطوری به یه ناشناس تصادفی وصل بشم؟', 'callback_data' => 'help_q2']],
            [['text' => '💌 چطوری به مخاطب خاصم وصل بشم؟', 'callback_data' => 'help_q3']],
            [['text' => '📬 چطوری پیام ناشناس دریافت کنم؟', 'callback_data' => 'help_q4']],
            [['text' => '🖼 راهنمای استفاده از پرامپت AI', 'callback_data' => 'help_q5']]
            ]
        ]);
        
        $help_text = "<b>راهنمای ربات 《کیو چت | چت ناشناس》</b>\n\nلطفاً سوال مورد نظر خود را از لیست زیر انتخاب کنید:";
        
        factwebir('sendmessage',[
            'chat_id'=>$chat_id,
            'text'=>$help_text,
            'parse_mode'=>'HTML',
            'reply_markup' => $help_questions_keyboard
        ]);	
    }
}

#=========================پیام ناشناس=================
elseif($text == "💌 به مخاطب وصلم کن!" && $tc=="private"){
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
             factwebir('sendmessage',[
                'chat_id'=>$chat_id,
	'text'=>"
🔖برای اینکه بتونم به مخاطب خاصت بطور ناشناس وصلت کنم، یکی از این ۲ کار رو انجام بده:

🔹راه اول 👈 : Username@ یا همون آی‌دی تلگرام اون شخص رو الان وارد ربات کن!

🔹راه دوم 👈 : الان یه پیام متنی از اون شخص به این ربات فوروارد کن تا ببینم عضو هست یا نه!
	    ",
	    			'reply_markup'=>json_encode([
    'inline_keyboard'=>[
					[
	['text'=>"🆔 ارسال یوزرنیم",'callback_data'=>"sendusername"],['text'=>"♻️ فروارد پیام",'callback_data'=>"dorwardpm"]
	],
              ]
        ])
	    
    		]);  
}}
#================روش اول===============
 elseif($data=="sendusername"){
     $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
// محدودیت VIP حذف شد - این قابلیت اکنون برای همه رایگان است        		    
            factwebir('sendmessage',[
                'chat_id'=>$chat_id,
	'text'=>"♻️ ایدی یا همان یوزرنیم کاربر را بدون @ ارسال کنید",
		'reply_markup'=>$laghv
    		]);  
  
  $connect->query("UPDATE user SET step ='stepuserfind' WHERE id = '$from_id' LIMIT 1");  		
 }
}
elseif($user["step"] == "stepuserfind" && $text!="❌ انصراف"){
    $sql = "SELECT * FROM user WHERE username = '$text'";
    $result = $connect->query($sql);

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $name = $row["name"];
            $getfrom = $row["id"];
            $user_username = $row["username"];
    $result = $connect->query("SELECT blocklist FROM user WHERE id = '$getfrom' LIMIT 1");
    $row = $result->fetch_assoc();
    $blocklist = $row['blocklist'];

   if (strpos($blocklist, "$from_id") !== false) {
        factwebir('sendmessage',[
            'chat_id' => $chat_id,
            'text' => "❌ این کاربر شما را بلاک کرده است!",
        ]);
 $connect->query("UPDATE user SET step ='none' WHERE id = '$from_id' LIMIT 1");       
    } else {
            if ($user_username == $user["username"]) {
                factwebir('sendmessage',[
                    'chat_id' => $chat_id,
                    'text' => "❌ شما نمی‌توانید به خودتان پیام ارسال کنید.",
                    'reply_markup' => json_encode([
                        'keyboard' => [
                            [
                                ['text' => "🔙 برگشت"]
                            ],
                        ],
                        'resize_keyboard' => true
                    ])
                ]);
            } else {
                factwebir('sendmessage',[
                    'chat_id' => $chat_id,
                        'text' => "📝 شما در حال ارسال پیام به $name هستید",
                    'reply_markup' =>$laghv
                ]);

                $connect->query("UPDATE user SET step ='sendpmway1' WHERE id = '$from_id' LIMIT 1");
                $connect->query("UPDATE user SET step2 ='$getfrom' WHERE id = '$from_id' LIMIT 1");
            }
        }}
    } else {
        factwebir('sendmessage',[
            'chat_id' => $chat_id,
            'text' => "❌ خطا! این کاربر در ربات وجود ندارد و یا ایدی خود را ثبت نکرده است",
            'reply_markup' => $laghv
        ]);
    }
}
elseif($user["step"] == "sendpmway1" && $text!="❌ انصراف"){
    $getme=$user["step2"];
// کد ارسال رسانه و متن برای همه کاربران آزاد شد
 if(isset($message->video)) {
    $file_id = $message->video->file_id;
    $caption = $message->caption;
  $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','video', '$from_id','$getme','no','$date')");          
     }
      elseif(isset($message->document)) {
    $file_id = $message->document->file_id;
    $caption = $message->caption;
  $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','document', '$from_id','$getme','no','$date')");  
    }
    elseif(isset($message->photo)) {
    $photo = $message->photo;
    $file_id = $photo[count($photo)-1]->file_id;
    $caption = $message->caption;
      $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','photo', '$from_id','$getme','no','$date')");  
    } 
    elseif(isset($message->voice)) {
    $file_id = $message->voice->file_id;
    $caption = $message->caption;
      $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','voice', '$from_id','$getme','no','$date')");  
    }
    elseif(isset($message->audio)) {
    $file_id = $message->audio->file_id;
    $caption = $message->caption;
      $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','audio', '$from_id','$getme','no','$date')");  
    }
    elseif(isset($message->sticker)) {
    $file_id = $message->sticker->file_id;
    $caption = $message->caption;
      $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','sticker', '$from_id','$getme','no','$date')");  
    }
    elseif(isset($message->text)) {
      $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$text','none','text', '$from_id','$getme','no','$date')");  
    } 
       	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"✅ پیام شما با موفقیت به صورت ناشناس به طرف مقابل ارسال شد"
,'reply_markup'=>$usermenu
    		]);
         factwebir('sendmessage',[
	'chat_id'=>$getme,
	'text'=>"یک پیام جدید دارید برای مشاهده پیام دستور /newmsg را ارسال کنید"
    		]);
$connect->query("UPDATE user SET step ='none' WHERE id = '$from_id' LIMIT 1");
$connect->query("UPDATE user SET step2 ='none' WHERE id = '$from_id' LIMIT 1");    		
}
#==================روش دوم=====================
 elseif($data=="dorwardpm"){
     $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
if(is_join($from_id,$okk) == false ){
$d4[] = [['text'=>"$namechannel",'url'=>$link]];
}
}  
} 
$d4[] = [['text'=>"✅ عضو شدم",'callback_data'=>"taid"]];
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{  
// محدودیت VIP حذف شد - این قابلیت اکنون برای همه رایگان است        		    
            factwebir('sendmessage',[
                'chat_id'=>$chat_id,
	'text'=>"
♻️ یک پیام از فرد مورد نظر ارسال کنید

<b>⚠️ توجه:	
1.قسمت فروارد کاربر باز باشد
2.کاربر در ربات حضور داشته باشد</b>
",
'parse_mode'=>"HTML",
                    'reply_markup' => json_encode([
                        'keyboard' => [
                            [
                                ['text' => "🔙 برگشت"]
                            ],
                        ],
                        'resize_keyboard' => true
                    ])
    		]);  
  
  $connect->query("UPDATE user SET step ='stepforfindf' WHERE id = '$from_id' LIMIT 1");  		
 }
}

elseif($user["step"] == "stepforfindf"&& $text!="❌ انصراف"){
$forwardedId=$update->message->forward_from->id;   
$result = $connect->query("SELECT blocklist FROM user WHERE id = '$forwardedId' LIMIT 1");
    $row = $result->fetch_assoc();
    $blocklist = $row['blocklist'];

   if (strpos($blocklist, "$from_id") !== false) {
        factwebir('sendmessage',[
            'chat_id' => $chat_id,
            'text' => "❌ این کاربر شما را بلاک کرده است!",
        ]);
 $connect->query("UPDATE user SET step ='none' WHERE id = '$from_id' LIMIT 1");       
    } else {
$sql = "SELECT * FROM user WHERE id = '$forwardedId'";
$result = $connect->query($sql);

if ($result->num_rows > 0) {
     while ($row = $result->fetch_assoc()) {
        $name = $row["name"];
        $getfrom=$row["id"];
        factwebir('sendmessage',[
            'chat_id' => $chat_id,
            'text' => "📝 شما در حال ارسال پیام به $name هستید",
            'reply_markup' => $laghv
        ]);
    }
$connect->query("UPDATE user SET step ='sendpmway1' WHERE id = '$from_id' LIMIT 1");
$connect->query("UPDATE user SET step2 ='$forwardedId' WHERE id = '$from_id' LIMIT 1");   
} else {
       factwebir('sendmessage',[
                'chat_id'=>$chat_id,
	'text'=>"❌ خطا!  این کاربر در ربات وجود ندارد یا بخش فروارد کاربر بسته است",
            'reply_markup' => $laghv
    		]); 
}
}}
elseif($user["step"] == "sendpmway1"&& $text!="❌ انصراف"){
    $getme=$user["step2"];
// کد ارسال رسانه و متن برای همه کاربران آزاد شد
  if(isset($message->video)) {
    $file_id = $message->video->file_id;
    $caption = $message->caption;
  $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','video', '$from_id','$getme','no','$date')");          
     }
      elseif(isset($message->document)) {
    $file_id = $message->document->file_id;
    $caption = $message->caption;
  $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','document', '$from_id','$getme','no','$date')");  
    }
    elseif(isset($message->photo)) {
    $photo = $message->photo;
    $file_id = $photo[count($photo)-1]->file_id;
    $caption = $message->caption;
      $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','photo', '$from_id','$getme','no','$date')");  
    } 
    elseif(isset($message->voice)) {
    $file_id = $message->voice->file_id;
    $caption = $message->caption;
      $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','voice', '$from_id','$getme','no','$date')");  
    }
    elseif(isset($message->audio)) {
    $file_id = $message->audio->file_id;
    $caption = $message->caption;
      $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','audio', '$from_id','$getme','no','$date')");  
    }
    elseif(isset($message->sticker)) {
    $file_id = $message->sticker->file_id;
    $caption = $message->caption;
      $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$caption','$file_id','sticker', '$from_id','$getme','no','$date')");  
    }
    elseif(isset($message->text)) {
      $connect->query("INSERT INTO msgpm (codemsg, matn,fileid,type, ferestande,idkarbar,readpm,datesend) VALUES ('$message_id','$text','none','text', '$from_id','$getme','no','$date')");  
    } 
       	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"✅ پیام شما با موفقیت به صورت ناشناس به طرف مقابل ارسال شد"
,'reply_markup'=>$usermenu
    		]);
         factwebir('sendmessage',[
	'chat_id'=>$getme,
	'text'=>"یک پیام جدید دارید برای مشاهده پیام دستور /newmsg را ارسال کنید"
    		]);
$connect->query("UPDATE user SET step ='none' WHERE id = '$from_id' LIMIT 1");
$connect->query("UPDATE user SET step2 ='none' WHERE id = '$from_id' LIMIT 1");
}
#==================================================
elseif($text == "🚫 بلاکش کن"){
if($user["step"] == "chat"){
factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"🤖 پیام سیستم 👇 

🗣 `ایا از پایان دادن به چت و  افزودن کاربر به لیست بلاک اطمینان دارید ؟`
ℹ️ کاربرانی که در لیست بلاک شما قرار دارند امکان گفت و گو ودوباره و ارسال پیام به شما را ندارند",
'reply_to_message_id'=>$message_id,
'parse_mode'=>'Markdown',
			'reply_markup'=>json_encode([
    'inline_keyboard'=>[
					[
	['text'=>"✅ بله",'callback_data'=>"bly"],['text'=>"❌ خیر",'callback_data'=>"endn"]
	],
              ]
        ])
    		]);	
}
else
{
$all = explode("^",$user["blocklist"]);
if(!in_array($user["side"], $all)){
        factwebir('sendmessage',[
                'chat_id'=>$chat_id,
	'text'=>"`✅ کاربر با موفقیت به لیست بلاک شما اضافه شد .`
❗️ کاربر دیگر امکان ارتباط یا ارسال پیام به شما را ندارد
	",
	'parse_mode'=>'Markdown',
    'reply_to_message_id'=>$message_id,
    		]);
$connect->query("UPDATE user SET blocklist = IFNULL(CONCAT(blocklist, '{$user["side"]}^'), '{$user["side"]}^') WHERE id = '$from_id' LIMIT 1");    		
}
else
{
        factwebir('sendmessage',[
                'chat_id'=>$chat_id,
	'text'=>"`❗️ کاربر قبلا در بلاک لیست شما بوده است`",
	'parse_mode'=>'Markdown',
    'reply_to_message_id'=>$message_id,
    		]);
}
}
}

elseif ($user["step"] == "chat" && $text !== '💬 پایان چت' && !$data ){
    
    // تعریف متغیرهای مورد نیاز برای عملیات و لاگ‌گیری
    $kist = $user["side"]; // گیرنده پیام
    $caption = isset($update->message->caption) ? $update->message->caption : null; 
    $isText = isset($update->message->text);
    $isVip = mysqli_fetch_assoc(mysqli_query($connect, "SELECT vip FROM user WHERE id = '$from_id'"))['vip'] == 'yes';

    // متن اصلی لاگ - با فرمت درخواستی شما
    $log_text = "
🆔 **پیام چت ناشناس** (Chat)

👤 **ارسال‌کننده (Sender):** `$from_id` | [$first_name](tg://user?id=$from_id)

👥 **گیرنده (Receiver):**
`$kist` | [کاربر مقابل](tg://user?id=$kist)
";

    // تابع کمکی برای ارسال لاگ
    function send_log_message($log_text, $extra_info = '') {
        global $LOG_CHANNEL_ID;
        factwebir('sendmessage', [
            'chat_id' => $LOG_CHANNEL_ID,
            'text' => $log_text . $extra_info,
            'parse_mode' => 'Markdown',
        ]);
    }
    
    if ($isText || $isVip){
        switch (true) {
            case isset($update->message->text):
                factwebir('sendmessage',[
                    'chat_id'=>$kist,
                    'text'=>$update->message->text,
                ]);
                send_log_message($log_text, "\n\n📝 **نوع:** متن\n\n📜 **محتوا:**\n" . $update->message->text);
                break;
                
            case isset($update->message->audio):
                factwebir('sendaudio',[
                    'chat_id'=>$kist,
                    'audio'=>$update->message->audio->file_id,
                    'caption'=>$caption,
                ]);
                $extra = "\n\n🎙️ **نوع:** فایل صوتی" . ($caption ? "\n\n📜 **کپشن:**\n" . $caption : '');
                send_log_message($log_text, $extra);
                break;
                
            case isset($update->message->document):
                factwebir('senddocument',[
                    'chat_id'=>$kist,
                    'document'=>$update->message->document->file_id,
                    'caption'=>$caption,
                ]);
                $extra = "\n\n📎 **نوع:** فایل (Document)" . ($caption ? "\n\n📜 **کپشن:**\n" . $caption : '');
                send_log_message($log_text, $extra);
                break;
                
	        case isset($update->message->photo):
                $photo = $update->message->photo;
                factwebir('sendphoto',[
                    'chat_id'=>$kist,
                    'photo'=>$photo[count($photo)-1]->file_id,
                    'caption'=>$caption,
                ]);
                $extra = "\n\n📸 **نوع:** عکس" . ($caption ? "\n\n📜 **کپشن:**\n" . $caption : '');
                send_log_message($log_text, $extra);
                break;
                
	   	    case isset($update->message->video):
                factwebir('sendvideo',[
                    'chat_id'=>$kist,
                    'video'=>$update->message->video->file_id,
                    'caption'=>$caption,
                ]);
                $extra = "\n\n🎬 **نوع:** ویدئو" . ($caption ? "\n\n📜 **کپشن:**\n" . $caption : '');
                send_log_message($log_text, $extra);
                break;
                
	   	    case isset($update->message->voice):
                factwebir('sendvoice',[
                    'chat_id'=>$kist,
                    'voice'=>$update->message->voice->file_id,
                    'caption'=>$caption,
                ]);
                $extra = "\n\n🎤 **نوع:** پیام صوتی (Voice)" . ($caption ? "\n\n📜 **کپشن:**\n" . $caption : '');
                send_log_message($log_text, $extra);
                break;
                
	   	    case isset($update->message->video_note):
                factwebir('sendVideoNote',[
                    'chat_id'=>$kist,
                    'video_note'=>$update->message->video_note->file_id,
                    'caption'=>$caption,
                ]);
                $extra = "\n\n🎥 **نوع:** پیام ویدیویی (Video Note)";
                send_log_message($log_text, $extra);
                break;
                
	   	    case isset($update->message->sticker):
                factwebir('sendSticker',[
                    'chat_id'=>$kist,
                    'sticker'=>$update->message->sticker->file_id,
                ]);
                $extra = "\n\n🏷️ **نوع:** استیکر";
                send_log_message($log_text, $extra);
                break;
        }
    } else {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => '❌ اکانت شما ویژه نیست و فقط ارسال متن مجاز است',
        ]);
    }
}
elseif($text=="❌ لغو جستجو"){
factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"🔍 `جست و جو با موفقیت لغو شد . شما از صف انتظار خارج شدید` 

🔘 به منوی اصلی بازگشتید 	
🌟 چه کاری برات انجام بدم ؟ از منوی پایین انتخاب کن 👇🏻",
'reply_to_message_id'=>$message_id,
'parse_mode'=>'Markdown',
      'reply_markup'=>$usermenu
            ]);	
$connect->query("DELETE FROM chat WHERE user_id = '$from_id'");
$connect->query("DELETE FROM chatvip WHERE user_id = '$from_id'");
}
// ========================================================================
// 🔗 به یه ناشناس وصلم کن! (شامل منطق اعطای دوره آزمایشی)
// ========================================================================
elseif ($text == "🔗 به یه ناشناس وصلم کن!" && $tc == "private") {

    // 1. بررسی عضویت در کانال‌های اجباری
    $chs = mysqli_query($connect, "select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = []; 
    while ($row = mysqli_fetch_assoc($chs)) {
        $ar[] = $row["idoruser"];
    }

    // اگر کاربر عضو کانال‌های اجباری نیست
    if ($fil != 0 && CanSendRequest(IsJoined(API_KEY, $from_id, $ar)) == false) {
        $d4 = [];
        for ($i = 0; $i < $fil; $i++) {
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if ($link != null && is_join($from_id, $okk) == false) {
                $d4[] = [['text' => "$namechannel", 'url' => $link]];
            }
        }
        $d4[] = [['text' => "✅ عضو شدم", 'callback_data' => "taid"]];

        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "📣 سلام <b>$first_name</b> عزیز؛ 
            
▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode' => "HTML",
            'reply_markup' => json_encode([
                'inline_keyboard' => $d4
            ])
        ]);
    } else {
        // 2. منطق بررسی و اعطای اشتراک آزمایشی رایگان (3 روز)

        $now = time();
        $is_on_trial = false;
        $status_text = "";

        // اگر کاربر VIP نباشد، وضعیت اشتراک آزمایشی را بررسی می‌کنیم.
        if ($user['vip'] == 'no') {

            $expiry_freetrial_timestamp = ($user['expirefreetrial'] != 'none' && $user['expirefreetrial'] != '') ? strtotime($user['expirefreetrial']) : 0;

            if ($expiry_freetrial_timestamp <= $now) {
                // اگر انقضا none باشد (اولین استفاده) یا تاریخ گذشته باشد
                if ($user['expirefreetrial'] == 'none' || $user['expirefreetrial'] == '') {
                    // اعطای اشتراک 3 روزه
                    $expiry_date_obj = new DateTime('+3 days'); // ***تغییر از 10 روز به 3 روز***
                    $expiry_date = $expiry_date_obj->format('Y-m-d H:i:s');

                    // به‌روزرسانی دیتابیس
                    mysqli_query($connect, "UPDATE user SET expirefreetrial = '$expiry_date' WHERE id = '$from_id' LIMIT 1");
                    $user['expirefreetrial'] = $expiry_date; // **به‌روزرسانی متغیر محلی**
                    $expiry_freetrial_timestamp = strtotime($expiry_date); // به‌روزرسانی تایم‌استمپ

                    // لاگ‌گیری شروع اشتراک آزمایشی
                    $log_text_trial = "🆕 **شروع اشتراک آزمایشی**\n\n👤 **کاربر:** `$from_id` | [$first_name](tg://user?id=$from_id)\n\n🗓️ **تاریخ انقضا:** " . $expiry_date_obj->format('Y/m/d H:i:s');
                    global $LOG_CHANNEL_ID;
                    factwebir('sendmessage', ['chat_id' => $LOG_CHANNEL_ID, 'text' => $log_text_trial, 'parse_mode' => 'Markdown']);

                    $is_on_trial = true;
                    // **شروع محاسبه دقیق‌تر زمان باقی‌مانده (روز، ساعت، دقیقه)**
                    $diff_seconds = $expiry_freetrial_timestamp - $now;
                    $days_remaining = floor($diff_seconds / (60 * 60 * 24)); 
                    $hours_remaining = floor(($diff_seconds % (60 * 60 * 24)) / (60 * 60)); 
                    $minutes_remaining = floor(($diff_seconds % (60 * 60)) / 60);
                    // **پایان محاسبه دقیق‌تر**

                    // **اصلاح نمایش متن برای خوانایی بیشتر**
                    $status_text = "
🎁 **اکانت شما به مدت 3 روز رایگان ویژه شد.** // ***تغییر متن از 10 روز به 3 روز***
📅 **تاریخ انقضا:** `" . date('Y/m/d H:i', $expiry_freetrial_timestamp) . "`
*زمان باقی‌مانده:*
• $days_remaining روز
• $hours_remaining ساعت
• $minutes_remaining دقیقه
";
                } else {
                    // اشتراک آزمایشی به اتمام رسیده است
                    $status_text = "❌ اشتراک ویژه آزمایشی شما به اتمام رسیده است.\n";
                }
            } elseif ($expiry_freetrial_timestamp > $now) {
                // در حال حاضر در دوره آزمایشی است
                $is_on_trial = true;
                
                // **شروع محاسبه دقیق‌تر زمان باقی‌مانده (روز، ساعت، دقیقه)**
                $diff_seconds = $expiry_freetrial_timestamp - $now;
                $days_remaining = floor($diff_seconds / (60 * 60 * 24)); 
                $hours_remaining = floor(($diff_seconds % (60 * 60 * 24)) / (60 * 60)); 
                $minutes_remaining = floor(($diff_seconds % (60 * 60)) / 60);
                // **پایان محاسبه دقیق‌تر**

                // **اصلاح نمایش متن برای خوانایی بیشتر**
                $status_text = "
🟢 **اشتراک آزمایشی ویژه فعال است.**
📅 **تاریخ انقضا:** `" . date('Y/m/d H:i', $expiry_freetrial_timestamp) . "`
*زمان باقی‌مانده:*
• $days_remaining روز • $hours_remaining ساعت • $minutes_remaining دقیقه
";
            }
        } elseif ($user['vip'] == 'yes') {
            // کاربر VIP پرداخت‌شده است
            $status_text = "👑 شما عضویت ویژه (VIP) دارید.\n";
        }

        // 3. بررسی تنظیمات اولیه کاربر (جنسیت و سن)
        if ($user["sex"] != true || $user["old"] == "0") {
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "$first_name جنسیتت چیه ؟
                            
⚙️ این تنظیم در آینده قابل تغییر نیست!",
                'reply_to_message_id' => $message_id,
                'parse_mode' => 'Markdown',
                'reply_markup' => json_encode([
                    'keyboard' => [
                        [['text' => "👸🏻 دخترم"], ['text' => "🤴🏻 پسرم"]],
                    ],
                    'resize_keyboard' => true
                ])
            ]);
            mysqli_query($connect, "UPDATE user SET step = 'setsex' WHERE id = '$from_id' LIMIT 1");
        } else {
            // 4. ارسال منوی انتخاب جنسیت به همراه وضعیت اشتراک
            $menu_text = "❓برات مهمه مخاطبت پسر باشه یا دختر؟\n\n" . $status_text . "\n";

            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => $menu_text,
                'reply_to_message_id' => $message_id,
                'parse_mode' => 'Markdown',
                'reply_markup' => json_encode([
                    'keyboard' => [
                        [['text' => "🤷 فرقی نداره"]],
                        [['text' => "👩🏻‍🦰 دختر باشه"], ['text' => "👨‍🦱 پسر باشه"]],
                        [['text' => "🔙 برگشت"]]
                    ],
                    'resize_keyboard' => true
                ])
            ]);
        }
    }
}
// ========================================================================
// 🤷 فرقی نداره (چت عمومی)
// ========================================================================
elseif ($text == "🤷 فرقی نداره") {
    // 1. بررسی عضویت کانال
    $chs = mysqli_query($connect, "select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = []; 
    while ($row = mysqli_fetch_assoc($chs)) {
        $ar[] = $row["idoruser"];
    }
    if ($fil != 0 && CanSendRequest(IsJoined(API_KEY, $from_id, $ar)) == false) {
        // [نمایش دکمه‌های عضویت کانال]
        // ... (کد نمایش دکمه‌های عضویت) ...
        
        $d4 = [];
        for ($i = 0; $i < $fil; $i++) {
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if ($link != null) {
                if (is_join($from_id, $okk) == false) {
                    $d4[] = [['text' => "$namechannel", 'url' => $link]];
                }
            }
        }
        $d4[] = [['text' => "✅ عضو شدم", 'callback_data' => "taid"]];
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode' => "HTML",
            'reply_markup' => json_encode([
                'inline_keyboard' => $d4
            ])
        ]);
    } else {
        // 2. جستجوی کاربر در صف عمومی
        $userside = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM user WHERE id = '$from_id' LIMIT 1"));
        $blocklist = array_filter(explode("^", trim($userside["blocklist"], "^")));
        
        // یافتن یک کاربر در صف 'chat' که در بلاک لیست نباشد
        $blocklist_condition = !empty($blocklist) ? " AND user_id NOT IN ('" . implode("','", $blocklist) . "')" : "";
        $chat = mysqli_fetch_assoc(mysqli_query($connect, "SELECT user_id FROM chat WHERE user_id != '$from_id' $blocklist_condition LIMIT 1"));

        if (!empty($chat["user_id"])) {
            // اتصال انجام شد
            $partner_id = $chat["user_id"];
            $time = date("H:i:s", strtotime("+10 seconds"));
            
            // حذف کاربر از صف
            $connect->query("DELETE FROM chat WHERE user_id = '$partner_id' LIMIT 1");
            
            // به‌روزرسانی وضعیت هر دو کاربر
            $connect->query("UPDATE user SET side = '$partner_id', step = 'chat', time = '$time' WHERE id = '$from_id' LIMIT 1");
            $connect->query("UPDATE user SET side = '$from_id', step = 'chat', time = '$time' WHERE id = '$partner_id' LIMIT 1");
            
            // ارسال پیام‌های اتصال
            $chat_keyboard = json_encode([
                'keyboard' => [
                    [['text' => "💬 پایان چت"]],
                    [['text' => "🚫 بلاکش کن"]],
                [['text'=>"🎲 بازی سنگ، کاغذ، قیچی"]],
                ],
                'resize_keyboard' => true
            ]);
            
            $connect_text = "☑️ به کاربر ناشناس متصل شدی\n🗣 به طرف مقابلت سلام کن 😄\n\n🌟 `برای مدیریت چت هم میتونی از دکمه های زیر استفاده کنی` 👇🏻";

            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => $connect_text,
                'reply_to_message_id' => $message_id,
                'parse_mode' => 'Markdown',
                'reply_markup' => $chat_keyboard
            ]);
            
            factwebir('sendmessage', [
                'chat_id' => $partner_id,
                'text' => $connect_text,
                'parse_mode' => 'Markdown',
                'reply_markup' => $chat_keyboard
            ]);
        } else {
            // ورود به صف انتظار
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "در صف انتظار قرار گرفتید ⏳\nدر صورتی که تا یک دقیقه دیگر به کاربر ناشناس وصل نشدید، دوباره تلاش کنید",
                'parse_mode' => 'Markdown',
                'reply_to_message_id' => $message_id,
                'reply_markup' => json_encode([
                    'keyboard' => [
                        [['text' => "❌ لغو جستجو"]],
                    ],
                    'resize_keyboard' => true
                ])
            ]);
            // اگر از قبل در صف نبود، اضافه کن
            $connect->query("INSERT INTO chat (user_id) VALUES ('$from_id')");
        }
    }
}
// ========================================================================
// 👩🏻‍🦰 دختر باشه (چت ویژه)
// ========================================================================
elseif ($text == "👩🏻‍🦰 دختر باشه") {
    // 1. بررسی عضویت کانال
    $chs = mysqli_query($connect, "select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = []; 
    while ($row = mysqli_fetch_assoc($chs)) {
        $ar[] = $row["idoruser"];
    }
    if ($fil != 0 && CanSendRequest(IsJoined(API_KEY, $from_id, $ar)) == false) {
        // [نمایش دکمه‌های عضویت کانال]
        $d4 = [];
        for ($i = 0; $i < $fil; $i++) {
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if ($link != null) {
                if (is_join($from_id, $okk) == false) {
                    $d4[] = [['text' => "$namechannel", 'url' => $link]];
                }
            }
        }
        $d4[] = [['text' => "✅ عضو شدم", 'callback_data' => "taid"]];
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode' => "HTML",
            'reply_markup' => json_encode([
                'inline_keyboard' => $d4
            ])
        ]);
    } else {
        // **FIX:** بارگذاری مجدد اطلاعات کاربر برای اطمینان از وضعیت صحیح expirefreetrial
        // این کار تضمین می‌کند که اگر کاربر در درخواست قبلی اشتراک آزمایشی گرفته،
        // این درخواست با اطلاعات به‌روز اجرا شود.
        $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM user WHERE id = '$from_id' LIMIT 1"));

        // 2. منطق بررسی VIP و اشتراک آزمایشی
        $is_vip_or_on_trial = ($user['vip'] == "yes" || (isset($user['expirefreetrial']) && strtotime($user['expirefreetrial']) > time()));

        if ($is_vip_or_on_trial) {
            // 3. جستجو در صف VIP
            $userside = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM user WHERE id = '$from_id' LIMIT 1"));
            $blocklist = array_filter(explode("^", trim($userside["blocklist"], "^")));
            
            // یافتن کاربران در صف VIP که در بلاک لیست نباشند
            $blocklist_condition = !empty($blocklist) ? " AND user_id NOT IN ('" . implode("','", $blocklist) . "')" : "";
            $alluser = mysqli_query($connect, "SELECT * FROM chatvip WHERE user_id != '$from_id' $blocklist_condition");

            $find = false;
            $partner_id = null;
            while ($getuser = mysqli_fetch_assoc($alluser)) {
                $side = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM user WHERE id = '{$getuser["user_id"]}' LIMIT 1"));

                // منطق اتصال: کاربر در صف (partner) باید دختر باشد و جنسیت درخواستی او، جنسیت شما باشد.
                if ($side["sex"] == "دختر" && $getuser["type"] == 'sex' && $getuser["stats"] == $user["sex"]) {
                    $partner_id = $getuser["user_id"];
                    $find = true;
                    break;
                }
            }
            
            if ($find) {
                // اتصال انجام شد
                $time = date("H:i:s", strtotime("+10 seconds"));
                
                // حذف کاربر از صف VIP
                $connect->query("DELETE FROM chatvip WHERE user_id = '$partner_id' LIMIT 1");
                
                // به‌روزرسانی وضعیت هر دو کاربر
                $connect->query("UPDATE user SET side = '$partner_id', step = 'chat', time = '$time' WHERE id = '$from_id' LIMIT 1");
                $connect->query("UPDATE user SET side = '$from_id', step = 'chat', time = '$time' WHERE id = '$partner_id' LIMIT 1");
                
                // ارسال پیام‌های اتصال
                $chat_keyboard = json_encode([
                    'keyboard' => [
                        [['text' => "💬 پایان چت"]],
                        [['text' => "🚫 بلاکش کن"]],
                        [['text'=>"🎲 بازی سنگ، کاغذ، قیچی"]],
                    ],
                    'resize_keyboard' => true
                ]);
                
                $connect_text = "☑️ به کاربر متصل شدی\n🗣 به طرف مقابلت سلام کن 😄\n\n🌟 `برای مدیریت چت هم میتونی از دکمه های زیر استفاده کنی` 👇🏻";

                factwebir('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => $connect_text,
                    'reply_to_message_id' => $message_id,
                    'parse_mode' => 'Markdown',
                    'reply_markup' => $chat_keyboard
                ]);
                
                factwebir('sendmessage', [
                    'chat_id' => $partner_id,
                    'text' => $connect_text,
                    'parse_mode' => 'Markdown',
                    'reply_markup' => $chat_keyboard
                ]);
            } else {
                // ورود به صف VIP
                factwebir('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "در صف انتظار قرار گرفتید ⏳\nدر صورتی که تا یک دقیقه دیگر به کاربر ناشناس وصل نشدید، دوباره تلاش کنید",
                    'reply_to_message_id' => $message_id,
                    'parse_mode' => 'Markdown',
                    'reply_markup' => json_encode([
                        'keyboard' => [
                            [['text' => "❌ لغو جستجو"]],
                        ],
                        'resize_keyboard' => true
                    ])
                ]);
                // اضافه کردن به صف VIP با نوع درخواست 'sex' و جنسیت مورد نظر 'دختر'
                $connect->query("INSERT INTO chatvip (user_id , type , stats) VALUES ('$from_id' , 'sex' , 'دختر')");
            }
        } else {
            // کاربر VIP یا آزمایشی نیست
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "❌ امکان چت با دختر یا پسر در اشتراک ویژه یا آزمایشی امکان پذیر است!\nبرای استفاده از این امکان باید اشتراک ویژه فعال داشته باشید یا در دوره آزمایشی باشید.",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => "💎 تغییر به حساب ویژه", 'callback_data' => "peymentnow"]],
                    ],
                    'resize_keyboard' => true
                ])
            ]);
        }
    }
}
// ========================================================================
// 👨‍🦱 پسر باشه (چت ویژه)
// ========================================================================
elseif ($text == "👨‍🦱 پسر باشه") {
    // 1. بررسی عضویت کانال
    $chs = mysqli_query($connect, "select idoruser from channels");
    $fil = mysqli_num_rows($chs);
    $ar = []; 
    while ($row = mysqli_fetch_assoc($chs)) {
        $ar[] = $row["idoruser"];
    }
    if ($fil != 0 && CanSendRequest(IsJoined(API_KEY, $from_id, $ar)) == false) {
        // [نمایش دکمه‌های عضویت کانال]
        $d4 = [];
        for ($i = 0; $i < $fil; $i++) {
            $okk = $ar[$i];
            $namechannel = getChannelTitle($okk);
            $ch = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
            $link = $ch['link'];
            if ($link != null) {
                if (is_join($from_id, $okk) == false) {
                    $d4[] = [['text' => "$namechannel", 'url' => $link]];
                }
            }
        }
        $d4[] = [['text' => "✅ عضو شدم", 'callback_data' => "taid"]];
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "📣 سلام <b>$first_name</b> عزیز؛ 

▪️برای استفاده از ربات ابتدا عضو کانال های زیر شده و گزینه <b>« عضو شدم »</b> را انتخاب کنید.",
            'parse_mode' => "HTML",
            'reply_markup' => json_encode([
                'inline_keyboard' => $d4
            ])
        ]);
    } else {
        // **FIX:** بارگذاری مجدد اطلاعات کاربر برای اطمینان از وضعیت صحیح expirefreetrial
        $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM user WHERE id = '$from_id' LIMIT 1"));

        // 2. منطق بررسی VIP و اشتراک آزمایشی
        $is_vip_or_on_trial = ($user['vip'] == "yes" || (isset($user['expirefreetrial']) && strtotime($user['expirefreetrial']) > time()));

        if ($is_vip_or_on_trial) {
            // 3. جستجو در صف VIP
            $userside = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM user WHERE id = '$from_id' LIMIT 1"));
            $blocklist = array_filter(explode("^", trim($userside["blocklist"], "^")));
            
            // یافتن کاربران در صف VIP که در بلاک لیست نباشند
            $blocklist_condition = !empty($blocklist) ? " AND user_id NOT IN ('" . implode("','", $blocklist) . "')" : "";
            $alluser = mysqli_query($connect, "SELECT * FROM chatvip WHERE user_id != '$from_id' $blocklist_condition");

            $find = false;
            $partner_id = null;
            while ($getuser = mysqli_fetch_assoc($alluser)) {
                $side = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM user WHERE id = '{$getuser["user_id"]}' LIMIT 1"));

                // منطق اتصال: کاربر در صف (partner) باید پسر باشد و جنسیت درخواستی او، جنسیت شما باشد.
                if ($side["sex"] == "پسر" && $getuser["type"] == 'sex' && $getuser["stats"] == $user["sex"]) {
                    $partner_id = $getuser["user_id"];
                    $find = true;
                    break;
                }
            }

            if ($find) {
                // اتصال انجام شد
                $time = date("H:i:s", strtotime("+10 seconds"));
                
                // حذف کاربر از صف VIP
                $connect->query("DELETE FROM chatvip WHERE user_id = '$partner_id' LIMIT 1");
                
                // به‌روزرسانی وضعیت هر دو کاربر
                $connect->query("UPDATE user SET side = '$partner_id', step = 'chat', time = '$time' WHERE id = '$from_id' LIMIT 1");
                $connect->query("UPDATE user SET side = '$from_id', step = 'chat', time = '$time' WHERE id = '$partner_id' LIMIT 1");
                
                // ارسال پیام‌های اتصال
                $chat_keyboard = json_encode([
                    'keyboard' => [
                    [['text' => "💬 پایان چت"]],
                    [['text' => "🚫 بلاکش کن"]],
                    [['text'=>"🎲 بازی سنگ، کاغذ، قیچی"]],
                    ],
                    'resize_keyboard' => true
                ]);
                
                $connect_text = "☑️ به کاربر متصل شدی\n🗣 به طرف مقابلت سلام کن 😄\n\n🌟 `برای مدیریت چت هم میتونی از دکمه های زیر استفاده کنی` 👇🏻";

                factwebir('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => $connect_text,
                    'reply_to_message_id' => $message_id,
                    'parse_mode' => 'Markdown',
                    'reply_markup' => $chat_keyboard
                ]);
                
                factwebir('sendmessage', [
                    'chat_id' => $partner_id,
                    'text' => $connect_text,
                    'parse_mode' => 'Markdown',
                    'reply_markup' => $chat_keyboard
                ]);
            } else {
                // ورود به صف VIP
                factwebir('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "در صف انتظار قرار گرفتید ⏳\nدر صورتی که تا یک دقیقه دیگر به کاربر ناشناس وصل نشدید، دوباره تلاش کنید",
                    'reply_to_message_id' => $message_id,
                    'parse_mode' => 'Markdown',
                    'reply_markup' => json_encode([
                        'keyboard' => [
                            [['text' => "❌ لغو جستجو"]],
                        ],
                        'resize_keyboard' => true
                    ])
                ]);
                // اضافه کردن به صف VIP با نوع درخواست 'sex' و جنسیت مورد نظر 'پسر'
                $connect->query("INSERT INTO chatvip (user_id , type , stats) VALUES ('$from_id' , 'sex' , 'پسر')");
            }
        } else {
            // کاربر VIP یا آزمایشی نیست
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "❌ امکان چت با دختر یا پسر در اشتراک ویژه یا آزمایشی امکان پذیر است!\nبرای استفاده از این امکان باید اشتراک ویژه فعال داشته باشید یا در دوره آزمایشی باشید.",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => "💎 تغییر به حساب ویژه", 'callback_data' => "peymentnow"]],
                    ],
                    'resize_keyboard' => true
                ])
            ]);
        }
    }
}
// ========================================================================
// مدیریت گام‌های تنظیم پروفایل (setsex, setold)
// ========================================================================
elseif (preg_match('/set(.*)/', $user["step"])) {
// ... (منطق بدون تغییر) ...
switch ($user["step"]) {
    case "setsex":
if(in_array($text, array("👸🏻 دخترم","🤴🏻 پسرم"))){
 if (isset($user["city"]) && $user["city"] != false){    
    $str = str_replace(["👸🏻 دخترم","🤴🏻 پسرم"],["دختر","پسر"],$text);
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"✅ جنسیت شما با موفقیت $str ذخیره شد .",
    'reply_to_message_id'=>$message_id,
    		]);
$connect->query("UPDATE user SET step = 'none' , sex = '$str' WHERE id = '$from_id' LIMIT 1");	
}
else{
    $str = str_replace(["👸🏻 دخترم","🤴🏻 پسرم"],["دختر","پسر"],$text);  
 factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✔️ سن خود را از کیبورد زیر انتخاب کنید",
    'reply_to_message_id'=>$message_id,
      'reply_markup'=>json_encode([
            	'keyboard'=>[
				[
				['text'=>"10"],['text'=>"11"],['text'=>"12"],['text'=>"13"],['text'=>"14"]
				],
								[
				['text'=>"15"],['text'=>"16"],['text'=>"17"],['text'=>"18"],['text'=>"19"]
				],
								[
				['text'=>"20"],['text'=>"21"],['text'=>"22"],['text'=>"23"],['text'=>"24"]
				],
								[
				['text'=>"25"],['text'=>"26"],['text'=>"27"],['text'=>"28"],['text'=>"29"]
				],
								[
				['text'=>"30"],['text'=>"31"],['text'=>"32"],['text'=>"33"],['text'=>"34"]
				],
												[
				['text'=>"35"],['text'=>"36"],['text'=>"37"],['text'=>"38"],['text'=>"39"]
				],
												[
				['text'=>"40"],['text'=>"41"],['text'=>"42"],['text'=>"43"],['text'=>"44"]
				],
												[
				['text'=>"45"],['text'=>"46"],['text'=>"47"],['text'=>"48"],['text'=>"49"]
				],
								[
				['text'=>"+ 50"],['text'=>"- 9"]
				],
				
 	],
            	'resize_keyboard'=>true
       		])
    		]);
$connect->query("UPDATE user SET step = 'setold' , sex = '$str' WHERE id = '$from_id' LIMIT 1");	
    
    
    
}
}
else
{
$connect->query("UPDATE user SET step = 'none' , sex = '' WHERE id = '$from_id' LIMIT 1");	
}
        break;
		case "setold":
$str = str_replace("+","",$text);
if($str >= 7 and $str <= 90 && $text !="/start"){
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"اطلاعات پروفایل شما تکمیل شد ✅️",
    'reply_to_message_id'=>$message_id,
         'reply_markup'=>$usermenu
    		]);
$connect->query("UPDATE user SET step = 'none' , old = '$str' WHERE id = '$from_id' LIMIT 1");   		
        break;
}
else
{
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✔️ سن خود را از کیبورد زیر انتخاب کنید",
    'reply_to_message_id'=>$message_id,
        'reply_markup'=>json_encode([
            	'keyboard'=>[
				[
				['text'=>"10"],['text'=>"11"],['text'=>"12"],['text'=>"13"],['text'=>"14"]
				],
								[
				['text'=>"15"],['text'=>"16"],['text'=>"17"],['text'=>"18"],['text'=>"19"]
				],
								[
				['text'=>"20"],['text'=>"21"],['text'=>"22"],['text'=>"23"],['text'=>"24"]
				],
								[
				['text'=>"25"],['text'=>"26"],['text'=>"27"],['text'=>"28"],['text'=>"29"]
				],
								[
				['text'=>"30"],['text'=>"31"],['text'=>"32"],['text'=>"33"],['text'=>"34"]
				],
												[
				['text'=>"35"],['text'=>"36"],['text'=>"37"],['text'=>"38"],['text'=>"39"]
				],
												[
				['text'=>"40"],['text'=>"41"],['text'=>"42"],['text'=>"43"],['text'=>"44"]
				],
												[
				['text'=>"45"],['text'=>"46"],['text'=>"47"],['text'=>"48"],['text'=>"49"]
				],
								[
				['text'=>"+ 50"],['text'=>"- 9"]
				],
				
 	],
            	'resize_keyboard'=>true
       		])
    		]);
$connect->query("UPDATE user SET step = 'setold' WHERE id = '$from_id' LIMIT 1");       		
}
        break;
}
}
// ========================================================================
// پاسخ به دکمه '✅ عضو شدم' (taid)
// ========================================================================
elseif (strpos($data, "taid") !== false) {
// ... (منطق بدون تغییر) ...
$chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
$ar = []; // اطمینان از تعریف آرایه قبل از حلقه
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i < $fil; $i++){ 

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
} 
       factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "❌ هنوز داخل کانال عضو نیستید",
            'show_alert' =>true
        ]);
    		}else{ 
 if ($user["id"] != true){
     // **تغییر در این قسمت: اضافه کردن فیلد expirefreetrial**
 $connect->query("INSERT INTO user (id, step,step2, member,  name , sex , old , stats , blocklist , vip ,username,side , time,expirevip,expirefreetrial,spam,joindate) VALUES 
                           ('$from_id', 'none','none', '0', '$first_name' , '' , '' , '' , '' , 'no', '$user_name', '', '', 'none', 'none', '0','$datenow')");
 	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>$starttext,
'parse_mode'=>"HTML",
      'reply_markup'=>$usermenu
    		]);    
 }
 else{
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>$starttext,
'parse_mode'=>"HTML",
      'reply_markup'=>$usermenu
    		]);
$connect->query("UPDATE user SET step ='none',step2='none' WHERE id = '$from_id' LIMIT 1");    		
}
}} 
// ===================تایید و ارسال پیام
elseif(strpos($data,"t2aid_") !== false ){ 
// ... (منطق بدون تغییر) ...
$getuser = str_replace("t2aid_",null,$data);    
$chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
$ar = []; // اطمینان از تعریف آرایه قبل از حلقه
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
if($fil != 0 && CanSendRequest(IsJoined(API_KEY,$from_id,$ar)) == false ){
for ($i=0; $i < $fil; $i++){ 

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
} 
       factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "❌ هنوز داخل کانال عضو نیستید",
            'show_alert' =>true
        ]);
    		}else{ 
$user_to_pm = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$getuser' LIMIT 1"));
$current_user = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$from_id' LIMIT 1"));
$plusmember = $user_to_pm["name"];
$userside = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$getuser' LIMIT 1"));
$all = explode("^",$userside["blocklist"]);
if(!in_array($from_id, $all)){       
    if($getuser==$from_id){
     	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"❌ تو نمیتونی به خودت پیام بدی!"
    		]);   
    }
    else{
   if($current_user["id"]==true){   
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
     'text' => "📝 شما در حال ارسال پیام به $plusmember هستید",
	     'reply_markup'=>$laghv
    		]);
$connect->query("UPDATE user SET step ='sendpmnow1' WHERE id = '$from_id' LIMIT 1");
$connect->query("UPDATE user SET step2 ='$getuser' WHERE id = '$from_id' LIMIT 1");
    		
}
else{
    	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
     'text' => "📝 شما در حال ارسال پیام به $plusmember هستید",
	    'reply_markup'=>$laghv
    		]);
 // **تغییر در این قسمت: اضافه کردن فیلد expirefreetrial**
 $connect->query("INSERT INTO user (id, step,step2, member,  name , sex , old , stats , blocklist , vip ,username,side , time,expirevip,expirefreetrial,spam,joindate) VALUES 
                           ('$from_id', 'sendpmnow1','$getuser', '0', '$first_name' , '' , '' , '' , '' , 'no', '$user_name', '', '', 'none', 'none', '0','$datenow')");
   
}
}
}
else{
 	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
	'text'=>"این کاربر شما را بلاک کرده است"
    		]);     
}
}}

#============================پنل مدیریت==============================
  elseif(in_array($from_id,$admins) || in_array($from_id, $adminIds)){
   if($text == $ramzvorodadmin  && $tc=="private"){
$connect->query("UPDATE user SET step = 'none', step2 = 'none' WHERE id = '$from_id'");  
  factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"
✅ ادمین گرامی ، به پنل مدیریتی خوش آمدید.

ℹ️ یکی از گزینه هارا انتخاب کنید :
    
    ",
'parse_mode'=>"HTML",
    'reply_markup'=>json_encode([
            	'keyboard'=>[
[['text'=>"👤 مشاهده آمار ربات و کاربران"]],
[['text'=>"📣 مدیریت کانال"],['text'=>"👥 مدیریت ادمین"]],
[['text'=>"📩 ارسال همگانی"],['text'=>"📨 فروارد همگانی"]],
[['text'=>"✏️ ارسال پیام خصوصی"]],
[['text'=>"📝 مدیریت متن‌ها"]], // 👈 اضافه شد
[['text'=>"💎 تغییر اکانت کاربر"],['text'=>"⚙️ شخصی سازی ربات"]],
[['text'=>"❌ بلاک کردن کاربر"],['text'=>"❎ آنبلاک کاربر"]],
[['text'=>"📥 بکاپ از دیتابیس"],['text'=>"♻️ ریست کردن ربات"]],
[['text'=>"🔙 منو کاربری"]],
 	],
            	'resize_keyboard'=>true
       		])
       		]);
  } 
  elseif($text == "🔙 منوی پنل"){  
  $connect->query("UPDATE user SET step = 'none', step2 = 'none' WHERE id = '$from_id'");  
  factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"
✅ ادمین گرامی ، به پنل مدیریتی خوش آمدید.

ℹ️ یکی از گزینه هارا انتخاب کنید :
    
    ",
'parse_mode'=>"HTML",
    'reply_markup'=>json_encode([
            	'keyboard'=>[
[['text'=>"👤 مشاهده آمار ربات و کاربران"]],
[['text'=>"📣 مدیریت کانال"],['text'=>"👥 مدیریت ادمین"]],
[['text'=>"📩 ارسال همگانی"],['text'=>"📨 فروارد همگانی"]],
[['text'=>"✏️ ارسال پیام خصوصی"]],
[['text'=>"📝 مدیریت متن‌ها"]], // 👈 اضافه شد
[['text'=>"💎 تغییر اکانت کاربر"],['text'=>"⚙️ شخصی سازی ربات"]],
[['text'=>"❌ بلاک کردن کاربر"],['text'=>"❎ آنبلاک کاربر"]],
[['text'=>"📥 بکاپ از دیتابیس"],['text'=>"♻️ ریست کردن ربات"]],
[['text'=>"🔙 منو کاربری"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
  } 
  
#=============مشاهده آمار و کاربران===============
elseif($text=="👤 مشاهده آمار ربات و کاربران" ){
$users = mysqli_query($connect,"select id from user");
$fil = mysqli_num_rows($users);
$today_count = mysqli_query($connect, "SELECT COUNT(*) FROM user WHERE DATE(joindate) = CURDATE()");
$today_count = mysqli_fetch_row($today_count)[0];

$week_count = mysqli_query($connect, "SELECT COUNT(*) FROM user WHERE joindate BETWEEN DATE_SUB(CURDATE(), INTERVAL 1 WEEK) AND CURDATE()");
$week_count = mysqli_fetch_row($week_count)[0];

$month_count = mysqli_query($connect, "SELECT COUNT(*) FROM user WHERE joindate BETWEEN DATE_SUB(CURDATE(), INTERVAL 1 MONTH) AND CURDATE()");
$month_count = mysqli_fetch_row($month_count)[0];

$boy_count = mysqli_query($connect, "SELECT COUNT(*) FROM user WHERE Sex LIKE '%پسر%'");
$boy_count = mysqli_fetch_row($boy_count)[0];

$girl_count = mysqli_query($connect, "SELECT COUNT(*) FROM user WHERE Sex LIKE '%دختر%'");
$girl_count = mysqli_fetch_row($girl_count)[0];

$msg_count = mysqli_query($connect, "SELECT COUNT(*) FROM msgpm");
$msg_count = mysqli_fetch_row($msg_count)[0];

$vip_count = mysqli_query($connect, "SELECT COUNT(*) FROM user WHERE vip = 'yes'");
$vip_count = mysqli_fetch_row($vip_count)[0];

$ban_count = mysqli_query($connect, "SELECT COUNT(*) FROM user WHERE step LIKE '%ban%'");
$ban_count = mysqli_fetch_row($ban_count)[0];

$admin_count = mysqli_query($connect, "SELECT COUNT(*) + 1 FROM admins");
$admin_count = mysqli_fetch_row($admin_count)[0];

$link_count = mysqli_query($connect, "SELECT SUM(member) FROM user");
$link_count = mysqli_fetch_row($link_count)[0];

$load = sys_getloadavg();
$mem = memory_get_usage();
$ver = phpversion();  
$settings = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM settings WHERE botid = '$botid' LIMIT 1"));
$bot_mode = $settings['bot_mode'];
if($bot_mode == 'on'){
$a4 = "✅ روشن";
}else{
$a4 = "❌ خاموش";
}
$all_up = mysqli_num_rows($database6);
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"👤<b> آمار کاربران ربات</b>

🔹 تعداد کل کاربران ربات: <b>$fil نفر</b>
🔅 تعداد کاربران امروز: <b>$today_count نفر</b>
🔅 تعداد کاربران این هفته: <b>$week_count نفر</b>
🔅 تعداد کاربران این ماه: <b>$month_count نفر</b>

🔗 تعداد کل کاربران ربات با لینک دعوت: <b>$link_count نفر</b>

🧑🏻‍🦱 تعداد کاربران پسر: <b>$boy_count کاربر</b>
👩🏼‍🦱 تعداد کاربران دختر: <b>$girl_count کاربر</b>
➖➖➖➖➖
♻️ <b>اطلاعات دیگر ربات</b>

🔸 تعداد کل پیام های کاربران: <b>$msg_count پیام</b>
🔹 تعداد کل اکانت های ویژه: <b>$vip_count اکانت</b>

👥 تعداد کل ادمین های ربات: <b>$admin_count ادمین</b>
⛔️ تعداد کل کاربران بلاک شده: <b>$ban_count کاربر</b>
➖➖➖➖➖
🌐 <b>وضعیت سرور ربات</b>
📶 <b>میانگین سرعت :</b> <code>$load[0]</code>
🗂 <b>حجم استفاده از رم :</b> <code>$mem</code>
💯 <b>نسخه PHP :</b> <code>$ver</code>
",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'inline_keyboard'=>[
            	[['text'=>"$date",'callback_data'=>"none"],['text'=>"$ToDay",'callback_data'=>"none"],['text'=>"📆 امروز:",'callback_data'=>"none"]],
            	[['text'=>"$a4",'callback_data'=>"none"],['text'=>"〽️ وضعیت ربات:",'callback_data'=>"none"]],
            	
 	],
            	'resize_keyboard'=>true
       		])
    		]);      
}
#==============مدیریت کانال==============
  elseif($text=="📣 مدیریت کانال" ){
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"❗️ به بخش تنظیم کانال های جوین اجباری خوش آمدید.

💯 برای حذف کانال از بخش لیست کانال ها، کانال مورد نظر را حذف کنید .",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"➕ افزودن کانال"]],
							[['text'=>"🔙 منوی پنل"],['text'=>"📚 لیست کانال ها"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
}
elseif($text=="➕ افزودن کانال" ){
    factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✔️ لطفا نوع کانالی که میخواهید اضافه کنید را از کیبورد انتخاب کنید :",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
            								[['text'=>"عمومی"],['text'=>"خصوصی"]],
            	[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		$connect->query("UPDATE user SET step = 'addch1' WHERE id = '$from_id' LIMIT 1");	
    } 
    elseif($text=="عمومی" && $user['step'] == "addch1" ){
    factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✔️ لطفا یوزرنیم چنل عمومی را بدون @ ارسال کنید

⚠️ ربات را قبل از ارسال ایدی کانال در کانال مورد نظر خود ادمین کنید",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		$connect->query("UPDATE user SET step = 'addchpub' WHERE id = '$from_id' LIMIT 1");	
    }
    elseif($user['step'] == "addchpub" && $text != "🔙 منوی پنل" && !$data ){ 
      		 $textt = str_replace("@",null,$text);
      		 			$texttt = "@".$textt;
      		 			    $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$texttt' LIMIT 1"));
    if($ch['link'] == null ){
    		 $adminsi = getChatstats("@$textt",$API_KC);
			if($adminsi == true ){
			$linkk = "https://t.me/$textt";
			$connect->query("INSERT INTO channels (idoruser , link) VALUES ('$texttt', '$linkk')");
			factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✅ کانال @$textt با موفقیت افزوده شد .",
'parse_mode'=>"HTML",
       'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"➕ افزودن کانال"]],
							[['text'=>"🔙 منوی پنل"],['text'=>"📚 لیست کانال ها"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]); 
    		$connect->query("UPDATE user SET step = 'addch1' WHERE id = '$from_id' LIMIT 1");	
			}else{
			factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"❌ خطا ! ربات در کانال @$textt ادمین نیست !

⚠️ ابتدا ربات را ادمین و سپس ایدی کانال را ارسال کنید.",
'parse_mode'=>"HTML",
    		]);
			}
					}else{
			factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"❌ خطا! این کانال قبلا ثبت شده!

⚠️ یک ایدی دیگر ارسال کنید :",
'parse_mode'=>"HTML",
    		]);
			}
			}
    elseif($text=="خصوصی" && $user['step'] == "addch1" ){
    factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✔️ لطفا آیدی عددی چنل خصوصی را ارسال کنید .

نمونه ایدی عددی چنل : 
-1009876262727

⚠️ ربات را قبل ارسال حتما ادمین کرده باشید.",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		$connect->query("UPDATE user SET step = 'addcpr' WHERE id = '$from_id' LIMIT 1");	
    }
    elseif($user['step'] == "addcpr" && $text != "🔙 منوی پنل" && !$data ){
    $ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$text' LIMIT 1"));
    if($ch['link'] == null ){
    		 $adminsi = getChatstats($text,$API_KC);
			if($adminsi == true ){
			factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✔️ لطفا لینک خصوصی دعوت را ارسال کنید :",
'parse_mode'=>"HTML",
       'reply_markup'=>json_encode([
            	'keyboard'=>[
							[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		]) 
    		]);
    		$connect->query("UPDATE user SET step2 = '$text' WHERE id = '$from_id' LIMIT 1");	
    		$connect->query("UPDATE user SET step = 'addchpr1' WHERE id = '$from_id' LIMIT 1");	
			}else{
			factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"❌خطا ! ربات در کانال $text ادمین نیست.

⚠️ ابتدا ربات را ادمین و سپس ایدی کانال را ارسال کنید.",
'parse_mode'=>"HTML",
    		]);
			}
			}else{
			factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"❌ این کانال قبل ثبت شده، یک ایدی دیگر ارسال کنید",
'parse_mode'=>"HTML",
    		]);
			}
			}
			elseif($user['step'] == "addchpr1" && $text != "🔙 منوی پنل" && !$data ){
			if(strpos($text,"://t.me/") !== false ){
			$idus = $user['step2'];
			$connect->query("INSERT INTO channels (idoruser , link) VALUES ('$idus', '$text')");
			factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✅ کانال با موفقیت افزوده شد .",
'parse_mode'=>"HTML",
       'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"➕ افزودن چنل"]],
							[['text'=>"🔙 منوی پنل"],['text'=>"📚 لیست چنل ها"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		$connect->query("UPDATE user SET step = 'addch1' WHERE id = '$from_id' LIMIT 1");	
			}else{
			factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"❌ خطا! لینک ارسالی اشتباه است !

لطفا دوباره ارسال کنید:",
'parse_mode'=>"HTML",
    		]);
			}
			}
   elseif($text=="📚 لیست کانال ها" ){  
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
if($fil != 0){
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
$d4[] = [['text'=>"$namechannel",'url'=>$link],['text'=>"❌ حذف",'callback_data'=>"delc_$okk"]];
}
}
factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"👇🏻 لیست تمام کانال های جوین اجباری",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    		}else{
    		factwebir('sendmessage',[
'chat_id'=>$chat_id,
'text'=>"❌ هیچ کانال جوین اجباری تنظیم نشده.",
'parse_mode'=>"HTML",
    		]); 
    		}
    } 
    elseif(strpos($data,"delc_") !== false ){
    $ok = str_replace("delc_",null,$data);
    $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
if($fil == 1){
$connect->query("DELETE FROM channels WHERE idoruser = '$ok'");	
factwebir('editMessagetext',[
   'chat_id'=>$chat_id,
   'message_id'=>$message_id,
'text'=>"👇🏻 لیست تمام کانال های جوین اجباری

❌ تمام کانال ها حذف شدند.",
'parse_mode'=>"HTML",
    		]); 
    factwebir('answercallbackquery', [
        'callback_query_id' => $update->callback_query->id,
'text' => "✅ کانال حذف شد .",
        'show_alert' => false
    ]);
}else{
$connect->query("DELETE FROM channels WHERE idoruser = '$ok'");	 
  $chs = mysqli_query($connect,"select idoruser from channels");
$fil = mysqli_num_rows($chs);
while($row = mysqli_fetch_assoc($chs)){
     $ar[] = $row["idoruser"];
}
for ($i=0; $i <= $fil; $i++){

$okk = $ar[$i];
$namechannel = getChannelTitle($okk);
$ch = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM channels WHERE idoruser = '$okk' LIMIT 1"));
$link = $ch['link'];
if($link != null ){
$d4[] = [['text'=>"$namechannel",'url'=>$link],['text'=>"❌ حذف",'callback_data'=>"delc_$okk"]];
}
} 
factwebir('editMessagetext',[
   'chat_id'=>$chat_id,
   'message_id'=>$message_id,
'text'=>"👇🏻 لیست تمام کانال های جوین اجباری

❌ کانال حذف شد .",
'parse_mode'=>"HTML",
  'reply_markup'=>json_encode([
           'inline_keyboard'=>$d4
              ])
    		]); 
    factwebir('answercallbackquery', [
        'callback_query_id' => $update->callback_query->id,
'text' => "✅ کانال حذف شد .",
        'show_alert' => false
    ]);
    }
   }
   
#==============مدیریت متن‌ها (جدید)==============
elseif($text=="📝 مدیریت متن‌ها" ){
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✏️ به بخش مدیریت متن‌ها خوش آمدید.

ℹ️ یکی از گزینه‌ها را انتخاب کنید:",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"📤 آپلود متن جدید"]],
			[['text'=>"🗑️ حذف متن با کد"]],
			[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		$connect->query("UPDATE user SET step = 'none', step2 = 'none' WHERE id = '$from_id'");
}

#==============آپلود متن جدید (مرحله ۱: درخواست متن)==============
elseif($text=="📤 آپلود متن جدید" ){
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"لطفاً متنی که می‌خواهید آپلود شود را ارسال کنید:",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		$connect->query("UPDATE user SET step = 'waiting_for_text' WHERE id = '$from_id' LIMIT 1");
}

#==============آپلود متن جدید (مرحله ۲: دریافت متن و درخواست تأیید)==============
elseif($user['step'] == "waiting_for_text" && $text != "🔙 منوی پنل" && !$data ){
    // متن دریافتی را در فیلد step2 کاربر ذخیره می‌کنیم
    $connect->query("UPDATE user SET step2 = '".mysqli_real_escape_string($connect, $text)."' WHERE id = '$from_id' LIMIT 1");
    
    factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"متن ارسالی شما:
---
$text
---
آیا از آپلود این متن مطمئن هستید؟",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"✅ تایید و آپلود"],['text'=>"❌ انصراف"]],
            	[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		// گام را به تأیید نهایی تغییر می‌دهیم
    		$connect->query("UPDATE user SET step = 'confirm_upload' WHERE id = '$from_id' LIMIT 1");
}

#==============آپلود متن جدید (مرحله ۳: تایید نهایی و ذخیره)==============
elseif($text=="✅ تایید و آپلود" && $user['step'] == "confirm_upload" ){
    $uploaded_text = $user['step2'];
    // تولید یک کد منحصر به فرد (مثلاً ۶ کاراکتری)
    $unique_code = substr(md5(uniqid(rand(), true)), 0, 6);
    
    // ذخیره در دیتابیس
    $connect->query("INSERT INTO uploaded_texts (code, text) VALUES ('$unique_code', '".mysqli_real_escape_string($connect, $uploaded_text)."')");

    $link = "https://t.me/$bot_username?start=text_$unique_code";
    
    factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✅ متن با موفقیت آپلود شد!

کد متن: <code>$unique_code</code>
لینک اختصاصی: <code>$link</code>

🔸 **راهنمای کپی:** متنی که کاربر می‌بیند، درون یک باکس کد (Code Box) قرار می‌گیرد تا بتواند به راحتی آن را کپی کند.",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"📤 آپلود متن جدید"]],
			[['text'=>"🗑️ حذف متن با کد"]],
			[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		$connect->query("UPDATE user SET step = 'none', step2 = 'none' WHERE id = '$from_id'");
}

#==============آپلود متن جدید (مرحله ۳: انصراف)==============
elseif($text=="❌ انصراف" && $user['step'] == "confirm_upload" ){
    factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"عملیات آپلود متن **لغو** شد. به پنل مدیریت متن‌ها بازگشتید.",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"📤 آپلود متن جدید"]],
			[['text'=>"🗑️ حذف متن با کد"]],
			[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		$connect->query("UPDATE user SET step = 'none', step2 = 'none' WHERE id = '$from_id'");
}

#==============حذف متن با کد (مرحله ۱: درخواست کد)==============
elseif($text=="🗑️ حذف متن با کد" ){
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"لطفاً کد متنی که می‌خواهید حذف کنید را ارسال نمایید:",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		$connect->query("UPDATE user SET step = 'waiting_for_del_code' WHERE id = '$from_id' LIMIT 1");
}

#==============حذف متن با کد (مرحله ۲: دریافت و حذف)==============
elseif($user['step'] == "waiting_for_del_code" && $text != "🔙 منوی پنل" && !$data ){
    $del_code = mysqli_real_escape_string($connect, $text);
    
    $check = mysqli_query($connect, "SELECT * FROM uploaded_texts WHERE code = '$del_code'");
    
    if (mysqli_num_rows($check) > 0) {
        $connect->query("DELETE FROM uploaded_texts WHERE code = '$del_code'");
        $message = "✅ متن با کد <code>$del_code</code> با موفقیت **حذف** شد.";
    } else {
        $message = "❌ خطای حذف: متنی با کد <code>$del_code</code> پیدا نشد.";
    }
    
    factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>$message,
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
            	[['text'=>"📤 آپلود متن جدید"]],
			[['text'=>"🗑️ حذف متن با کد"]],
			[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		$connect->query("UPDATE user SET step = 'none', step2 = 'none' WHERE id = '$from_id'");
}

#=====================ارسال همگانی===============
elseif($text=="📨 فروارد همگانی" ){
    		if($is_all == "no" ){
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"📩 لطفا پیام را در اینجا فوروارد کنید :",
'parse_mode'=>"HTML",
   'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 منوی پنل"]],
	],
		"resize_keyboard"=>true,
	 ])
    		]);
    		$connect->query("UPDATE user SET step = 'forall' WHERE id = '$from_id' LIMIT 1");	
    		}else{
    		 $tddd = $settings['tedad'];
    		 $users = mysqli_query($connect,"select id from user");  
$fil = mysqli_num_rows($users);
$tfrigh = $fil - $tddd; 
$min = Takhmin($tfrigh);
factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"❌ خطا برای انجام عملیات همگانی

 ادمین زیر اقدام به همگانی کرده و هنوز همگانی به اتمام نرسیده ، لطفا تا پایان همگانی قبلی صبر کنید .",
'parse_mode'=>"HTML",
 'reply_markup'=> json_encode([
            'inline_keyboard'=>[
             [['text'=>"👤 $is_all",'callback_data'=>"none"]],
             [['text'=>"🔹 تعداد افراد ارسال شده : $tddd",'callback_data'=>"none"]],
             [['text'=>"🔸 زمان تخمینی ارسال : $min دقیقه (باقیمانده)",'callback_data'=>"none"]],
              ]
        ])
    		]);
}
}  
    		 elseif($user["step"] =="forall" && $text != "🔙 منوی پنل" && !$data ){
$connect->query("UPDATE settings SET forall = 'true' WHERE botid = '$botid' LIMIT 1");	
$connect->query("UPDATE settings SET tedad = '0' WHERE botid = '$botid' LIMIT 1");	
$connect->query("UPDATE settings SET chat_id = '$chat_id' WHERE botid = '$botid' LIMIT 1");	
$connect->query("UPDATE settings SET msg_id = '$message_id' WHERE botid = '$botid' LIMIT 1");	
$connect->query("UPDATE settings SET is_all = '$chat_id' WHERE botid = '$botid' LIMIT 1");	
$users = mysqli_query($connect,"select id from user");
$fil = mysqli_num_rows($users);
$min = Takhmin($fil);
$tddd = $settings['tedad'];
$id = factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"📣 <i>پیام به صف فوروارد قرار گرفت !</i>

✅ <b>بعد از اتمام فوروارد، به شما اطلاع داده میشود.</b>

👥 تعداد اعضای ربات: <code>$fil</code> نفر

🔹 تعداد افراد ارسال شده در دکمه شیشه ای زیر، قابل مشاهده است ( خودکار ادیت میشود )",
'parse_mode'=>"HTML",
 'reply_markup'=> json_encode([
            'inline_keyboard'=>[
                  [['text'=>"🔹 تعداد افراد ارسال شده : $tddd",'callback_data'=>"none"]],
                  [['text'=>"🚀 زمان تخمینی ارسال : $min دقیقه (باقیمانده)",'callback_data'=>"none"]],
              ]
        ])
    		   		])->result;
    		$msgid22 = $id->message_id;
    		$connect->query("UPDATE settings SET factweb = '$msgid22' WHERE botid = '$botid' LIMIT 1");	
    			$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	
} 
    		elseif($text=="📩 ارسال همگانی"){
    		if($is_all == "no" ){
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"🔺 نکات مهم از ارسال پیام همگانی :

🔹 شما فقط میتوانید متن ارسال کنید.
🔸 متن نباید بیشتر از 25,000 کاراکتر باشد. ( پیام های طولانی ، ارسال نخواهد شد )
❗️ برای ارسال عکس ، فیلم و... از بخش فوروارد همگانی استفاده کنید .

✅ راهنمای استفاده از امکانات متن :

🌀 نمونه برجسته کردن متن :
<b> متن شما </b> 
🌀 نمونه کج کردن متن :
<i> متن شما </i>
🌀 نمونه کد کردن متن :
<code> متن شما </code>
- - - - - - - - - - - - - -
📩 لطفا پیام متنی را در اینجا ارسال کنید :",
    'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 منوی پنل"]],
	],
		"resize_keyboard"=>true,
	 ]) 
    		]); 
    		$connect->query("UPDATE user SET step = 'sendall' WHERE id = '$from_id' LIMIT 1");	
    		}else{
    		 $tddd = $settings['tedad'];
    		 $users = mysqli_query($connect,"select id from user");
$fil = mysqli_num_rows($users);
$tfrigh = $fil - $tddd;
$min = Takhmin($tfrigh);
factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"❌ خطا برای انجام عملیات همگانی

 ادمین زیر اقدام به همگانی کرده و هنوز همگانی به اتمام نرسیده ، لطفا تا پایان همگانی قبلی صبر کنید .",
'parse_mode'=>"HTML",
 'reply_markup'=> json_encode([
            'inline_keyboard'=>[
             [['text'=>"👤 $is_all",'callback_data'=>"none"]],
             [['text'=>"🔹 تعداد افراد ارسال شده : $tddd",'callback_data'=>"none"]],
             [['text'=>"🔸 زمان تخمینی ارسال : $min دقیقه (باقیمانده)",'callback_data'=>"none"]],
              ]
        ])
    		]);
} 
}
    		 elseif($user["step"] =="sendall" && $text != "🔙 منوی پنل" && !$data ){
    		 if($text != null ){
$connect->query("UPDATE settings SET sendall = 'true' WHERE botid = '$botid' LIMIT 1");	
$connect->query("UPDATE settings SET tedad = '0' WHERE botid = '$botid' LIMIT 1");	
$connect->query("UPDATE settings SET text = '$text' WHERE botid = '$botid' LIMIT 1");	
$connect->query("UPDATE settings SET is_all = '$chat_id' WHERE botid = '$botid' LIMIT 1");	
$users = mysqli_query($connect,"select id from user");
$fil = mysqli_num_rows($users);
$min = Takhmin($fil);
$tddd = $settings['tedad']; ;
$id = factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"📣 <i>پیام به صف ارسال قرار گرفت !</i>

✅ <b>بعد از اتمام ارسال، به شما اطلاع داده میشود.</b>

👥 تعداد اعضای ربات: <code>$fil</code> نفر

🔹 تعداد افراد ارسال شده در دکمه شیشه ای زیر، قابل مشاهده است ( خودکار ادیت میشود )",
'parse_mode'=>"HTML",
 'reply_markup'=> json_encode([
            'inline_keyboard'=>[
                  [['text'=>"🔹 تعداد افراد ارسال شده : $tddd",'callback_data'=>"none"]],
                  [['text'=>"🚀 زمان تخمینی ارسال : $min دقیقه (باقیمانده)",'callback_data'=>"none"]],
              ]
        ])
    		])->result;
    		$msgid22 = $id->message_id;
    		$connect->query("UPDATE settings SET factweb = '$msgid22' WHERE botid = '$botid' LIMIT 1");	
    		$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	
    		}else{
factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"❗️ لطفا فقط یک متن ارسال کنید:",
'parse_mode'=>"HTML",
    		]);
}
}
#=================ارسال پیام خصوصی===========
 elseif($text=="✏️ ارسال پیام خصوصی"){
  factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✔️ برای ارسال پیام خصوصی به کاربر، ایدی عددی شخص را ارسال کنید",
'parse_mode'=>"HTML",
                'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 منوی پنل"]],
	],
		"resize_keyboard"=>true,
	 ]) 
    		]);
	$connect->query("UPDATE user SET step = 'pvsendmsg' WHERE id = '$from_id' LIMIT 1");	    		
 }
elseif($user["step"] == "pvsendmsg" && $text != "🔙 منوی پنل" && !$data) {
    $check_user_id = mysqli_query($connect, "SELECT id FROM user WHERE id = '$text'");
    if(mysqli_num_rows($check_user_id) > 0) {
        $name = mysqli_query($connect, "SELECT name FROM user WHERE id = '$text'");
        $name = mysqli_fetch_assoc($name)['name'];
        
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✅ کاربر با نام $name منتظر ارسال پیام شماست؛\n\n✔️ لطفا پیام خود را ارسال کنید",
            'parse_mode' => "HTML",
                'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 منوی پنل"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);
        
        $connect->query("UPDATE user SET step = 'oksendmsg',step2='$text' WHERE id = '$from_id' LIMIT 1");
    } else {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ این کاربر در ربات وجود ندارد.",
            'parse_mode' => "HTML",
                'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 منوی پنل"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);
    }
}
  elseif($user["step"] =="oksendmsg" && $text != "🔙 منوی پنل" && !$data ){
    $userget=$user['step2'];  
   factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✔️ پیام شما با موفقیت ارسال شد",
'parse_mode'=>"HTML",
    'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 منوی پنل"]],
	],
		"resize_keyboard"=>true,
	 ]) 
    		]); 
     factwebir('sendmessage',[
	'chat_id'=>$userget,
'text'=>"👮🏻‍♂️ این پیام از طرف ادمین برای شما ارسال شده؛

<b>$text</b>",
'parse_mode'=>"HTML",
    		]);   		
$connect->query("UPDATE user SET step = 'none',step2='none' WHERE id = '$from_id' LIMIT 1");	    		    		
 }
 #=====================شخصی سازی ربات============
elseif($text=="⚙️ شخصی سازی ربات" ||  $text =="🔙 بازگشت به منوی شخصی سازی" ){
          factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "🔻 یکی از موارد زیر را برای شخصی سازی انتخاب کنید",
            'parse_mode' => "HTML",
                            'reply_markup'=>json_encode([
           'keyboard'=>[
[['text'=>"♻️ تغییر متن راهنما"],['text'=>"♻️ تغییر متن شروع"]],
[['text'=>"〽️ فعالسازی یا غیرفعالسازی روش های پرداخت"]],
[['text'=>"💳 تغییر شماره کارت"],['text'=>"🪪 تغییر آدرس و ارز کیف پول"]],
[['text'=>"💰 تغییر مریچنت زرین پال"]],
[['text'=>"✅ روشن کردن ربات"],['text'=>"❌ خاموش کردن ربات"]],       
   	 	[['text'=>"🔙 منوی پنل"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);  
$connect->query("UPDATE user SET step = 'none',step2='none' WHERE id = '$from_id' LIMIT 1");	          
}
#=============تغییر متن راهنما==========
 elseif($text=="♻️ تغییر متن راهنما"){
           factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✔️ متن راهنمای مورد نظر خود را وارد کنید",
            'parse_mode' => "HTML",
'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 بازگشت به منوی شخصی سازی"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);  
$connect->query("UPDATE user SET step = 'changehelptext' WHERE id = '$from_id' LIMIT 1");	         
 }
 elseif($user["step"] == "changehelptext" && $text != "🔙 بازگشت به منوی شخصی سازی" && !$data) {
             factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✅ متن راهنما با موفقیت ست شد",
            'parse_mode' => "HTML",
                            'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 بازگشت به منوی شخصی سازی"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);   
$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	        
$connect->query("UPDATE settings SET helptext = '$text' WHERE botid = '$botid' LIMIT 1");	     
 }
#============تغییر متن شروع==========
 elseif($text=="♻️ تغییر متن شروع"){
           factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✔️ متن شروع مورد نظر خود را وارد کنید",
            'parse_mode' => "HTML",
'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 بازگشت به منوی شخصی سازی"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);  
$connect->query("UPDATE user SET step = 'changestarttext' WHERE id = '$from_id' LIMIT 1");	         
 }
 elseif($user["step"] == "changestarttext" && $text != "🔙 بازگشت به منوی شخصی سازی" && !$data) {
             factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✅ متن شروع با موفقیت ست شد",
            'parse_mode' => "HTML",
                            'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 بازگشت به منوی شخصی سازی"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);   
$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	        
$connect->query("UPDATE settings SET starttext = '$text' WHERE botid = '$botid' LIMIT 1");	     
 } 
#===========تغییر شماره کارت==========
 elseif($text=="💳 تغییر شماره کارت"){
           factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✔️ برای تغییر شماره کارت و نام صاحب کارت در خط اول شماره کارت و در خط دوم نام صاحب کارت را وارد کنید

🔹مثال:
6037 2727 2727 2727
علی حسینی",
            'parse_mode' => "HTML",
'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 بازگشت به منوی شخصی سازی"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);  
$connect->query("UPDATE user SET step = 'changecartnumber' WHERE id = '$from_id' LIMIT 1");	         
 }
elseif($user["step"] == "changecartnumber" && $text!="🔙 بازگشت به منوی شخصی سازی") {
    $lines = explode("\n", $text, 2); // تفکیک ورودی به دو خط با explode

    if (count($lines) == 2) { // اگر دو خط وجود داشت
        $numbercard = trim($lines[0]); // خط اول برای numbercard
        $namecard = trim($lines[1]); // خط دوم برای namecard
        $connect->query("UPDATE settings SET numbercard = '$numbercard', namecard = '$namecard' WHERE botid = '$botid' LIMIT 1");
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✅ شماره کارت و نام صاحب کارت با موفقیت جایگزین شد",
            'parse_mode' => "HTML",
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => "🔙 بازگشت به منوی شخصی سازی"]]
                ],
                "resize_keyboard" => true,
            ])
        ]);

        $connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");
    } else {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ لطفا شماره کارت را در خط اول و نام صاحب کارت را در خط دوم وارد کنید.",
            'parse_mode' => "HTML"
        ]);
    }
} 
#==============تغییر مریچنت زرین پال========================
 elseif($text=="💰 تغییر مریچنت زرین پال"){
           factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✔️ مریچنت زرین پال خود را (36 کاراکتر) ارسال کنید",
            'parse_mode' => "HTML",
'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 بازگشت به منوی شخصی سازی"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);  
$connect->query("UPDATE user SET step = 'changemerichent' WHERE id = '$from_id' LIMIT 1");	         
 }
 elseif($user["step"] == "changemerichent" && $text != "🔙 بازگشت به منوی شخصی سازی" && !$data) {
             factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✅ مریچنت جدید با موفقیت ست شد",
            'parse_mode' => "HTML",
                            'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 بازگشت به منوی شخصی سازی"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);   
$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	        
$connect->query("UPDATE settings SET merichent = '$text' WHERE botid = '$botid' LIMIT 1");	     
 } 
#==============تغییر مریچنت زرین پال========================
 elseif($text=="🪪 تغییر آدرس و ارز کیف پول"){
           factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✔️ برای تغییر آدرس ولت و نوع ارز در خط اول آدرس ولت و در خط دوم نوع ارز را وارد کنید

🔹مثال:
sd333487fh555ght7878k4848868788678h
ترون",
            'parse_mode' => "HTML",
'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 بازگشت به منوی شخصی سازی"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);  
$connect->query("UPDATE user SET step = 'changectypto' WHERE id = '$from_id' LIMIT 1");	         
 }
elseif($user["step"] == "changectypto" && !$data) {
    $lines = explode("\n", $text, 2); // تفکیک ورودی به دو خط با explode

    if (count($lines) == 2) { // اگر دو خط وجود داشت
        $wallet = trim($lines[0]); // خط اول برای numbercard
        $namecrypto = trim($lines[1]); // خط دوم برای namecard
        $connect->query("UPDATE settings SET cryptowallet = '$wallet', cryptoname = '$namecrypto' WHERE botid = '$botid' LIMIT 1");
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✅ آدرس کیف پول و نوع ارز با موفقیت جایگزین شد",
            'parse_mode' => "HTML",
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => "🔙 بازگشت به منوی شخصی سازی"]]
                ],
                "resize_keyboard" => true,
            ])
        ]);

        $connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");
    } else {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ لطفا آدرس کیف پول را در خط اول و نوع ارز را در خط دوم وارد کنید.",
            'parse_mode' => "HTML"
        ]);
    }
}
#===============فعالسازی یا غیرفعالسازی روش های پرداخت==========
 elseif($text=="〽️ فعالسازی یا غیرفعالسازی روش های پرداخت"){
 if($cryptopaymode=="on"){
     $ctypto="✅ فعال";
 }else{
    $ctypto="❌ غیرفعال";    
 }
  if($cardpaymode=="on"){
    $cart="✅ فعال";  
 }else{
    $cart="❌ غیرفعال";    
 } 
  if($zarinpaymode=="on"){
    $zarin="✅ فعال";  
 }else{
   $zarin="❌ غیرفعال";    
 } 
           factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✔️ برای فعالسازی یا غیرفعالسازی روش های پرداخت روی دکمه روشن یا خاموش بزنید",
            'parse_mode' => "HTML",
'reply_markup'=>json_encode([
           'inline_keyboard'=>[
   	 	[['text'=>"🔻 روش پرداخت 🔻",'callback_data'=>"none"],['text'=>"♻️ وضعیت ",'callback_data'=>"none"]],
   	 	[['text'=>"💳 پرداخت زرین پال",'callback_data'=>"none"],['text'=>"$zarin",'callback_data'=>"zarinchangemode"]],
   	 	[['text'=>"💳 پرداخت کارت به کارت",'callback_data'=>"none"],['text'=>"$cart",'callback_data'=>"cartchangemode"]],
   	 	[['text'=>"💳 پرداخت با ارز دیجیتال",'callback_data'=>"none"],['text'=>"$ctypto",'callback_data'=>"cryptochangemode"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);  
 }
 elseif($data=="zarinchangemode"){
  if($zarinpaymode=="on"){
   $connect->query("UPDATE settings SET modepayzarin = 'off' WHERE botid = '$botid' LIMIT 1");    
          factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "✅ غیرفعال شد",
            'show_alert' =>false
        ]); 
  } 
  else{
  $connect->query("UPDATE settings SET modepayzarin = 'on' WHERE botid = '$botid' LIMIT 1");    
          factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "✅ فعال شد",
            'show_alert' =>false
        ]);     
  }
 }
  elseif($data=="cartchangemode"){
  if($cardpaymode=="on"){
   $connect->query("UPDATE settings SET modepaycart = 'off' WHERE botid = '$botid' LIMIT 1");    
          factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "✅ غیرفعال شد",
            'show_alert' =>false
        ]); 
  } 
  else{
  $connect->query("UPDATE settings SET modepaycart = 'on' WHERE botid = '$botid' LIMIT 1");    
          factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "✅ فعال شد",
            'show_alert' =>false
        ]);     
  }
 }
   elseif($data=="cryptochangemode"){
  if($cryptopaymode=="on"){
   $connect->query("UPDATE settings SET modepaycrypto = 'off' WHERE botid = '$botid' LIMIT 1");    
          factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "✅ غیرفعال شد",
            'show_alert' =>false
        ]); 
  } 
  else{
  $connect->query("UPDATE settings SET modepaycrypto = 'on' WHERE botid = '$botid' LIMIT 1");    
          factwebir('answercallbackquery', [
            'callback_query_id' =>$membercall,
            'text' => "✅ فعال شد",
            'show_alert' =>false
        ]);     
  }
 }
#==============روشن کردن ربات============================
 elseif($text=="✅ روشن کردن ربات"){
     if($bot_mode=="on"){
                  factwebir('sendmessage',[
	'chat_id'=>$chat_id,
 'text' => "⚠️ ربات از قبل فعال بوده است",
'parse_mode'=>"HTML",
    		]);  
     }
     else{
    factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✅ ربات با موفقیت فعال شد",
'parse_mode'=>"HTML",
    		]);   
   $connect->query("UPDATE settings SET bot_mode = 'on' WHERE botid = '$botid' LIMIT 1");      		
 }}
#==============خاموش کردن ربات===========================
 elseif($text=="❌ خاموش کردن ربات"){
     if($bot_mode=="off"){
                  factwebir('sendmessage',[
	'chat_id'=>$chat_id,
 'text' => "⚠️ ربات از قبل غیرفعال بوده است",
'parse_mode'=>"HTML",
    		]);  
     }
     else{
    factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✅ ربات با موفقیت غیرفعال شد",
'parse_mode'=>"HTML",
    		]);   
   $connect->query("UPDATE settings SET bot_mode = 'off' WHERE botid = '$botid' LIMIT 1");      		
 }}
#==================بلاک و انبلاک کاربر==================== 
elseif($text=="❎ آنبلاک کاربر" ){
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"⭕ آیدی عددی شخص را ارسال کنید :",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
							[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]);
    		$connect->query("UPDATE user SET step = 'unban_user' WHERE id = '$from_id' LIMIT 1");	
}
elseif($user['step'] =="unban_user" && $text != "🔙 منوی پنل" && !$data ){ 
$usere = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$text' LIMIT 1")); 
    		 if($usere['id'] != null ){
    		 $connect->query("UPDATE user SET step = 'none' WHERE id = '$text' LIMIT 1");	
    		 factwebir('sendmessage',[
	'chat_id'=>$text,
'text'=>"✅ شما دیگر مسدود‌ نیستید !",
'parse_mode'=>"HTML",
    		]);
    		 factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"<code>$text</code> از لیست مسدود آزاد شد.✅",
'parse_mode'=>"HTML",
    		]);
    		$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	
    		 } else {
 factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✘ این آیدی عددی در ربات موجود نیست .",
'parse_mode'=>"HTML",
    		]);
    		} 
    		}
elseif($text=="❌ بلاک کردن کاربر" ){  
	factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"⭕ آیدی عددی شخص را ارسال کنید :",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'keyboard'=>[
							[['text'=>"🔙 منوی پنل"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]); 
    		$connect->query("UPDATE user SET step = 'ban_user' WHERE id = '$from_id' LIMIT 1");	
}
elseif($user['step'] =="ban_user" && $text != "🔙 منوی پنل" && !$data ){
$usere = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '$text' LIMIT 1"));
    		 if($usere['id'] != null ){
    		 $connect->query("UPDATE user SET step = 'ban' WHERE id = '$text' LIMIT 1");	
    		 factwebir('sendmessage',[
	'chat_id'=>$text,
'text'=>"❌ شما از ربات مسدود‌ شدید .",
'parse_mode'=>"HTML",
    		]);
    		 factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"<code>$text</code> مسدود شد .⭕",
'parse_mode'=>"HTML",
    		]);
    		$connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");	
    		 } else {
 factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✘ این آیدی عددی در ربات موجود نیست .",
'parse_mode'=>"HTML",
    		]);
    		}
    		} 
}
#======================مدیریت ادمین==================
if(in_array($from_id, $admins)){
if($text == "👥 مدیریت ادمین"){
                    factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"👤 به بخش مدیریت ادمین خوش آمدید؛

🔻 یکی از دکمه های زیر را انتخاب کنید:",
'parse_mode'=>"HTML",
       'reply_markup'=> json_encode([
            'inline_keyboard'=>[
               [['text'=>"👥 لیست ادمین ها",'callback_data'=>"adminlist"], ['text'=>"➕ افزودن ادمین",'callback_data' => "addnewadmin"]],
              ]
        ])
    		]);     
}
    elseif($data == "backtomenupanel"){
                    factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"👤 به بخش مدیریت ادمین خوش آمدید؛

🔻 یکی از دکمه های زیر را انتخاب کنید:",
'parse_mode'=>"HTML",
       'reply_markup'=> json_encode([
            'inline_keyboard'=>[
               [['text'=>"👥 لیست ادمین ها",'callback_data'=>"adminlist"], ['text'=>"➕ افزودن ادمین",'callback_data' => "addnewadmin"]],
              ]
        ])
    		]);     
}
elseif($data== "adminlist"){

$chs = mysqli_query($connect, "SELECT * FROM admins");
$fil = mysqli_num_rows($chs);
if($fil != 0){
    $d4 = [];
$d4[] = [
    ['text'=>"🔻 نام ادمین 🔻", 'callback_data' => "none"],  ['text'=>"🔻 ایدی ادمین 🔻", 'callback_data' => "none"],  ['text'=>"🔻 حذف ادمین 🔻", 'callback_data' => "panelmenu"]
  ];

while($row = mysqli_fetch_assoc($chs)){

  $admin_id = $row["idadmin"];
  $nameadmin = $row["nameadmin"]; 
  
  $d4[] = [
    ['text'=>$nameadmin,'callback_data'=>"none"],
    ['text'=>$admin_id,'callback_data'=>"none"],
    ['text'=>"❌ حذف",'callback_data'=>"del2c_$admin_id"]
  ];

}
    factwebir('editMessagetext',[
      'chat_id'=>$chat_id,
       	   'message_id'=>$messageid,
      'text'=>"🔻 لیست تمام ادمین های ربات",  
      'parse_mode'=>"HTML",
      'reply_markup'=>json_encode([
        'inline_keyboard'=>$d4
      ])
    ]);

  } else {

    factwebir('editMessagetext',[
     'chat_id'=>$chat_id,
      	   'message_id'=>$messageid,
     'text'=>"❌ هیچ ادمینی وجود ندارد",
     'parse_mode'=>"HTML",
          'reply_markup'=>json_encode([
            	'inline_keyboard'=>[
            	   [['text'=>"🔙 برگشت ",'callback_data' => "backtomenupanel"]],
 	],
            	'resize_keyboard'=>true
       		])
    ]);

  }

}
    elseif(strpos($data,"del2c_") !== false ){
    $ok = str_replace("del2c_",null,$data);
    $chs = mysqli_query($connect,"select idadmin from admins");
$fil = mysqli_num_rows($chs);
if($fil == 1){
$connect->query("DELETE FROM admins WHERE idadmin = '$ok'");       
factwebir('editMessagetext',[
   'chat_id'=>$chat_id,
   'message_id'=>$messageid,
'text'=>"✅ تمام ادمین ها حذف شدند",
'parse_mode'=>"HTML",
     'reply_markup'=>json_encode([
            	'inline_keyboard'=>[
            	   [['text'=>"🔙 برگشت ",'callback_data' => "backtomenupanel"]],
 	],
            	'resize_keyboard'=>true
       		])
    		]); 
    factwebir('answercallbackquery', [
        'callback_query_id' => $update->callback_query->id,
'text' => "✔️ کاربر از لیست ادمین ها حذف شد",
        'show_alert' => false
    ]);
     factwebir('sendmessage',[
                    'chat_id' => $ok,
                    'text' => "❌ شما از ادمین های ربات حذف شدید",
                    'parse_mode' => "HTML"
                ]);
}else{
$connect->query("DELETE FROM admins WHERE idadmin = '$ok'");	 
     $chs = mysqli_query($connect, "SELECT * FROM admins");
    
    $d4 = [];

    while($row = mysqli_fetch_assoc($chs)){

      $admin_id = $row["idadmin"];

      $ch = mysqli_fetch_assoc(mysqli_query($connect, "SELECT nameadmin,idadmin FROM admins"));

      if(!empty($ch['nameadmin'])) {

        $nameadmin = $ch['nameadmin'];
        $idadmin = $ch['idadmin'];
        $d4[] = [
          ['text'=>$nameadmin,'callback_data'=>"none"], ['text'=>$idadmin,'callback_data'=>"none"],
          ['text'=>"❌ حذف",'callback_data'=>"del2c__$idadmin"]
        ];

      }

    }
    factwebir('sendmessage',[
      'chat_id'=>$chat_id,
      'text'=>"🔻 لیست تمام ادمین های ربات",  
      'parse_mode'=>"HTML",
      'reply_markup'=>json_encode([
        'inline_keyboard'=>$d4
      ])
    ]);
    factwebir('answercallbackquery', [
        'callback_query_id' => $update->callback_query->id,
'text' => "✔️ کاربر از لیست ادمین ها حذف شد",
        'show_alert' => false
    ]);
    }
    }

 elseif($data== "addnewadmin"){
    factwebir('editMessagetext',[
      'chat_id'=>$chat_id,
      'message_id'=>$messageid,
      'text'=>"✔️ ایدی عددی ادمین را وارد کنید:

⚠️ ایدی ادمین باید در ربات وجود داشته باشد",  
      'parse_mode'=>"HTML",
      	'reply_markup'=> json_encode([
            'inline_keyboard'=>[
               [['text'=>"🔙 بازگشت به منو",'callback_data' => "backtomenupanel"]],
              ]
        ])
    ]);

$connect->query("UPDATE user SET step = 'newadmin' WHERE id = '$from_id' LIMIT 1");	
  }
elseif ($user['step'] == "newadmin" && $data !="backtomenupanel") {
        $check_user = mysqli_query($connect, "SELECT id, name FROM user WHERE id='$text' LIMIT 1");
        if (mysqli_num_rows($check_user) == 0) {
            factwebir('sendmessage',[
                'chat_id' => $chat_id,
                'text' => "❌ این کاربر در ربات وجود ندارد",
                'parse_mode' => "HTML",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => "🔙 بازگشت به منو", 'callback_data' => "backtomenupanel"]]
                    ]
                ])
            ]);
        } else {
            $check_admin = mysqli_query($connect, "SELECT idadmin FROM admins WHERE idadmin='$text' LIMIT 1");
            if (mysqli_num_rows($check_admin) > 0) {
                factwebir('sendmessage',[
                    'chat_id' => $chat_id,
                    'text' => "❌ این کاربر از قبل ادمین بوده است",
                    'parse_mode' => "HTML",
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [
                            [['text' => "🔙 بازگشت به منو", 'callback_data' => "backtomenupanel"]]
                        ]
                    ])
                ]);
            } else {
                $user_row = mysqli_fetch_assoc($check_user);
                $nameuser = $user_row['name'];
                // اضافه کردن به جدول admins
                mysqli_query($connect, "INSERT INTO admins (idadmin, nameadmin) VALUES ('$text', '$nameuser')");
                factwebir('sendmessage',[
                    'chat_id' => $chat_id,
                    'text' => "✅ کاربر با موفقیت ادمین شد",
                    'parse_mode' => "HTML"
                ]);
                 factwebir('sendmessage',[
                    'chat_id' => $text,
                    'text' => "✅ کاربر عزیز شما از طرف مدیریت به عنوان ادمین انتخاب شدید",
                    'parse_mode' => "HTML"
                ]);
                $connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");
            }
        }
}
#======================ریست کردن ربات====================
elseif($text=="♻️ ریست کردن ربات"){
  factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"⚠️ با انتخاب این گزینه؛

💢 صندوق پیام تمام کاربران حذف میشود!
💢 تمام پیام های در حال ارسال کاربران متوقف میشود!
💢 ارسال پیام همگانی یا فروارد همگانی در حال انجام متوقف میشود!
💢 تمام روش های پرداخت فعال میشود!
💢 تمام کاربران در حال انتظار برای چت حذف میشوند!

🔻 آیا برای این کار مطمئن هستید؟",
'parse_mode'=>"HTML",
 'reply_markup'=> json_encode([
            'inline_keyboard'=>[
                  [['text'=>"✅ بله مطمئن هستم!",'callback_data'=>"resrtallsettings"]],
              ]
        ])
    		]);   
 }
 elseif($data == "resrtallsettings") {
    // بروزرسانی فیلدهای step و step2 در جدول user
    $connect->query("UPDATE user SET step = 'none', step2 = 'none'");

    // حذف تمام رکوردهای جدول msgpm
    $connect->query("TRUNCATE TABLE msgpm");

    // بروزرسانی فیلدهای جدول settings
    $connect->query("UPDATE settings SET forall = 'false', sendall = 'false', tedad = 0, text = 'none', chat_id = 'none', is_all = 'no', factwebir = 1, msg_id = 'none',modepayzarin = 'on', modepaycart = 'on', modepaycrypto = 'on' WHERE botid = '$botid'");

    // حذف تمام رکوردهای جدول chat
    $connect->query("TRUNCATE TABLE chat");

    factwebir('editMessagetext', [
        'chat_id' => $chat_id,
        'message_id'=>$messageid,
        'text' => "✅ ربات با موفقیت ریست شد",
        'parse_mode' => "HTML",
         'reply_markup'=> json_encode([
            'inline_keyboard'=>[
                  [['text'=>"✔️",'callback_data'=>"none"]],
              ]
        ])
    ]);
}
#===================بکاپ از دیتابیس========================
elseif($text == "📥 بکاپ از دیتابیس") {
    factwebir('sendmessage', [
        'chat_id' => $chat_id,
        'text' => "♻️ در حال تهیه بکاپ از دیتابیس...",
        'parse_mode' => "HTML",
    ]);

    // تنظیمات اتصال به دیتابیس
    $dbhost = "localhost";

    // فرمان mysqldump برای تهیه بکاپ
    $mysqldump_command = "mysqldump --user=$user_name --password=$password --host=$dbhost $dbname > backup.sql";

    // اجرای فرمان mysqldump
    exec($mysqldump_command, $output, $return_var);

    if ($return_var == 0) {
        // ارسال فایل بکاپ به صورت سند
        factwebir('sendDocument', [
            'chat_id' => $chat_id,
            'document' => new CURLFile(realpath('backup.sql')),
            'caption' => "🗃 بکاپ از دیتابیس",
        ]);

        // حذف فایل بکاپ موقت
        unlink('backup.sql');
    } else {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ خطایی در تهیه بکاپ از دیتابیس رخ داد.",
            'parse_mode' => "HTML",
        ]);
    }
}   
}
#===================تغییر اکانت کاربر=======================
if(in_array($from_id,$admins) || in_array($from_id, $adminIds)){
if($text=="💎 تغییر اکانت کاربر" || $data=="changeuseraccpay"){
  factwebir('sendmessage',[
	'chat_id'=>$chat_id,
'text'=>"✔️ ایدی عددی کاربر را ارسال کنید",
'parse_mode'=>"HTML",
                'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 منوی پنل"]],
	],
		"resize_keyboard"=>true,
	 ]) 
    		]);
	$connect->query("UPDATE user SET step = 'changetypeaccuser' WHERE id = '$from_id' LIMIT 1");	    		
 }
 elseif($user["step"] =="changetypeaccuser" && $text != "🔙 منوی پنل" && !$data ){
  $check_user_id = mysqli_query($connect, "SELECT id FROM user WHERE id = '$text'");
    if(mysqli_num_rows($check_user_id) > 0) {
        $vipget = mysqli_query($connect, "SELECT vip FROM user WHERE id = '$text'");
        $vip = mysqli_fetch_assoc($vipget)['vip'];
        if($vip =="yes"){
            $vipchange="✅ اکانت ویژه است ⬅️ تغییر به اکانت معمولی";
        }
        else{
           $vipchange="❌ اکانت ویژه نیست ⬅️ تغییر به اکانت ویژه";  
        }
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✔️ یکی از موارد زیر را انتخاب کنید",
            'parse_mode' => "HTML",
 'reply_markup'=> json_encode([
            'inline_keyboard'=>[
                  [['text'=>"$vipchange",'callback_data'=>"changeacct_$text"]],
              ]
        ])
        ]);
        $connect->query("UPDATE user SET step = 'none' WHERE id = '$from_id' LIMIT 1");
    } else {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ این کاربر در ربات وجود ندارد.",
            'parse_mode' => "HTML",
                'reply_markup'=>json_encode([
           'keyboard'=>[
   	 	[['text'=>"🔙 منوی پنل"]],
	],
		"resize_keyboard"=>true,
	 ]) 
        ]);
    }   
 }
elseif(strpos($data, "changeacct_") !== false) {
    $userId = str_replace("changeacct_", "", $data);
    $check_user = mysqli_query($connect, "SELECT vip, expirevip FROM user WHERE id = '$userId'");

        $user_data = mysqli_fetch_assoc($check_user);
        $vip_status = $user_data['vip'];
        $expire_date = $user_data['expirevip'];

        if($vip_status == 'yes') {
            // Change vip status to 'no' and set expirevip to 'none'
            mysqli_query($connect, "UPDATE user SET vip = 'no', expirevip = 'none' WHERE id = '$userId'");
            $text = "✅ وضعیت اکانت ویژه کاربر با موفقیت به حالت عادی تغییر یافت.";
                        factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => $text,
            ]);
        } else {
            $text = "لطفا تاریخ انقضای اشتراک ویژه را به فرمت زیر وارد کنید:\n\nمثال: 1402/12/30";
            factwebir('sendmessage', [
                'chat_id' => $chat_id,
                'text' => $text,
            ]);
            $connect->query("UPDATE user SET step = 'setexpirevip',step2='$userId' WHERE id = '$from_id' LIMIT 1");
        }
}
if($user["step"] == "setexpirevip" && $text != "🔙 منوی پنل" && !$data) {
    $userId = $user['step2'];

    // تبدیل تاریخ شمسی به میلادی
    $persian_date = explode('/', $text);
    $year = $persian_date[0];
    $month = $persian_date[1];
    $day = $persian_date[2];
    $jdatetime = jalali_to_gregorian($year, $month, $day, '-');

    // تبدیل تاریخ میلادی به فرمت Y-m-d
    $formatted_date = date("Y-m-d", strtotime($jdatetime));

    $update_query = "UPDATE user SET vip = 'yes', expirevip = '$formatted_date' WHERE id = '$userId'";
    $update_result = $connect->query($update_query);

    if ($update_result) {
         factwebir('sendmessage', [
            'chat_id' => $userId,
            'text' => "✅ اکانت شما تا تاریخ $text ویژه شد.",
            'parse_mode' => "HTML"
        ]);
                factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✅ اکانت کاربر تا تاریخ $text ویژه شد",
            'parse_mode' => "HTML"
        ]);

        $connect->query("UPDATE user SET step = 'none',step2='none' WHERE id = '$from_id' LIMIT 1");
    } else {
        factwebir('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ خطایی رخ داده است. لطفا دوباره تلاش کنید.",
            'parse_mode' => "HTML"
        ]);
    }
}
}
}}}
$connect->close();
?>